/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.maven.plugins.i18n;

import com.github.robtimus.maven.plugins.i18n.License;
import com.github.robtimus.maven.plugins.i18n.MessageFormatArgumentTypesFinder;
import com.github.robtimus.maven.plugins.i18n.StringFormatArgumentTypesFinder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class I18N {
    private I18N() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    public static final class FTLHelper {
        static final Collection<String> KEYWORDS = Collections.unmodifiableCollection(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
        static final Collection<String> LITERALS = Collections.unmodifiableCollection(Arrays.asList("true", "false", "null"));

        public String varName(Node node) {
            String name = node.name();
            if (!this.canUseName(name)) {
                name = '_' + name;
            }
            return name;
        }

        public String className(Node node, Collection<String> classNames) {
            String className = this.className(node);
            while (classNames.contains(className)) {
                className = className + '_';
            }
            return className;
        }

        private String className(Node node) {
            String name = node.name();
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1) + '_';
            if (!this.canUseName(node.name())) {
                name = '_' + name;
            }
            return name;
        }

        private boolean canUseName(String name) {
            return Character.isJavaIdentifierStart(name.charAt(0)) && !KEYWORDS.contains(name) && !LITERALS.contains(name);
        }

        public String trimRight(String s) {
            int end;
            for (end = s.length(); end > 0 && Character.isWhitespace(s.charAt(end - 1)); --end) {
            }
            return s.substring(0, end);
        }

        public List<String> splitLines(String text) {
            return text == null ? Collections.emptyList() : Arrays.asList(text.split("\r?\n"));
        }
    }

    public static interface ArgumentTypesFinder {
        public List<ArgumentTypes> findArgumentTypes(String var1);

        public static final class ArgumentTypes {
            static final ArgumentTypes OBJECT = new ArgumentTypes(Object.class);
            private final Set<Class<?>> types = new LinkedHashSet();

            ArgumentTypes(Class<?> ... types) {
                this(Arrays.asList(types));
            }

            ArgumentTypes(Collection<Class<?>> types) {
                this.types.addAll(types);
            }

            public Set<Class<?>> getTypes() {
                return Collections.unmodifiableSet(this.types);
            }

            void retainTypes(ArgumentTypes types) {
                this.retainTypes(types.types);
            }

            void retainTypes(Collection<Class<?>> types) {
                this.types.retainAll(types);
                if (this.types.isEmpty()) {
                    this.types.add(Object.class);
                }
            }
        }
    }

    static final class Writer {
        private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_30);
        private final Charset encoding;
        private final boolean publicVisibility;
        private final License license;
        private final boolean useMessageFormat;
        private final Set<String> suppressWarnings;

        Writer(Charset encoding, boolean publicVisibility, License license, boolean useMessageFormat, Set<String> suppressWarnings) {
            this.configuration.setClassForTemplateLoading(this.getClass(), "templates");
            this.configuration.setDefaultEncoding(encoding.name());
            this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.configuration.setLogTemplateExceptions(false);
            this.configuration.setWrapUncheckedExceptions(false);
            this.configuration.setFallbackOnNullLoopVariable(false);
            this.encoding = encoding;
            this.publicVisibility = publicVisibility;
            this.license = license;
            this.useMessageFormat = useMessageFormat;
            this.suppressWarnings = suppressWarnings;
        }

        void write(Node i18n, String bundleName, String i18nClassName, File outputDir) throws IOException {
            String simpleClassName;
            String packageName;
            int index = i18nClassName.lastIndexOf(46);
            if (index == -1) {
                packageName = null;
                simpleClassName = i18nClassName;
            } else {
                packageName = i18nClassName.substring(0, index);
                simpleClassName = i18nClassName.substring(index + 1);
            }
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("visibility", this.publicVisibility ? "public " : "");
            root.put("packageName", packageName);
            root.put("simpleClassName", simpleClassName);
            root.put("bundleName", bundleName);
            root.put("useMessageFormat", this.useMessageFormat);
            root.put("argumentTypesFinder", this.useMessageFormat ? new MessageFormatArgumentTypesFinder() : new StringFormatArgumentTypesFinder());
            root.put("suppressWarnings", this.suppressWarnings);
            root.put("i18n", i18n);
            root.put("helper", new FTLHelper());
            File packageDir = packageName == null ? outputDir : new File(outputDir, packageName.replace('.', '/'));
            packageDir.mkdirs();
            String i18nClassFileName = simpleClassName + ".java";
            File i18nClassFile = new File(packageDir, i18nClassFileName);
            root.put("licenseText", this.getLicenseText(i18nClassFileName));
            this.write("I18N.ftl", root, i18nClassFile);
        }

        String getLicenseText(String fileName) {
            if (this.license == null || this.license.getText() == null || this.license.getText().isEmpty()) {
                return null;
            }
            String copyrightYear = this.getLicenseCopyrightYear();
            String copyrightHolder = this.getLicenseCopyrightHolder();
            return this.license.getText().replace("${fileName}", fileName).replace("${copyrightYear}", copyrightYear).replace("${copyrightHolder}", copyrightHolder);
        }

        String getLicenseCopyrightYear() {
            assert (this.license != null);
            return this.license.getCopyrightYear() != null ? this.license.getCopyrightYear() : String.format("%tY", new Date());
        }

        String getLicenseCopyrightHolder() {
            assert (this.license != null);
            return this.license.getCopyrightHolder() != null ? this.license.getCopyrightHolder() : System.getProperty("user.name");
        }

        private void write(String templateName, Map<String, Object> root, File file) throws IOException {
            Template template = this.configuration.getTemplate(templateName, this.encoding.name());
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding);){
                template.process(root, (java.io.Writer)writer);
            }
            catch (TemplateException e) {
                throw new IOException(e);
            }
        }
    }

    static final class Parser {
        private static final String ROOT_PATH = "";

        Parser() {
        }

        Node parse(Map<String, String> properties) {
            Node root = new Node(ROOT_PATH, ROOT_PATH, false, null);
            HashMap<String, Node> nodes = new HashMap<String, Node>();
            nodes.put(ROOT_PATH, root);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.addNodeIfNotExists(key, nodes, true, value);
            }
            return root;
        }

        private void addNodeIfNotExists(String path, Map<String, Node> nodes, boolean isLeaf, String value) {
            Node existing = nodes.get(path);
            if (existing == null) {
                String name;
                String parentPath;
                int index = path.lastIndexOf(46);
                if (index == -1) {
                    parentPath = ROOT_PATH;
                    name = path;
                } else {
                    parentPath = path.substring(0, index);
                    name = path.substring(index + 1);
                }
                Node node = new Node(name, path, isLeaf, value);
                nodes.put(path, node);
                this.addNodeIfNotExists(parentPath, nodes, false, null);
                Node parent = nodes.get(parentPath);
                parent.addChild(node);
            } else if (isLeaf) {
                existing.setLeaf(value);
            }
        }
    }

    public static final class Node {
        private final String name;
        private final String path;
        private final Map<String, Node> children;
        private boolean isLeaf;
        private String value;

        Node(String name, String path, boolean isLeaf, String value) {
            this.name = name;
            this.path = path;
            this.children = new LinkedHashMap<String, Node>();
            this.isLeaf = isLeaf;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String path() {
            return this.path;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public Collection<Node> children() {
            return this.children.values();
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public String getValue() {
            return this.value;
        }

        void addChild(Node child) {
            this.children.put(child.name, child);
        }

        void setLeaf(String value) {
            this.isLeaf = true;
            this.value = value;
        }
    }
}

