/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.maven.plugins.i18n;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

final class Messages {
    private static final Map<Locale, ResourceBundle> BUNDLES = new ConcurrentHashMap<Locale, ResourceBundle>();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        Locale l = Messages.nonNull(locale);
        return BUNDLES.computeIfAbsent(l, k -> ResourceBundle.getBundle("com.github.robtimus.maven.plugins.i18n.i18n", l));
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = Messages.getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static String noInputEncoding(Object arg) {
        return Messages.noInputEncoding(null, arg);
    }

    static String noInputEncoding(Locale locale, Object arg) {
        Locale l = Messages.nonNull(locale);
        String s = Messages.getString(l, "noInputEncoding");
        return String.format(l, s, arg);
    }

    static String noOutputEncoding(Object arg) {
        return Messages.noOutputEncoding(null, arg);
    }

    static String noOutputEncoding(Locale locale, Object arg) {
        Locale l = Messages.nonNull(locale);
        String s = Messages.getString(l, "noOutputEncoding");
        return String.format(l, s, arg);
    }

    static String generatingClass(Object arg1, Object arg2) {
        return Messages.generatingClass(null, arg1, arg2);
    }

    static String generatingClass(Locale locale, Object arg1, Object arg2) {
        Locale l = Messages.nonNull(locale);
        String s = Messages.getString(l, "generatingClass");
        return String.format(l, s, arg1, arg2);
    }
}

