/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.maven.plugins.i18n;

import com.github.robtimus.maven.plugins.i18n.I18N;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class StringFormatArgumentTypesFinder
implements I18N.ArgumentTypesFinder {
    private static final String FORMAT_SPECIFIER = "%(\\d+\\$)?([-#+ 0,(\\<]+)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern FORMAT_SPECIFIER_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]+)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    StringFormatArgumentTypesFinder() {
    }

    @Override
    public List<I18N.ArgumentTypesFinder.ArgumentTypes> findArgumentTypes(String formatOrPattern) {
        List<FormatSpecifier> formatSpecifiers = this.parse(formatOrPattern);
        ArrayList<I18N.ArgumentTypesFinder.ArgumentTypes> result = new ArrayList<I18N.ArgumentTypesFinder.ArgumentTypes>(formatSpecifiers.size());
        int lastIndex = -1;
        int lastOrdinaryIndex = -1;
        block5: for (FormatSpecifier fs : formatSpecifiers) {
            switch (fs.index) {
                case -2: {
                    continue block5;
                }
                case -1: {
                    if (lastIndex < 0) continue block5;
                    this.setArgumentTypes(result, lastIndex, fs.types);
                    continue block5;
                }
                case 0: {
                    lastIndex = ++lastOrdinaryIndex;
                    this.setArgumentTypes(result, lastIndex, fs.types);
                    continue block5;
                }
            }
            lastIndex = fs.index - 1;
            this.setArgumentTypes(result, lastIndex, fs.types);
        }
        ListIterator<I18N.ArgumentTypesFinder.ArgumentTypes> i = result.listIterator();
        while (i.hasNext()) {
            I18N.ArgumentTypesFinder.ArgumentTypes types = (I18N.ArgumentTypesFinder.ArgumentTypes)i.next();
            if (types != null) continue;
            i.set(I18N.ArgumentTypesFinder.ArgumentTypes.OBJECT);
        }
        return result;
    }

    private List<FormatSpecifier> parse(String format) {
        ArrayList<FormatSpecifier> result = new ArrayList<FormatSpecifier>();
        Matcher matcher = FORMAT_SPECIFIER_PATTERN.matcher(format);
        while (matcher.find()) {
            FormatSpecifier argumentType = new FormatSpecifier(matcher);
            result.add(argumentType);
        }
        return result;
    }

    private void setArgumentTypes(List<I18N.ArgumentTypesFinder.ArgumentTypes> result, int index, I18N.ArgumentTypesFinder.ArgumentTypes types) {
        this.ensureIndex(result, index);
        I18N.ArgumentTypesFinder.ArgumentTypes oldTypes = result.get(index);
        if (oldTypes == null) {
            result.set(index, types);
        } else {
            oldTypes.retainTypes(types);
        }
    }

    private void ensureIndex(List<?> list, int index) {
        while (list.size() <= index) {
            list.add(null);
        }
    }

    private static final class FormatSpecifier {
        private static final int LITERAL_INDEX = -2;
        private static final int RELATIVE_INDEX = -1;
        private static final int ORDINARY_INDEX = 0;
        private final String format;
        private final int index;
        private final I18N.ArgumentTypesFinder.ArgumentTypes types;

        private FormatSpecifier(Matcher matcher) {
            this.format = matcher.group();
            char c = matcher.group(6).charAt(0);
            this.index = this.getIndex(matcher, c);
            this.types = this.getTypes(matcher, c);
        }

        private int getIndex(Matcher matcher, char c) {
            String f;
            block5: {
                if (FormatSpecifier.isText(c)) {
                    return -2;
                }
                String s = matcher.group(1);
                if (s != null) {
                    try {
                        return Integer.parseInt(s.substring(0, s.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
            if ((f = matcher.group(2)) != null && f.indexOf(60) != -1) {
                return -1;
            }
            return 0;
        }

        private I18N.ArgumentTypesFinder.ArgumentTypes getTypes(Matcher matcher, char c) {
            boolean datetime;
            String tT = matcher.group(5);
            boolean bl = datetime = tT != null;
            if (datetime) {
                return new I18N.ArgumentTypesFinder.ArgumentTypes(Long.TYPE, Long.class, Calendar.class, Date.class);
            }
            return this.getTypes(c);
        }

        private I18N.ArgumentTypesFinder.ArgumentTypes getTypes(char c) {
            if (FormatSpecifier.isText(c)) {
                return I18N.ArgumentTypesFinder.ArgumentTypes.OBJECT;
            }
            switch (c) {
                case 'B': 
                case 'b': {
                    return new I18N.ArgumentTypesFinder.ArgumentTypes(Boolean.TYPE, Boolean.class);
                }
                case 'H': 
                case 'S': 
                case 'h': 
                case 's': {
                    return I18N.ArgumentTypesFinder.ArgumentTypes.OBJECT;
                }
                case 'C': 
                case 'c': {
                    return new I18N.ArgumentTypesFinder.ArgumentTypes(Character.TYPE, Character.class);
                }
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return new I18N.ArgumentTypesFinder.ArgumentTypes(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class);
                }
                case 'E': 
                case 'G': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return new I18N.ArgumentTypesFinder.ArgumentTypes(Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class);
                }
                case 'A': 
                case 'a': {
                    return new I18N.ArgumentTypesFinder.ArgumentTypes(Float.TYPE, Float.class, Double.TYPE, Double.class);
                }
            }
            return I18N.ArgumentTypesFinder.ArgumentTypes.OBJECT;
        }

        private static boolean isText(char c) {
            return c == 'n' || c == '%';
        }

        public String toString() {
            return this.format;
        }
    }
}

