/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opentest4j.AssertionFailedError;

public final class AssertionFailedErrorBuilder {
    private static final Expected EXPECTED_NULL = new Expected.Value(null, null);
    private static final Actual ACTUAL_NULL = new Actual.Value(null, null);
    private Object message;
    private Throwable cause;
    private boolean mismatch;
    private Expected expected = EXPECTED_NULL;
    private Actual actual = ACTUAL_NULL;
    private String reason;
    private boolean includeValuesInMessage = true;

    private AssertionFailedErrorBuilder() {
    }

    public static AssertionFailedErrorBuilder assertionFailedError() {
        return new AssertionFailedErrorBuilder();
    }

    public AssertionFailedErrorBuilder message(Object message) {
        this.message = message;
        return this;
    }

    public AssertionFailedErrorBuilder reason(String reason) {
        this.reason = reason;
        return this;
    }

    public ReasonBuilder reasonPattern(String pattern) {
        Objects.requireNonNull(pattern);
        return new ReasonBuilder(this, pattern);
    }

    public AssertionFailedErrorBuilder cause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public AssertionFailedErrorBuilder expected(Object expected) {
        return this.expectedWithPrefix("", expected);
    }

    private AssertionFailedErrorBuilder expectedWithPrefix(String prefix, Object expected) {
        this.mismatch = true;
        this.expected = new Expected.Value(prefix, expected);
        return this;
    }

    public AssertionFailedErrorBuilder expectedOneOf(Object ... expected) {
        return this.expectedOneOf(Arrays.asList(expected));
    }

    public AssertionFailedErrorBuilder expectedOneOf(Collection<?> expected) {
        return this.expectedOneOfWithPrefix("one of", expected);
    }

    private AssertionFailedErrorBuilder expectedOneOfWithPrefix(String prefix, Collection<?> expected) {
        this.mismatch = true;
        this.expected = new Expected.Values(prefix, expected);
        return this;
    }

    public AssertionFailedErrorBuilder expectedMessage(String expected) {
        this.mismatch = true;
        this.expected = new Expected.Message(expected);
        return this;
    }

    public AssertionFailedErrorBuilder actual(Object actual) {
        return this.actualWithPrefix("", actual);
    }

    private AssertionFailedErrorBuilder actualWithPrefix(String prefix, Object actual) {
        this.mismatch = true;
        this.actual = new Actual.Value(prefix, actual);
        return this;
    }

    public AssertionFailedErrorBuilder actualValues(Object ... actual) {
        return this.actualValues(Arrays.asList(actual));
    }

    public AssertionFailedErrorBuilder actualValues(Collection<?> actual) {
        return this.actualValuesWithPrefix("", actual);
    }

    private AssertionFailedErrorBuilder actualValuesWithPrefix(String prefix, Collection<?> actual) {
        this.mismatch = true;
        this.actual = new Actual.Values(prefix, actual);
        return this;
    }

    public PrefixedValues prefixed(String prefix) {
        return new PrefixedValues(this, prefix);
    }

    public AssertionFailedErrorBuilder includeValuesInMessage(boolean includeValuesInMessage) {
        this.includeValuesInMessage = includeValuesInMessage;
        return this;
    }

    public void buildAndThrow() {
        throw this.build();
    }

    public AssertionFailedError build() {
        Object reasonValue = AssertionFailedErrorBuilder.nullSafeGet(this.reason);
        if (this.mismatch && this.includeValuesInMessage) {
            reasonValue = (String)(AssertionFailedErrorBuilder.isNotBlank((String)reasonValue) ? (String)reasonValue + ", " : "") + AssertionFailedErrorBuilder.formatValues(this.expected, this.actual);
        }
        Object messageValue = AssertionFailedErrorBuilder.nullSafeGet(this.message);
        if (reasonValue != null) {
            messageValue = AssertionFailedErrorBuilder.buildPrefix((String)messageValue) + (String)reasonValue;
        }
        return this.mismatch ? new AssertionFailedError((String)messageValue, this.expected.value(), this.actual.value(), this.cause) : new AssertionFailedError((String)messageValue, this.cause);
    }

    static String nullSafeGet(Object messageOrSupplier) {
        if (messageOrSupplier == null) {
            return null;
        }
        if (messageOrSupplier instanceof Supplier) {
            Object message = ((Supplier)messageOrSupplier).get();
            return AssertionFailedErrorBuilder.objectToString(message);
        }
        return AssertionFailedErrorBuilder.objectToString(messageOrSupplier);
    }

    private static String buildPrefix(String message) {
        return AssertionFailedErrorBuilder.isNotBlank(message) ? message + " ==> " : "";
    }

    static boolean isNotBlank(String message) {
        return message != null && message.chars().anyMatch(c -> !Character.isWhitespace(c));
    }

    private static String formatValues(Expected expected, Actual actual) {
        String actualString = actual.valueString();
        if (expected.isFormattedAs(actualString)) {
            return String.format("expected: %s but was: %s", expected.formatWithClass(), actual.formatWithClass());
        }
        return String.format("expected: %s but was: %s", expected.format(), actual.format());
    }

    static String formatClassAndValue(Object value, String valueString) {
        if (value == null) {
            return "<null>";
        }
        String classAndHash = AssertionFailedErrorBuilder.getClassName(value) + AssertionFailedErrorBuilder.toHash(value);
        return value instanceof Class ? "<" + classAndHash + ">" : classAndHash + "<" + valueString + ">";
    }

    private static String toHash(Object obj) {
        return "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static String getClassName(Object obj) {
        if (obj instanceof Class) {
            return AssertionFailedErrorBuilder.getCanonicalName((Class)obj);
        }
        return obj.getClass().getName();
    }

    private static String getCanonicalName(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }

    static String objectToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Class) {
            return AssertionFailedErrorBuilder.getCanonicalName((Class)obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof Object[]) {
            return Arrays.deepToString((Object[])obj);
        }
        String result = obj.toString();
        return result != null ? result : "null";
    }

    private static String addOptionalPrefix(String prefix, String message) {
        return AssertionFailedErrorBuilder.isNotBlank(prefix) ? String.format("%s %s", prefix, message) : message;
    }

    private static abstract class Actual {
        private final String prefix;

        Actual(String prefix) {
            this.prefix = prefix;
        }

        private String format() {
            return AssertionFailedErrorBuilder.addOptionalPrefix(this.prefix, this.doFormat());
        }

        abstract String doFormat();

        private String formatWithClass() {
            return AssertionFailedErrorBuilder.addOptionalPrefix(this.prefix, this.doFormatWithClass());
        }

        abstract String doFormatWithClass();

        abstract Object value();

        abstract String valueString();

        private static final class Values
        extends Actual {
            private final List<?> actualValues;
            private final List<String> actualValueStrings;

            private Values(String prefix, Collection<?> actualValues) {
                super(prefix);
                this.actualValues = new ArrayList(actualValues);
                this.actualValueStrings = actualValues.stream().map(AssertionFailedErrorBuilder::objectToString).collect(Collectors.toList());
            }

            @Override
            String doFormat() {
                return this.actualValueStrings.stream().map(valueString -> String.format("<%s>", valueString)).collect(Collectors.joining(", "));
            }

            @Override
            String doFormatWithClass() {
                Iterator<?> valueIterator = this.actualValues.iterator();
                Iterator<String> valueStringIterator = this.actualValueStrings.iterator();
                StringJoiner stringJoiner = new StringJoiner(", ");
                while (valueIterator.hasNext()) {
                    Object value = valueIterator.next();
                    String valueString = valueStringIterator.next();
                    stringJoiner.add(AssertionFailedErrorBuilder.formatClassAndValue(value, valueString));
                }
                return stringJoiner.toString();
            }

            @Override
            Object value() {
                return this.actualValues;
            }

            @Override
            public String valueString() {
                return this.actualValueStrings.stream().collect(Collectors.joining(", "));
            }
        }

        private static final class Value
        extends Actual {
            private final Object actualValue;
            private final String actualValueString;

            private Value(String prefix, Object actualValue) {
                super(prefix);
                this.actualValue = actualValue;
                this.actualValueString = AssertionFailedErrorBuilder.objectToString(actualValue);
            }

            @Override
            String doFormat() {
                return String.format("<%s>", this.actualValueString);
            }

            @Override
            String doFormatWithClass() {
                return AssertionFailedErrorBuilder.formatClassAndValue(this.actualValue, this.actualValueString);
            }

            @Override
            Object value() {
                return this.actualValue;
            }

            @Override
            String valueString() {
                return this.actualValueString;
            }
        }
    }

    private static abstract class Expected {
        private final String prefix;

        Expected(String prefix) {
            this.prefix = prefix;
        }

        abstract boolean isFormattedAs(String var1);

        private String format() {
            return AssertionFailedErrorBuilder.addOptionalPrefix(this.prefix, this.doFormat());
        }

        abstract String doFormat();

        private String formatWithClass() {
            return AssertionFailedErrorBuilder.addOptionalPrefix(this.prefix, this.doFormatWithClass());
        }

        abstract String doFormatWithClass();

        abstract Object value();

        private static final class Message
        extends Expected {
            private final String expectedMessage;

            private Message(String expectedMessage) {
                super("");
                this.expectedMessage = expectedMessage;
            }

            @Override
            boolean isFormattedAs(String actualString) {
                return false;
            }

            @Override
            String doFormat() {
                return this.expectedMessage;
            }

            @Override
            String doFormatWithClass() {
                return this.expectedMessage;
            }

            @Override
            Object value() {
                return this.expectedMessage;
            }
        }

        private static final class Values
        extends Expected {
            private final List<?> expectedValues;
            private final List<String> expectedValueStrings;
            private final String expectedValuesString;

            private Values(String prefix, Collection<?> expectedValues) {
                super(prefix);
                this.expectedValues = new ArrayList(expectedValues);
                this.expectedValueStrings = expectedValues.stream().map(AssertionFailedErrorBuilder::objectToString).collect(Collectors.toList());
                this.expectedValuesString = this.expectedValueStrings.stream().collect(Collectors.joining(", "));
            }

            @Override
            boolean isFormattedAs(String actualString) {
                return this.expectedValueStrings.contains(actualString) || this.expectedValuesString.equals(actualString);
            }

            @Override
            String doFormat() {
                return this.expectedValueStrings.stream().map(valueString -> String.format("<%s>", valueString)).collect(Collectors.joining(", "));
            }

            @Override
            String doFormatWithClass() {
                Iterator<?> valueIterator = this.expectedValues.iterator();
                Iterator<String> valueStringIterator = this.expectedValueStrings.iterator();
                StringJoiner stringJoiner = new StringJoiner(", ");
                while (valueIterator.hasNext()) {
                    Object value = valueIterator.next();
                    String valueString = valueStringIterator.next();
                    stringJoiner.add(AssertionFailedErrorBuilder.formatClassAndValue(value, valueString));
                }
                return stringJoiner.toString();
            }

            @Override
            Object value() {
                return this.expectedValues;
            }
        }

        private static final class Value
        extends Expected {
            private final Object expectedValue;
            private final String expectedValueString;

            private Value(String prefix, Object expectedValue) {
                super(prefix);
                this.expectedValue = expectedValue;
                this.expectedValueString = AssertionFailedErrorBuilder.objectToString(expectedValue);
            }

            @Override
            boolean isFormattedAs(String actualString) {
                return this.expectedValueString.equals(actualString);
            }

            @Override
            String doFormat() {
                return String.format("<%s>", this.expectedValueString);
            }

            @Override
            String doFormatWithClass() {
                return AssertionFailedErrorBuilder.formatClassAndValue(this.expectedValue, this.expectedValueString);
            }

            @Override
            Object value() {
                return this.expectedValue;
            }
        }
    }

    public static final class PrefixedValues {
        private final AssertionFailedErrorBuilder builder;
        private final String prefix;

        private PrefixedValues(AssertionFailedErrorBuilder builder, String prefix) {
            this.builder = builder;
            this.prefix = prefix;
        }

        public AssertionFailedErrorBuilder expected(Object expected) {
            return this.builder.expectedWithPrefix(this.prefix, expected);
        }

        public AssertionFailedErrorBuilder expectedOneOf(Object ... expected) {
            return this.expectedOneOf(Arrays.asList(expected));
        }

        public AssertionFailedErrorBuilder expectedOneOf(Collection<?> expected) {
            return this.builder.expectedOneOfWithPrefix(this.prefix, expected);
        }

        public AssertionFailedErrorBuilder actual(Object actual) {
            return this.builder.actualWithPrefix(this.prefix, actual);
        }

        public AssertionFailedErrorBuilder actualValues(Object ... actual) {
            return this.actualValues(Arrays.asList(actual));
        }

        public AssertionFailedErrorBuilder actualValues(Collection<?> actual) {
            return this.builder.actualValuesWithPrefix(this.prefix, actual);
        }
    }

    public static final class ReasonBuilder {
        private final AssertionFailedErrorBuilder builder;
        private final String pattern;
        private final List<Object> arguments;

        private ReasonBuilder(AssertionFailedErrorBuilder builder, String pattern) {
            this.builder = builder;
            this.pattern = pattern;
            this.arguments = new ArrayList<Object>();
        }

        public ReasonBuilder withValue(Object value) {
            this.arguments.add(String.format("<%s>", AssertionFailedErrorBuilder.objectToString(value)));
            return this;
        }

        public ReasonBuilder withValues(Object ... values) {
            return this.withValues(Arrays.asList(values));
        }

        public ReasonBuilder withValues(Collection<?> values) {
            this.arguments.add(values.stream().map(value -> String.format("<%s>", AssertionFailedErrorBuilder.objectToString(value))).collect(Collectors.joining(", ")));
            return this;
        }

        public AssertionFailedErrorBuilder format() {
            String reason = String.format(this.pattern, this.arguments.toArray());
            return this.builder.reason(reason);
        }
    }
}

