/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public final class IOAssertions {
    private IOAssertions() {
    }

    public static void assertContainsContent(Reader reader, String expectedContent) {
        String content = (String)Assertions.assertDoesNotThrow(() -> IOAssertions.readContent(reader, expectedContent));
        Assertions.assertEquals((Object)expectedContent, (Object)content);
    }

    public static void assertContainsContent(Reader reader, String expectedContent, String message) {
        String content = (String)Assertions.assertDoesNotThrow(() -> IOAssertions.readContent(reader, expectedContent), (String)message);
        Assertions.assertEquals((Object)expectedContent, (Object)content, (String)message);
    }

    public static void assertContainsContent(Reader reader, String expectedContent, Supplier<String> messageSupplier) {
        String content = (String)Assertions.assertDoesNotThrow(() -> IOAssertions.readContent(reader, expectedContent), messageSupplier);
        Assertions.assertEquals((Object)expectedContent, (Object)content, messageSupplier);
    }

    public static void assertContainsContent(Reader reader, Matcher<? super String> matcher) {
        String content = (String)Assertions.assertDoesNotThrow(() -> IOAssertions.readContent(reader));
        MatcherAssert.assertThat((Object)content, matcher);
    }

    private static String readContent(Reader reader, String expectedContent) throws IOException {
        StringBuilder sb = new StringBuilder(expectedContent.length());
        IOAssertions.copyContent(reader, sb);
        return sb.toString();
    }

    private static String readContent(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        IOAssertions.copyContent(reader, sb);
        return sb.toString();
    }

    private static void copyContent(Reader reader, StringBuilder sb) throws IOException {
        int len;
        char[] buffer = new char[1024];
        while ((len = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, len);
        }
    }

    public static void assertContainsContent(InputStream inputStream, byte[] expectedContent) {
        byte[] content = (byte[])Assertions.assertDoesNotThrow(() -> IOAssertions.readContent(inputStream, expectedContent.length));
        Assertions.assertArrayEquals((byte[])expectedContent, (byte[])content);
    }

    public static void assertContainsContent(InputStream inputStream, byte[] expectedContent, String message) {
        byte[] content = (byte[])Assertions.assertDoesNotThrow(() -> IOAssertions.readContent(inputStream, expectedContent.length), (String)message);
        Assertions.assertArrayEquals((byte[])expectedContent, (byte[])content, (String)message);
    }

    public static void assertContainsContent(InputStream inputStream, byte[] expectedContent, Supplier<String> messageSupplier) {
        byte[] content = (byte[])Assertions.assertDoesNotThrow(() -> IOAssertions.readContent(inputStream, expectedContent.length), messageSupplier);
        Assertions.assertArrayEquals((byte[])expectedContent, (byte[])content, messageSupplier);
    }

    private static byte[] readContent(InputStream inputStream, int expectedContentLength) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(expectedContentLength);
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        return baos.toByteArray();
    }

    public static void assertContainsContent(InputStream inputStream, Charset charset, String expectedContent) {
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        IOAssertions.assertContainsContent((Reader)reader, expectedContent);
    }

    public static void assertContainsContent(InputStream inputStream, Charset charset, String expectedContent, String message) {
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        IOAssertions.assertContainsContent((Reader)reader, expectedContent, message);
    }

    public static void assertContainsContent(InputStream inputStream, Charset charset, String expectedContent, Supplier<String> messageSupplier) {
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        IOAssertions.assertContainsContent((Reader)reader, expectedContent, messageSupplier);
    }

    public static void assertContainsContent(InputStream inputStream, Charset charset, Matcher<? super String> matcher) {
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        IOAssertions.assertContainsContent((Reader)reader, matcher);
    }

    public static <T> T assertSerializable(T object) {
        return (T)Assertions.assertDoesNotThrow(() -> IOAssertions.serializeAndDeserialize(object));
    }

    public static <T> T assertSerializable(T object, String message) {
        return (T)Assertions.assertDoesNotThrow(() -> IOAssertions.serializeAndDeserialize(object), (String)message);
    }

    public static <T> T assertSerializable(T object, Supplier<String> messageSupplier) {
        return (T)Assertions.assertDoesNotThrow(() -> IOAssertions.serializeAndDeserialize(object), messageSupplier);
    }

    private static <T> T serializeAndDeserialize(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
        }
        byte[] bytes = baos.toByteArray();
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object deserialized;
            Object object2 = deserialized = ois.readObject();
            return (T)object2;
        }
    }

    public static void assertNotSerializable(Object object) {
        Assertions.assertThrows(NotSerializableException.class, () -> IOAssertions.serializeOnly(object));
    }

    public static void assertNotSerializable(Object object, String message) {
        Assertions.assertThrows(NotSerializableException.class, () -> IOAssertions.serializeOnly(object), (String)message);
    }

    public static void assertNotSerializable(Object object, Supplier<String> messageSupplier) {
        Assertions.assertThrows(NotSerializableException.class, () -> IOAssertions.serializeOnly(object), messageSupplier);
    }

    private static void serializeOnly(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
        }
    }
}

