/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;

public final class OptionalAssertions {
    private OptionalAssertions() {
    }

    public static <T> T assertIsPresent(Optional<T> optional) {
        Assertions.assertNotEquals(Optional.empty(), optional);
        return optional.get();
    }

    public static <T> T assertIsPresent(Optional<T> optional, String message) {
        Assertions.assertNotEquals(Optional.empty(), optional, (String)message);
        return optional.get();
    }

    public static <T> T assertIsPresent(Optional<T> optional, Supplier<String> messageSupplier) {
        Assertions.assertNotEquals(Optional.empty(), optional, messageSupplier);
        return optional.get();
    }

    public static int assertIsPresent(OptionalInt optional) {
        Assertions.assertNotEquals((Object)OptionalInt.empty(), (Object)optional);
        return optional.getAsInt();
    }

    public static int assertIsPresent(OptionalInt optional, String message) {
        Assertions.assertNotEquals((Object)OptionalInt.empty(), (Object)optional, (String)message);
        return optional.getAsInt();
    }

    public static int assertIsPresent(OptionalInt optional, Supplier<String> messageSupplier) {
        Assertions.assertNotEquals((Object)OptionalInt.empty(), (Object)optional, messageSupplier);
        return optional.getAsInt();
    }

    public static long assertIsPresent(OptionalLong optional) {
        Assertions.assertNotEquals((Object)OptionalLong.empty(), (Object)optional);
        return optional.getAsLong();
    }

    public static long assertIsPresent(OptionalLong optional, String message) {
        Assertions.assertNotEquals((Object)OptionalLong.empty(), (Object)optional, (String)message);
        return optional.getAsLong();
    }

    public static long assertIsPresent(OptionalLong optional, Supplier<String> messageSupplier) {
        Assertions.assertNotEquals((Object)OptionalLong.empty(), (Object)optional, messageSupplier);
        return optional.getAsLong();
    }

    public static double assertIsPresent(OptionalDouble optional) {
        Assertions.assertNotEquals((Object)OptionalDouble.empty(), (Object)optional);
        return optional.getAsDouble();
    }

    public static double assertIsPresent(OptionalDouble optional, String message) {
        Assertions.assertNotEquals((Object)OptionalDouble.empty(), (Object)optional, (String)message);
        return optional.getAsDouble();
    }

    public static double assertIsPresent(OptionalDouble optional, Supplier<String> messageSupplier) {
        Assertions.assertNotEquals((Object)OptionalDouble.empty(), (Object)optional, messageSupplier);
        return optional.getAsDouble();
    }

    public static void assertIsEmpty(Optional<?> optional) {
        Assertions.assertEquals(Optional.empty(), optional);
    }

    public static void assertIsEmpty(Optional<?> optional, String message) {
        Assertions.assertEquals(Optional.empty(), optional, (String)message);
    }

    public static void assertIsEmpty(Optional<?> optional, Supplier<String> messageSupplier) {
        Assertions.assertEquals(Optional.empty(), optional, messageSupplier);
    }

    public static void assertIsEmpty(OptionalInt optional) {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)optional);
    }

    public static void assertIsEmpty(OptionalInt optional, String message) {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)optional, (String)message);
    }

    public static void assertIsEmpty(OptionalInt optional, Supplier<String> messageSupplier) {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)optional, messageSupplier);
    }

    public static void assertIsEmpty(OptionalLong optional) {
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)optional);
    }

    public static void assertIsEmpty(OptionalLong optional, String message) {
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)optional, (String)message);
    }

    public static void assertIsEmpty(OptionalLong optional, Supplier<String> messageSupplier) {
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)optional, messageSupplier);
    }

    public static void assertIsEmpty(OptionalDouble optional) {
        Assertions.assertEquals((Object)OptionalDouble.empty(), (Object)optional);
    }

    public static void assertIsEmpty(OptionalDouble optional, String message) {
        Assertions.assertEquals((Object)OptionalDouble.empty(), (Object)optional, (String)message);
    }

    public static void assertIsEmpty(OptionalDouble optional, Supplier<String> messageSupplier) {
        Assertions.assertEquals((Object)OptionalDouble.empty(), (Object)optional, messageSupplier);
    }
}

