/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support;

import com.github.robtimus.junit.support.AssertionFailedErrorBuilder;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class PredicateAssertions {
    private PredicateAssertions() {
    }

    public static <T> void assertMatches(Predicate<? super T> matcher, T actual) {
        PredicateAssertions.assertMatches(matcher, actual, null);
    }

    public static <T> void assertMatches(Predicate<? super T> matcher, T actual, String message) {
        PredicateAssertions.assertMatches(matcher, actual, (Object)message);
    }

    public static <T> void assertMatches(Predicate<? super T> matcher, T actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertMatches(matcher, actual, messageSupplier);
    }

    private static <T> void assertMatches(Predicate<? super T> matcher, T actual, Object messageOrSupplier) {
        if (!matcher.test(actual)) {
            PredicateAssertions.notMatching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    public static void assertIntMatches(IntPredicate matcher, int actual) {
        PredicateAssertions.assertIntMatches(matcher, actual, null);
    }

    public static void assertIntMatches(IntPredicate matcher, int actual, String message) {
        PredicateAssertions.assertIntMatches(matcher, actual, (Object)message);
    }

    public static void assertIntMatches(IntPredicate matcher, int actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertIntMatches(matcher, actual, messageSupplier);
    }

    private static void assertIntMatches(IntPredicate matcher, int actual, Object messageOrSupplier) {
        if (!matcher.test(actual)) {
            PredicateAssertions.notMatching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    public static void assertLongMatches(LongPredicate matcher, long actual) {
        PredicateAssertions.assertLongMatches(matcher, actual, null);
    }

    public static void assertLongMatches(LongPredicate matcher, long actual, String message) {
        PredicateAssertions.assertLongMatches(matcher, actual, (Object)message);
    }

    public static void assertLongMatches(LongPredicate matcher, long actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertLongMatches(matcher, actual, messageSupplier);
    }

    private static void assertLongMatches(LongPredicate matcher, long actual, Object messageOrSupplier) {
        if (!matcher.test(actual)) {
            PredicateAssertions.notMatching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    public static void assertDoubleMatches(DoublePredicate matcher, double actual) {
        PredicateAssertions.assertDoubleMatches(matcher, actual, null);
    }

    public static void assertDoubleMatches(DoublePredicate matcher, double actual, String message) {
        PredicateAssertions.assertDoubleMatches(matcher, actual, (Object)message);
    }

    public static void assertDoubleMatches(DoublePredicate matcher, double actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertDoubleMatches(matcher, actual, messageSupplier);
    }

    private static void assertDoubleMatches(DoublePredicate matcher, double actual, Object messageOrSupplier) {
        if (!matcher.test(actual)) {
            PredicateAssertions.notMatching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    private static AssertionFailedErrorBuilder notMatching(Object actual, Object messageOrSupplier) {
        return AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).expectedMessage("matching predicate").actual(actual);
    }

    public static <T> void assertDoesNotMatch(Predicate<? super T> matcher, T actual) {
        PredicateAssertions.assertDoesNotMatch(matcher, actual, null);
    }

    public static <T> void assertDoesNotMatch(Predicate<? super T> matcher, T actual, String message) {
        PredicateAssertions.assertDoesNotMatch(matcher, actual, (Object)message);
    }

    public static <T> void assertDoesNotMatch(Predicate<? super T> matcher, T actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertDoesNotMatch(matcher, actual, messageSupplier);
    }

    private static <T> void assertDoesNotMatch(Predicate<? super T> matcher, T actual, Object messageOrSupplier) {
        if (matcher.test(actual)) {
            PredicateAssertions.matching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    public static void assertIntDoesNotMatch(IntPredicate matcher, int actual) {
        PredicateAssertions.assertIntDoesNotMatch(matcher, actual, null);
    }

    public static void assertIntDoesNotMatch(IntPredicate matcher, int actual, String message) {
        PredicateAssertions.assertIntDoesNotMatch(matcher, actual, (Object)message);
    }

    public static void assertIntDoesNotMatch(IntPredicate matcher, int actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertIntDoesNotMatch(matcher, actual, messageSupplier);
    }

    private static void assertIntDoesNotMatch(IntPredicate matcher, int actual, Object messageOrSupplier) {
        if (matcher.test(actual)) {
            PredicateAssertions.matching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    public static void assertLongDoesNotMatch(LongPredicate matcher, long actual) {
        PredicateAssertions.assertLongDoesNotMatch(matcher, actual, null);
    }

    public static void assertLongDoesNotMatch(LongPredicate matcher, long actual, String message) {
        PredicateAssertions.assertLongDoesNotMatch(matcher, actual, (Object)message);
    }

    public static void assertLongDoesNotMatch(LongPredicate matcher, long actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertLongDoesNotMatch(matcher, actual, messageSupplier);
    }

    private static void assertLongDoesNotMatch(LongPredicate matcher, long actual, Object messageOrSupplier) {
        if (matcher.test(actual)) {
            PredicateAssertions.matching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    public static void assertDoubleDoesNotMatch(DoublePredicate matcher, double actual) {
        PredicateAssertions.assertDoubleDoesNotMatch(matcher, actual, null);
    }

    public static void assertDoubleDoesNotMatch(DoublePredicate matcher, double actual, String message) {
        PredicateAssertions.assertDoubleDoesNotMatch(matcher, actual, (Object)message);
    }

    public static void assertDoubleDoesNotMatch(DoublePredicate matcher, double actual, Supplier<String> messageSupplier) {
        PredicateAssertions.assertDoubleDoesNotMatch(matcher, actual, messageSupplier);
    }

    private static void assertDoubleDoesNotMatch(DoublePredicate matcher, double actual, Object messageOrSupplier) {
        if (matcher.test(actual)) {
            PredicateAssertions.matching(actual, messageOrSupplier).buildAndThrow();
        }
    }

    private static AssertionFailedErrorBuilder matching(Object actual, Object messageOrSupplier) {
        return AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).expectedMessage("not matching predicate").actual(actual);
    }
}

