/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support;

import com.github.robtimus.junit.support.AssertionFailedErrorBuilder;
import com.github.robtimus.junit.support.ThrowableAssertions;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.opentest4j.AssertionFailedError;

public final class ThrowableAsserter<R> {
    private static final Consumer<Object> DO_NOTHING_CONSUMER = o -> {};
    private final ThrowingSupplier<R> supplier;
    private final Map<Class<? extends Throwable>, Consumer<? super Throwable>> errors;
    private final Map<Class<? extends Throwable>, Consumer<? super Throwable>> exactErrors;
    private final Set<Class<? extends Throwable>> expectedErrorTypes;
    private Consumer<? super R> nothingThrownAsserter;
    private State state;
    private Class<? extends Throwable> configuringErrorType;
    private boolean configuringExactErrorType;

    private ThrowableAsserter(ThrowingSupplier<R> supplier) {
        this.supplier = supplier;
        this.errors = new HashMap<Class<? extends Throwable>, Consumer<? super Throwable>>();
        this.exactErrors = new HashMap<Class<? extends Throwable>, Consumer<? super Throwable>>();
        this.expectedErrorTypes = new LinkedHashSet<Class<? extends Throwable>>();
        this.state = State.INITIALIZED;
    }

    private static ThrowingSupplier<Void> asThrowableSupplier(Executable executable) {
        return () -> {
            executable.execute();
            return null;
        };
    }

    public static <T extends Throwable> ThrownError<T, Void> whenThrows(Class<T> errorType, Executable executable) {
        return ThrowableAsserter.whenThrows(errorType, ThrowableAsserter.asThrowableSupplier(executable));
    }

    public static <T extends Throwable, R> ThrownError<T, R> whenThrows(Class<T> errorType, ThrowingSupplier<R> supplier) {
        Objects.requireNonNull(supplier);
        return new ThrowableAsserter<R>(supplier).whenThrows(errorType);
    }

    public <T extends Throwable> ThrownError<T, R> whenThrows(Class<T> errorType) {
        Objects.requireNonNull(errorType);
        return this.whenThrows(errorType, this.errors, false);
    }

    public static <T extends Throwable> ThrownError<T, Void> whenThrowsExactly(Class<T> errorType, Executable executable) {
        return ThrowableAsserter.whenThrowsExactly(errorType, ThrowableAsserter.asThrowableSupplier(executable));
    }

    public static <T extends Throwable, R> ThrownError<T, R> whenThrowsExactly(Class<T> errorType, ThrowingSupplier<R> supplier) {
        Objects.requireNonNull(supplier);
        return new ThrowableAsserter<R>(supplier).whenThrowsExactly(errorType);
    }

    public <T extends Throwable> ThrownError<T, R> whenThrowsExactly(Class<T> errorType) {
        Objects.requireNonNull(errorType);
        return this.whenThrows(errorType, this.exactErrors, true);
    }

    private <T extends Throwable> ThrownError<T, R> whenThrows(Class<T> errorType, Map<Class<? extends Throwable>, Consumer<? super Throwable>> errorMap, boolean exact) {
        if (this.state != State.INITIALIZED && this.state != State.CONFIGURED) {
            throw new IllegalStateException("Cannot configure assertions for an error type when current state is " + this.state);
        }
        errorMap.merge(errorType, DO_NOTHING_CONSUMER, (c1, c2) -> {
            throw new IllegalArgumentException(errorType + " already configured");
        });
        this.expectedErrorTypes.add(errorType);
        this.state = State.CONFIGURING_ERROR_TYPE;
        this.configuringErrorType = errorType;
        this.configuringExactErrorType = exact;
        return new ThrownError(this, errorType, errorMap, exact);
    }

    public NoError<R> whenThrowsNothing() {
        if (this.state != State.CONFIGURED) {
            throw new IllegalStateException("Cannot configure assertions for no error when current state is " + this.state);
        }
        if (this.nothingThrownAsserter != null) {
            throw new IllegalStateException("Assertions for no error already configured");
        }
        this.nothingThrownAsserter = DO_NOTHING_CONSUMER;
        this.state = State.CONFIGURING_NO_ERROR;
        return new NoError(this);
    }

    public Asserted<R> execute() {
        return this.execute((Object)null);
    }

    public Asserted<R> execute(String message) {
        return this.execute((Object)message);
    }

    public Asserted<R> execute(Supplier<String> messageSupplier) {
        return this.execute((Object)messageSupplier);
    }

    private Asserted<R> execute(Object messageOrSupplier) {
        Object result;
        if (this.state != State.CONFIGURED) {
            throw new IllegalStateException("Cannot run assertions when current state is " + this.state);
        }
        try {
            result = this.supplier.get();
        }
        catch (Throwable actualError) {
            this.runAssertionsForError(actualError, messageOrSupplier);
            this.state = State.ASSERTED;
            return new Asserted(actualError);
        }
        this.runAssertionsWhenNothingThrown(result, messageOrSupplier);
        this.state = State.ASSERTED;
        return new Asserted<Object>(result);
    }

    private void runAssertionsWhenNothingThrown(R result, Object messageOrSupplier) throws AssertionFailedError {
        if (this.nothingThrownAsserter != null) {
            this.nothingThrownAsserter.accept(result);
            return;
        }
        throw AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).reasonPattern("Expected one of %s to be thrown, but nothing was thrown.").withValues(this.expectedErrorTypes).format().build();
    }

    private void runAssertionsForError(Throwable actualError, Object messageOrSupplier) throws AssertionFailedError {
        boolean hasRunAssertions = this.runAllAssertions(actualError);
        if (hasRunAssertions) {
            return;
        }
        ThrowableAssertions.rethrowIfUnrecoverable(actualError);
        throw ThrowableAssertions.unexpectedExceptionTypeThrown().message(messageOrSupplier).expectedOneOf(this.expectedErrorTypes).actual(actualError.getClass()).cause(actualError).build();
    }

    boolean runAllAssertions(Throwable actualError) {
        Class<?> errorType = actualError.getClass();
        boolean hasRunAssertions = false;
        Consumer<? super Throwable> asserter = this.exactErrors.get(errorType);
        if (asserter != null) {
            asserter.accept(actualError);
            hasRunAssertions = true;
        }
        for (Class<?> iterator = errorType; iterator != Object.class; iterator = iterator.getSuperclass()) {
            asserter = this.errors.get(iterator);
            if (asserter == null) continue;
            asserter.accept(actualError);
            hasRunAssertions = true;
        }
        return hasRunAssertions;
    }

    State state() {
        return this.state;
    }

    Class<? extends Throwable> configuringErrorType() {
        return this.configuringErrorType;
    }

    boolean configuringExactErrorType() {
        return this.configuringExactErrorType;
    }

    static enum State {
        INITIALIZED("initialized"),
        CONFIGURING_ERROR_TYPE("configuring assertions for an error type"),
        CONFIGURING_NO_ERROR("configuring assertions for no error"),
        CONFIGURED("configured"),
        ASSERTED("asserted");

        private final String stringValue;

        private State(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static final class Asserted<R> {
        private final R result;
        private final Throwable thrown;

        private Asserted(R result) {
            this.result = result;
            this.thrown = null;
        }

        private Asserted(Throwable thrown) {
            this.result = null;
            this.thrown = thrown;
        }

        public Optional<R> andReturnResult() {
            return Optional.ofNullable(this.result);
        }

        public Throwable andReturnError() {
            if (this.thrown == null) {
                throw new IllegalStateException("Nothing was thrown");
            }
            return this.thrown;
        }

        public <T extends Throwable> T andReturnErrorAs(Class<T> errorType) {
            if (this.thrown == null) {
                throw new IllegalStateException("Nothing was thrown");
            }
            return (T)((Throwable)errorType.cast(this.thrown));
        }

        public Optional<Throwable> andReturnErrorIfThrown() {
            return Optional.ofNullable(this.thrown);
        }

        public <T extends Throwable> Optional<T> andReturnErrorIfThrownAs(Class<T> errorType) {
            return this.thrown == null ? Optional.empty() : Optional.of((Throwable)errorType.cast(this.thrown));
        }
    }

    public static final class NoError<R> {
        private final ThrowableAsserter<R> throwableAsserter;

        private NoError(ThrowableAsserter<R> throwableAsserter) {
            this.throwableAsserter = throwableAsserter;
        }

        public ThrowableAsserter<R> thenAssert(Runnable asserter) {
            Objects.requireNonNull(asserter);
            return this.configureAssertions(r -> asserter.run());
        }

        public ThrowableAsserter<R> thenAssert(Consumer<? super R> asserter) {
            Objects.requireNonNull(asserter);
            return this.configureAssertions(asserter);
        }

        public ThrowableAsserter<R> thenAssertNothing() {
            return this.configureAssertions(DO_NOTHING_CONSUMER);
        }

        private ThrowableAsserter<R> configureAssertions(Consumer<? super R> asserter) {
            if (this.throwableAsserter.state != State.CONFIGURING_NO_ERROR) {
                throw new IllegalStateException("Cannot specify assertions for no error when current state is " + this.throwableAsserter.state);
            }
            this.throwableAsserter.nothingThrownAsserter = asserter;
            this.throwableAsserter.state = State.CONFIGURED;
            return this.throwableAsserter;
        }

        ThrowableAsserter<R> throwableAsserter() {
            return this.throwableAsserter;
        }
    }

    public static final class ThrownError<T extends Throwable, R> {
        private final ThrowableAsserter<R> throwableAsserter;
        private final Class<T> errorType;
        private final Map<Class<? extends Throwable>, Consumer<? super Throwable>> errorMap;
        private final boolean exact;

        private ThrownError(ThrowableAsserter<R> throwableAsserter, Class<T> errorType, Map<Class<? extends Throwable>, Consumer<? super Throwable>> errorMap, boolean exact) {
            this.throwableAsserter = throwableAsserter;
            this.errorType = errorType;
            this.errorMap = errorMap;
            this.exact = exact;
        }

        public ThrowableAsserter<R> thenAssert(Consumer<? super T> asserter) {
            Objects.requireNonNull(asserter);
            return this.configureAssertions(asserter);
        }

        public ThrowableAsserter<R> thenAssertNothing() {
            return this.configureAssertions(DO_NOTHING_CONSUMER);
        }

        private ThrowableAsserter<R> configureAssertions(Consumer<? super Throwable> asserter) {
            if (this.throwableAsserter.state != State.CONFIGURING_ERROR_TYPE) {
                throw new IllegalStateException("Cannot specify assertions for an error type when current state is " + this.throwableAsserter.state);
            }
            if (this.errorType != this.throwableAsserter.configuringErrorType || this.exact != this.throwableAsserter.configuringExactErrorType) {
                throw new IllegalStateException(String.format("Cannot specify assertions; currently configuring for %s (exact: %b)", this.throwableAsserter.configuringErrorType, this.throwableAsserter.configuringExactErrorType));
            }
            this.errorMap.put(this.errorType, asserter);
            this.throwableAsserter.state = State.CONFIGURED;
            this.throwableAsserter.configuringErrorType = null;
            this.throwableAsserter.configuringExactErrorType = false;
            return this.throwableAsserter;
        }

        ThrowableAsserter<R> throwableAsserter() {
            return this.throwableAsserter;
        }
    }
}

