/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support;

import com.github.robtimus.junit.support.AssertionFailedErrorBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

public final class ThrowableAssertions {
    private static final String CAUSED_BY = "caused by";
    private static final int DEFAULT_MAX_DEPTH = 20;

    private ThrowableAssertions() {
    }

    public static <T extends Throwable> T assertHasDirectCause(Class<T> expectedType, Throwable throwable) {
        return ThrowableAssertions.assertHasDirectCause(expectedType, throwable, null);
    }

    public static <T extends Throwable> T assertHasDirectCause(Class<T> expectedType, Throwable throwable, String message) {
        return ThrowableAssertions.assertHasDirectCause(expectedType, throwable, (Object)message);
    }

    public static <T extends Throwable> T assertHasDirectCause(Class<T> expectedType, Throwable throwable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertHasDirectCause(expectedType, throwable, messageSupplier);
    }

    private static <T extends Throwable> T assertHasDirectCause(Class<T> expectedType, Throwable throwable, Object messageOrSupplier) {
        Throwable cause = throwable.getCause();
        if (expectedType.isInstance(cause)) {
            return (T)((Throwable)expectedType.cast(cause));
        }
        throw AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).prefixed(CAUSED_BY).expected(expectedType).actual(cause).build();
    }

    public static <T extends Throwable> T assertHasCause(Class<T> expectedType, Throwable throwable) {
        return ThrowableAssertions.assertHasCause(expectedType, throwable, null);
    }

    public static <T extends Throwable> T assertHasCause(Class<T> expectedType, Throwable throwable, String message) {
        return ThrowableAssertions.assertHasCause(expectedType, throwable, (Object)message);
    }

    public static <T extends Throwable> T assertHasCause(Class<T> expectedType, Throwable throwable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertHasCause(expectedType, throwable, messageSupplier);
    }

    private static <T extends Throwable> T assertHasCause(Class<T> expectedType, Throwable throwable, Object messageOrSupplier) {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            if (expectedType.isInstance(cause)) {
                return (T)((Throwable)expectedType.cast(cause));
            }
            causes.add(cause);
        }
        AssertionFailedErrorBuilder builder = AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).prefixed(CAUSED_BY).expected(expectedType);
        throw causes.isEmpty() ? builder.prefixed(CAUSED_BY).actual(null).build() : builder.prefixed(CAUSED_BY).actualValues(causes).build();
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrows(Class<T> expectedType, Executable executable) {
        return ThrowableAssertions.assertOptionallyThrows(expectedType, executable, null);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrows(Class<T> expectedType, Executable executable, String message) {
        return ThrowableAssertions.assertOptionallyThrows(expectedType, executable, (Object)message);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrows(Class<T> expectedType, Executable executable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertOptionallyThrows(expectedType, executable, messageSupplier);
    }

    private static <T extends Throwable> Optional<T> assertOptionallyThrows(Class<T> expectedType, Executable executable, Object messageOrSupplier) {
        try {
            executable.execute();
            return Optional.empty();
        }
        catch (Throwable actualException) {
            if (expectedType.isInstance(actualException)) {
                return Optional.of((Throwable)expectedType.cast(actualException));
            }
            ThrowableAssertions.rethrowIfUnrecoverable(actualException);
            throw ThrowableAssertions.unexpectedExceptionTypeThrown().message(messageOrSupplier).expected(expectedType).actual(actualException.getClass()).cause(actualException).build();
        }
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactly(Class<T> expectedType, Executable executable) {
        return ThrowableAssertions.assertOptionallyThrowsExactly(expectedType, executable, null);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactly(Class<T> expectedType, Executable executable, String message) {
        return ThrowableAssertions.assertOptionallyThrowsExactly(expectedType, executable, (Object)message);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactly(Class<T> expectedType, Executable executable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertOptionallyThrowsExactly(expectedType, executable, messageSupplier);
    }

    private static <T extends Throwable> Optional<T> assertOptionallyThrowsExactly(Class<T> expectedType, Executable executable, Object messageOrSupplier) {
        try {
            executable.execute();
            return Optional.empty();
        }
        catch (Throwable actualException) {
            if (expectedType.equals(actualException.getClass())) {
                return Optional.of((Throwable)expectedType.cast(actualException));
            }
            ThrowableAssertions.rethrowIfUnrecoverable(actualException);
            throw ThrowableAssertions.unexpectedExceptionTypeThrown().message(messageOrSupplier).expected(expectedType).actual(actualException.getClass()).cause(actualException).build();
        }
    }

    public static <T extends Throwable> T assertThrowsExactlyOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertThrowsExactlyOneOf(expectedTypes, executable);
    }

    public static <T extends Throwable> T assertThrowsExactlyOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, String message) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertThrowsExactlyOneOf(expectedTypes, executable, message);
    }

    public static <T extends Throwable> T assertThrowsExactlyOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, Supplier<String> messageSupplier) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertThrowsExactlyOneOf(expectedTypes, executable, messageSupplier);
    }

    public static <T extends Throwable> T assertThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable) {
        return ThrowableAssertions.assertThrowsExactlyOneOf(expectedTypes, executable, null);
    }

    public static <T extends Throwable> T assertThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, String message) {
        return ThrowableAssertions.assertThrowsExactlyOneOf(expectedTypes, executable, (Object)message);
    }

    public static <T extends Throwable> T assertThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertThrowsExactlyOneOf(expectedTypes, executable, messageSupplier);
    }

    private static <T extends Throwable> T assertThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Object messageOrSupplier) {
        return (T)((Throwable)ThrowableAssertions.assertOptionallyThrowsExactlyOneOf(expectedTypes, executable, messageOrSupplier).orElseThrow(() -> AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).reasonPattern("Expected one of %s to be thrown, but nothing was thrown.").withValues(expectedTypes).format().build()));
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactlyOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertOptionallyThrowsExactlyOneOf(expectedTypes, executable);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactlyOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, String message) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertOptionallyThrowsExactlyOneOf(expectedTypes, executable, message);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactlyOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, Supplier<String> messageSupplier) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertOptionallyThrowsExactlyOneOf(expectedTypes, executable, messageSupplier);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable) {
        return ThrowableAssertions.assertOptionallyThrowsExactlyOneOf(expectedTypes, executable, null);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, String message) {
        return ThrowableAssertions.assertOptionallyThrowsExactlyOneOf(expectedTypes, executable, (Object)message);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertOptionallyThrowsExactlyOneOf(expectedTypes, executable, messageSupplier);
    }

    private static <T extends Throwable> Optional<T> assertOptionallyThrowsExactlyOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Object messageOrSupplier) {
        try {
            executable.execute();
            return Optional.empty();
        }
        catch (Throwable actualException) {
            for (Class<T> expectedType : expectedTypes) {
                if (!expectedType.equals(actualException.getClass())) continue;
                return Optional.of((Throwable)expectedType.cast(actualException));
            }
            ThrowableAssertions.rethrowIfUnrecoverable(actualException);
            throw ThrowableAssertions.unexpectedExceptionTypeThrown().message(messageOrSupplier).expectedOneOf(expectedTypes).actual(actualException.getClass()).cause(actualException).build();
        }
    }

    public static <T extends Throwable> T assertThrowsOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertThrowsOneOf(expectedTypes, executable);
    }

    public static <T extends Throwable> T assertThrowsOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, String message) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertThrowsOneOf(expectedTypes, executable, message);
    }

    public static <T extends Throwable> T assertThrowsOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, Supplier<String> messageSupplier) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertThrowsOneOf(expectedTypes, executable, messageSupplier);
    }

    public static <T extends Throwable> T assertThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable) {
        return ThrowableAssertions.assertThrowsOneOf(expectedTypes, executable, null);
    }

    public static <T extends Throwable> T assertThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, String message) {
        return ThrowableAssertions.assertThrowsOneOf(expectedTypes, executable, (Object)message);
    }

    public static <T extends Throwable> T assertThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertThrowsOneOf(expectedTypes, executable, messageSupplier);
    }

    private static <T extends Throwable> T assertThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Object messageOrSupplier) {
        return (T)((Throwable)ThrowableAssertions.assertOptionallyThrowsOneOf(expectedTypes, executable, messageOrSupplier).orElseThrow(() -> AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).reasonPattern("Expected one of %s to be thrown, but nothing was thrown.").withValues(expectedTypes).format().build()));
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertOptionallyThrowsOneOf(expectedTypes, executable);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, String message) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertOptionallyThrowsOneOf(expectedTypes, executable, message);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsOneOf(Class<? extends T> expectedType1, Class<? extends T> expectedType2, Executable executable, Supplier<String> messageSupplier) {
        List<Class<? extends T>> expectedTypes = Arrays.asList(expectedType1, expectedType2);
        return ThrowableAssertions.assertOptionallyThrowsOneOf(expectedTypes, executable, messageSupplier);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable) {
        return ThrowableAssertions.assertOptionallyThrowsOneOf(expectedTypes, executable, null);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, String message) {
        return ThrowableAssertions.assertOptionallyThrowsOneOf(expectedTypes, executable, (Object)message);
    }

    public static <T extends Throwable> Optional<T> assertOptionallyThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertOptionallyThrowsOneOf(expectedTypes, executable, messageSupplier);
    }

    private static <T extends Throwable> Optional<T> assertOptionallyThrowsOneOf(Collection<Class<? extends T>> expectedTypes, Executable executable, Object messageOrSupplier) {
        try {
            executable.execute();
            return Optional.empty();
        }
        catch (Throwable actualException) {
            for (Class<T> expectedType : expectedTypes) {
                if (!expectedType.isInstance(actualException)) continue;
                return Optional.of((Throwable)expectedType.cast(actualException));
            }
            ThrowableAssertions.rethrowIfUnrecoverable(actualException);
            throw ThrowableAssertions.unexpectedExceptionTypeThrown().message(messageOrSupplier).expectedOneOf(expectedTypes).actual(actualException.getClass()).cause(actualException).build();
        }
    }

    public static void assertDoesNotThrowCheckedException(Executable executable) {
        try {
            executable.execute();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            Assertions.assertDoesNotThrow(() -> {
                throw t;
            });
        }
    }

    public static void assertDoesNotThrowCheckedException(Executable executable, String message) {
        try {
            executable.execute();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            Assertions.assertDoesNotThrow(() -> {
                throw t;
            }, (String)message);
        }
    }

    public static void assertDoesNotThrowCheckedException(Executable executable, Supplier<String> messageSupplier) {
        try {
            executable.execute();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            Assertions.assertDoesNotThrow(() -> {
                throw t;
            }, messageSupplier);
        }
    }

    public static <T> T assertDoesNotThrowCheckedException(ThrowingSupplier<T> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            return (T)Assertions.assertDoesNotThrow(() -> {
                throw t;
            });
        }
    }

    public static <T> T assertDoesNotThrowCheckedException(ThrowingSupplier<T> supplier, String message) {
        try {
            return (T)supplier.get();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            return (T)Assertions.assertDoesNotThrow(() -> {
                throw t;
            }, (String)message);
        }
    }

    public static <T> T assertDoesNotThrowCheckedException(ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        try {
            return (T)supplier.get();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            return (T)Assertions.assertDoesNotThrow(() -> {
                throw t;
            }, messageSupplier);
        }
    }

    public static Throwable assertChainEquals(Throwable expected, Throwable actual) {
        return ThrowableAssertions.assertChainEquals(expected, actual, 20);
    }

    public static Throwable assertChainEquals(Throwable expected, Throwable actual, int maxDepth) {
        ThrowableAssertions.validateMaxDepth(maxDepth);
        return ThrowableAssertions.assertChainEquals(expected, actual, maxDepth, null);
    }

    public static Throwable assertChainEquals(Throwable expected, Throwable actual, String message) {
        return ThrowableAssertions.assertChainEquals(expected, actual, 20, message);
    }

    public static Throwable assertChainEquals(Throwable expected, Throwable actual, int maxDepth, String message) {
        ThrowableAssertions.validateMaxDepth(maxDepth);
        return ThrowableAssertions.assertChainEquals(expected, actual, maxDepth, (Object)message);
    }

    public static Throwable assertChainEquals(Throwable expected, Throwable actual, Supplier<String> messageSupplier) {
        return ThrowableAssertions.assertChainEquals(expected, actual, 20, messageSupplier);
    }

    public static Throwable assertChainEquals(Throwable expected, Throwable actual, int maxDepth, Supplier<String> messageSupplier) {
        ThrowableAssertions.validateMaxDepth(maxDepth);
        return ThrowableAssertions.assertChainEquals(expected, actual, maxDepth, messageSupplier);
    }

    private static void validateMaxDepth(int maxDepth) {
        Assertions.assertTrue((maxDepth >= 0 ? 1 : 0) != 0, (String)"maxDepth must not be negative");
    }

    private static Throwable assertChainEquals(Throwable expected, Throwable actual, int maxDepth, Object messageOrSupplier) {
        String actualChainString;
        String expectedChainString = ThrowableAssertions.toChainString(expected, maxDepth);
        if (Objects.equals(expectedChainString, actualChainString = ThrowableAssertions.toChainString(actual, maxDepth))) {
            return ThrowableAssertions.getCause(actual, maxDepth);
        }
        throw AssertionFailedErrorBuilder.assertionFailedError().message(messageOrSupplier).expected(expectedChainString).actual(actualChainString).build();
    }

    private static String toChainString(Throwable throwable, int maxDepth) {
        if (throwable == null) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(" caused by ");
        Throwable iterator = throwable;
        for (int depth = 0; iterator != null && depth <= maxDepth; iterator = iterator.getCause(), ++depth) {
            joiner.add(String.format("%s(%s)", iterator.getClass().getName(), iterator.getMessage()));
        }
        return joiner.toString();
    }

    private static Throwable getCause(Throwable throwable, int maxDepth) {
        if (throwable == null) {
            return null;
        }
        Throwable result = throwable;
        for (int depth = 0; result != null && depth <= maxDepth; result = result.getCause(), ++depth) {
        }
        return result;
    }

    static AssertionFailedErrorBuilder unexpectedExceptionTypeThrown() {
        return AssertionFailedErrorBuilder.assertionFailedError().reason("Unexpected exception type thrown");
    }

    static void rethrowIfUnrecoverable(Throwable exception) {
        if (exception instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)exception;
        }
    }
}

