/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.concurrent;

import com.github.robtimus.junit.support.concurrent.ConcurrentRunner;

public final class ConcurrencySettings {
    private final int count;
    private int threadCount;

    private ConcurrencySettings(int count) {
        this.count = count;
        this.threadCount = Integer.MAX_VALUE;
    }

    public static ConcurrencySettings withCount(int count) {
        ConcurrentRunner.validateCount(count);
        return new ConcurrencySettings(count);
    }

    public ConcurrencySettings withThreadCount(int threadCount) {
        ConcurrentRunner.validateThreadCount(threadCount);
        this.threadCount = threadCount;
        return this;
    }

    public int count() {
        return this.count;
    }

    public int threadCount() {
        return this.threadCount;
    }
}

