/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.concurrent;

import java.util.List;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.opentest4j.MultipleFailuresError;

final class ConcurrentResult<T> {
    private final T result;
    private final Throwable failure;

    ConcurrentResult(T result) {
        this.result = result;
        this.failure = null;
    }

    ConcurrentResult(Throwable failure) {
        this.result = null;
        this.failure = failure;
    }

    T getOrThrow() {
        if (this.failure != null) {
            ConcurrentResult.throwUnchecked(this.failure);
        }
        return this.result;
    }

    T result() {
        return this.result;
    }

    Throwable failure() {
        return this.failure;
    }

    static void throwUnchecked(Throwable failure) {
        if (failure instanceof Error) {
            throw (Error)failure;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        throw AssertionFailureBuilder.assertionFailure().reason("Unexpected exception thrown: " + failure).cause(failure).build();
    }

    static void throwUnchecked(List<Throwable> failures) {
        if (failures.isEmpty()) {
            return;
        }
        if (failures.size() > 1) {
            MultipleFailuresError error = new MultipleFailuresError(null, failures);
            failures.forEach(arg_0 -> error.addSuppressed(arg_0));
            throw error;
        }
        Throwable singleFailure = failures.get(0);
        ConcurrentResult.throwUnchecked(singleFailure);
    }
}

