/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.concurrent;

import com.github.robtimus.junit.support.concurrent.ConcurrentResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ConcurrentResults<T> {
    private final Stream<ConcurrentResult<T>> results;

    ConcurrentResults(Stream<ConcurrentResult<T>> results) {
        this.results = results;
    }

    public Stream<T> andStreamResults() {
        return this.results.map(ConcurrentResult::getOrThrow);
    }

    public <R> R andCollectResults(Collector<T, ?, R> collector) {
        Objects.requireNonNull(collector);
        return this.results.collect(ConcurrentResults.resultCollector(collector));
    }

    public List<T> andListResults() {
        return this.andCollectResults(Collectors.toList());
    }

    public void andAssertNoFailures() {
        List<Throwable> failures = this.results.map(ConcurrentResult::failure).filter(Objects::nonNull).collect(Collectors.toList());
        ConcurrentResult.throwUnchecked(failures);
    }

    static <T, R> Collector<ConcurrentResult<T>, ?, R> resultCollector(Collector<T, ?, R> collector) {
        return Collector.of(() -> new ResultCollector(collector), (rec$, x$0) -> ((ResultCollector)rec$).accumulate(x$0), (rec$, x$0) -> ((ResultCollector)rec$).combine(x$0), rec$ -> ((ResultCollector)rec$).finish(), new Collector.Characteristics[0]);
    }

    static final class ResultCollector<T, A, R> {
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final List<Throwable> failures = new ArrayList<Throwable>();
        private A state;

        private ResultCollector(Collector<T, A, R> collector) {
            this.accumulator = collector.accumulator();
            this.combiner = collector.combiner();
            this.finisher = collector.finisher();
            this.state = collector.supplier().get();
        }

        private void accumulate(ConcurrentResult<T> result) {
            Throwable failure = result.failure();
            if (failure != null) {
                this.failures.add(failure);
            } else {
                this.accumulator.accept(this.state, result.result());
            }
        }

        private ResultCollector<T, A, R> combine(ResultCollector<T, A, R> other) {
            this.failures.addAll(other.failures);
            this.state = this.combiner.apply(this.state, other.state);
            return this;
        }

        private R finish() {
            ConcurrentResult.throwUnchecked(this.failures);
            return this.finisher.apply(this.state);
        }
    }
}

