/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.concurrent;

import com.github.robtimus.junit.support.concurrent.ConcurrencySettings;
import com.github.robtimus.junit.support.concurrent.ConcurrentResult;
import com.github.robtimus.junit.support.concurrent.ConcurrentResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

public final class ConcurrentRunner<T> {
    private final List<ThrowingSupplier<? extends T>> suppliers;
    private int threadCount = Integer.MAX_VALUE;

    private ConcurrentRunner() {
        this.suppliers = new ArrayList<ThrowingSupplier<? extends T>>();
    }

    public static <T> ConcurrentRunner<T> running(ThrowingSupplier<? extends T> supplier) {
        return ConcurrentRunner.running(supplier, 1);
    }

    public static <T> ConcurrentRunner<T> running(ThrowingSupplier<? extends T> supplier, int count) {
        ConcurrentRunner<? extends T> runner = new ConcurrentRunner<T>();
        return runner.concurrentlyWith(supplier, count);
    }

    public static ConcurrentRunner<Void> running(Executable executable) {
        return ConcurrentRunner.running(executable, 1);
    }

    public static ConcurrentRunner<Void> running(Executable executable, int count) {
        Objects.requireNonNull(executable);
        return ConcurrentRunner.running(ConcurrentRunner.asSupplier(executable), count);
    }

    public ConcurrentRunner<T> concurrentlyWith(ThrowingSupplier<? extends T> supplier) {
        return this.concurrentlyWith(supplier, 1);
    }

    public ConcurrentRunner<T> concurrentlyWith(ThrowingSupplier<? extends T> supplier, int count) {
        Objects.requireNonNull(supplier);
        ConcurrentRunner.validateCount(count);
        for (int i = 0; i < count; ++i) {
            this.suppliers.add(supplier);
        }
        return this;
    }

    public ConcurrentRunner<T> concurrentlyWith(Executable executable) {
        return this.concurrentlyWith(executable, 1);
    }

    public ConcurrentRunner<T> concurrentlyWith(Executable executable, int count) {
        Objects.requireNonNull(executable);
        return this.concurrentlyWith(ConcurrentRunner.asSupplier(executable), count);
    }

    public ConcurrentRunner<T> withThreadCount(int threadCount) {
        ConcurrentRunner.validateThreadCount(threadCount);
        this.threadCount = threadCount;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentResults<T> execute() {
        int poolSize = Math.min(this.suppliers.size(), this.threadCount);
        ExecutorService executor = Executors.newFixedThreadPool(poolSize);
        try {
            ConcurrentResults<T> concurrentResults = this.execute(executor, poolSize);
            return concurrentResults;
        }
        finally {
            executor.shutdown();
            boolean isTerminated = (Boolean)Assertions.assertDoesNotThrow(() -> executor.awaitTermination(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)isTerminated, (String)"The executor should have terminated within 5 seconds");
        }
    }

    private ConcurrentResults<T> execute(ExecutorService executor, int poolSize) {
        CountDownLatch readyLatch = new CountDownLatch(poolSize);
        CountDownLatch startLatch = new CountDownLatch(1);
        List futures = this.suppliers.stream().map(supplier -> this.newFuture((ThrowingSupplier<? extends T>)supplier, executor, readyLatch, startLatch)).collect(Collectors.toList());
        Assertions.assertDoesNotThrow(() -> readyLatch.await());
        startLatch.countDown();
        Stream results = futures.stream().map(CompletableFuture::join).collect(Collectors.toList()).stream();
        return new ConcurrentResults(results);
    }

    private CompletableFuture<ConcurrentResult<T>> newFuture(ThrowingSupplier<? extends T> supplier, ExecutorService executor, CountDownLatch readyLatch, CountDownLatch startLatch) {
        return CompletableFuture.supplyAsync(() -> this.call(supplier, readyLatch, startLatch), executor);
    }

    private ConcurrentResult<T> call(ThrowingSupplier<? extends T> supplier, CountDownLatch readyLatch, CountDownLatch startLatch) {
        readyLatch.countDown();
        Assertions.assertDoesNotThrow(() -> startLatch.await());
        try {
            Object result = supplier.get();
            return new ConcurrentResult<Object>(result);
        }
        catch (Throwable t) {
            return new ConcurrentResult(t);
        }
    }

    public static void runConcurrently(Executable executable, int count) {
        ConcurrentRunner.running(executable, count).execute().andAssertNoFailures();
    }

    public static void runConcurrently(Executable executable, ConcurrencySettings settings) {
        ConcurrentRunner.running(executable, settings.count()).withThreadCount(settings.threadCount()).execute().andAssertNoFailures();
    }

    public static void runConcurrently(Executable ... executables) {
        ConcurrentRunner.runConcurrently(Arrays.asList(executables));
    }

    public static void runConcurrently(List<Executable> executables) {
        if (executables.isEmpty()) {
            return;
        }
        Iterator<Executable> iterator = executables.iterator();
        ConcurrentRunner<Void> runner = ConcurrentRunner.running(iterator.next());
        while (iterator.hasNext()) {
            runner.concurrentlyWith(iterator.next());
        }
        runner.execute().andAssertNoFailures();
    }

    private static <T> ThrowingSupplier<T> asSupplier(Executable executable) {
        return () -> {
            executable.execute();
            return null;
        };
    }

    static void validateCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException(count + " < 1");
        }
    }

    static void validateThreadCount(int threadCount) {
        if (threadCount < 2) {
            throw new IllegalArgumentException(threadCount + " < 2");
        }
    }
}

