/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension;

import com.github.robtimus.junit.support.extension.InjectingExtension;
import com.github.robtimus.junit.support.extension.InjectionTarget;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;

public abstract class AnnotationBasedInjectingExtension<A extends Annotation>
extends InjectingExtension {
    private final Class<A> annotationType;

    protected AnnotationBasedInjectingExtension(Class<A> annotationType, MethodHandles.Lookup lookup) {
        super((Field field) -> AnnotationSupport.isAnnotated((AnnotatedElement)field, (Class)annotationType), lookup);
        this.annotationType = Objects.requireNonNull(annotationType);
    }

    @Override
    protected final Optional<JUnitException> validateTarget(InjectionTarget target, ExtensionContext context) {
        Annotation annotation = target.findAnnotation(this.annotationType).orElse(null);
        if (annotation == null) {
            return Optional.of(target.createException("Target not annotated with @" + this.annotationType.getSimpleName()));
        }
        return this.validateTarget(target, annotation, context);
    }

    protected abstract Optional<JUnitException> validateTarget(InjectionTarget var1, A var2, ExtensionContext var3);

    @Override
    protected final Object resolveValue(InjectionTarget target, ExtensionContext context) throws Exception {
        Annotation annotation = (Annotation)target.findAnnotation(this.annotationType).orElseThrow(IllegalStateException::new);
        return this.resolveValue(target, annotation, context);
    }

    protected abstract Object resolveValue(InjectionTarget var1, A var2, ExtensionContext var3) throws Exception;
}

