/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension;

import com.github.robtimus.junit.support.extension.InjectionTarget;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public abstract class InjectingExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    private final Predicate<Field> fieldPredicate;
    private final MethodHandles.Lookup lookup;

    protected InjectingExtension(Predicate<Field> fieldPredicate, MethodHandles.Lookup lookup) {
        this.fieldPredicate = Objects.requireNonNull(fieldPredicate);
        this.lookup = Objects.requireNonNull(lookup);
    }

    public final void beforeAll(ExtensionContext context) throws Exception {
        this.injectFields(null, context.getRequiredTestClass(), ModifierSupport::isStatic, context);
    }

    public final void beforeEach(ExtensionContext context) throws Exception {
        for (Object testInstance : context.getRequiredTestInstances().getAllInstances()) {
            this.injectFields(testInstance, testInstance.getClass(), ModifierSupport::isNotStatic, context);
        }
    }

    private void injectFields(Object testInstance, Class<?> testClass, Predicate<Field> predicate, ExtensionContext context) {
        for (Field field : ReflectionSupport.findFields(testClass, this.fieldPredicate.and(predicate), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN)) {
            this.setValue(field, testInstance, context);
        }
    }

    private void setValue(Field field, Object testInstance, ExtensionContext context) {
        InjectionTarget target = InjectionTarget.forField(field);
        this.validateTarget(target, context).ifPresent(e -> {
            throw e;
        });
        this.getClass().getModule().addReads(field.getDeclaringClass().getModule());
        try {
            Object value = this.resolveValue(target, context);
            if (Modifier.isStatic(field.getModifiers())) {
                this.getLookup(field, null).findStaticVarHandle(field.getDeclaringClass(), field.getName(), field.getType()).set(value);
            } else {
                this.getLookup(field, testInstance).findVarHandle(field.getDeclaringClass(), field.getName(), field.getType()).set(testInstance, value);
            }
        }
        catch (Exception e2) {
            InjectingExtension.throwAsUncheckedException(e2);
        }
    }

    private MethodHandles.Lookup getLookup(Field field, Object target) throws IllegalAccessException {
        return field.canAccess(target) ? this.lookup : MethodHandles.privateLookupIn(field.getDeclaringClass(), this.lookup);
    }

    public final boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        InjectionTarget target = InjectionTarget.forParameter(parameterContext);
        return !this.validateTarget(target, extensionContext).isPresent();
    }

    protected abstract Optional<JUnitException> validateTarget(InjectionTarget var1, ExtensionContext var2);

    public final Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        InjectionTarget target = InjectionTarget.forParameter(parameterContext);
        try {
            return this.resolveValue(target, extensionContext);
        }
        catch (Exception e) {
            return InjectingExtension.throwAsUncheckedException(e);
        }
    }

    protected abstract Object resolveValue(InjectionTarget var1, ExtensionContext var2) throws Exception;

    private static <T extends Throwable, R> R throwAsUncheckedException(Throwable t) throws T {
        throw t;
    }
}

