/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;

public final class InjectionTarget {
    private final Class<?> declaringClass;
    private final Class<?> type;
    private final Type genericType;
    private final BiFunction<Class<? extends Annotation>, Boolean, Optional<? extends Annotation>> annotationFinder;
    private final BiFunction<Class<? extends Annotation>, Boolean, List<? extends Annotation>> repeatableAnnotationFinder;
    private final Function<String, JUnitException> exceptionWithMessage;
    private final BiFunction<String, Throwable, JUnitException> exceptionWithMessageAndCause;

    private InjectionTarget(Class<?> declaringClass, Class<?> type, Type genericType, BiFunction<Class<? extends Annotation>, Boolean, Optional<? extends Annotation>> annotationFinder, BiFunction<Class<? extends Annotation>, Boolean, List<? extends Annotation>> repeatableAnnotationFinder, Function<String, JUnitException> exceptionWithMessage, BiFunction<String, Throwable, JUnitException> exceptionWithMessageAndCause) {
        this.declaringClass = declaringClass;
        this.type = type;
        this.genericType = genericType;
        this.annotationFinder = annotationFinder;
        this.repeatableAnnotationFinder = repeatableAnnotationFinder;
        this.exceptionWithMessage = exceptionWithMessage;
        this.exceptionWithMessageAndCause = exceptionWithMessageAndCause;
    }

    public Class<?> declaringClass() {
        return this.declaringClass;
    }

    public Class<?> type() {
        return this.type;
    }

    public Type genericType() {
        return this.genericType;
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        return this.isAnnotated(annotationType, false);
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType, boolean includeDeclaringElements) {
        return this.findAnnotation(annotationType, includeDeclaringElements).isPresent();
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return this.findAnnotation(annotationType, false);
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType, boolean includeDeclaringElements) {
        return this.annotationFinder.apply(annotationType, includeDeclaringElements);
    }

    public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> annotationType) {
        return this.findRepeatableAnnotations(annotationType, false);
    }

    public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> annotationType, boolean includeDeclaringElements) {
        return this.repeatableAnnotationFinder.apply(annotationType, includeDeclaringElements);
    }

    public JUnitException createException(String message) {
        return this.exceptionWithMessage.apply(message);
    }

    public JUnitException createException(String message, Throwable cause) {
        return this.exceptionWithMessageAndCause.apply(message, cause);
    }

    public static InjectionTarget forParameter(ParameterContext parameterContext) {
        Parameter parameter = parameterContext.getParameter();
        Class<?> declaringClass = parameterContext.getDeclaringExecutable().getDeclaringClass();
        return new InjectionTarget(declaringClass, parameter.getType(), parameter.getParameterizedType(), (annotationType, includeDeclaringElements) -> InjectionTarget.findAnnotation(parameterContext, annotationType, (boolean)includeDeclaringElements), (annotationType, includeDeclaringElements) -> InjectionTarget.findRepeatableAnnotations(parameterContext, annotationType, (boolean)includeDeclaringElements), ParameterResolutionException::new, ParameterResolutionException::new);
    }

    public static InjectionTarget forField(Field field) {
        return new InjectionTarget(field.getDeclaringClass(), field.getType(), field.getGenericType(), (annotationType, includeDeclaringElements) -> InjectionTarget.findAnnotation(field, annotationType, (boolean)includeDeclaringElements), (annotationType, includeDeclaringElements) -> InjectionTarget.findRepeatableAnnotations(field, annotationType, (boolean)includeDeclaringElements), ExtensionConfigurationException::new, ExtensionConfigurationException::new);
    }

    private static <A extends Annotation> Optional<A> findAnnotation(ParameterContext parameterContext, Class<A> annotationType, boolean includeDeclaringElements) {
        Optional annotation = parameterContext.findAnnotation(annotationType);
        if (annotation.isPresent() || !includeDeclaringElements) {
            return annotation;
        }
        Executable executable = parameterContext.getDeclaringExecutable();
        annotation = AnnotationSupport.findAnnotation((AnnotatedElement)executable, annotationType);
        if (annotation.isPresent()) {
            return annotation;
        }
        return InjectionTarget.findAnnotation(executable.getDeclaringClass(), annotationType);
    }

    private static <A extends Annotation> Optional<A> findAnnotation(Field field, Class<A> annotationType, boolean includeDeclaringElements) {
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)field, annotationType);
        if (annotation.isPresent() || !includeDeclaringElements) {
            return annotation;
        }
        return InjectionTarget.findAnnotation(field.getDeclaringClass(), annotationType);
    }

    private static <A extends Annotation> Optional<A> findAnnotation(Class<?> clazz, Class<A> annotationType) {
        for (Class<?> iterator = clazz; iterator != null; iterator = iterator.getDeclaringClass()) {
            Optional annotation = AnnotationSupport.findAnnotation(iterator, annotationType);
            if (!annotation.isPresent()) continue;
            return annotation;
        }
        return Optional.empty();
    }

    private static <A extends Annotation> List<A> findRepeatableAnnotations(ParameterContext parameterContext, Class<A> annotationType, boolean includeDeclaringElements) {
        List annotations = parameterContext.findRepeatableAnnotations(annotationType);
        if (!annotations.isEmpty() || !includeDeclaringElements) {
            return annotations;
        }
        Executable executable = parameterContext.getDeclaringExecutable();
        annotations = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)executable, annotationType);
        if (!annotations.isEmpty()) {
            return annotations;
        }
        return InjectionTarget.findRepeatableAnnotations(executable.getDeclaringClass(), annotationType);
    }

    private static <A extends Annotation> List<A> findRepeatableAnnotations(Field field, Class<A> annotationType, boolean includeDeclaringElements) {
        List annotations = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)field, annotationType);
        if (!annotations.isEmpty() || !includeDeclaringElements) {
            return annotations;
        }
        return InjectionTarget.findRepeatableAnnotations(field.getDeclaringClass(), annotationType);
    }

    private static <A extends Annotation> List<A> findRepeatableAnnotations(Class<?> clazz, Class<A> annotationType) {
        for (Class<?> iterator = clazz; iterator != null; iterator = iterator.getDeclaringClass()) {
            List annotations = AnnotationSupport.findRepeatableAnnotations(iterator, annotationType);
            if (annotations.isEmpty()) continue;
            return annotations;
        }
        return Collections.emptyList();
    }
}

