/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public final class MethodLookup {
    static final Pattern METHOD_REFERENCE_PATTERN = MethodLookup.createMethodReferencePattern();
    private final List<Class<?>[]> parameterTypeCombinations = new ArrayList<Class<?>[]>();
    private final List<String> combinationRepresentations = new ArrayList<String>();

    private MethodLookup() {
    }

    public static MethodLookup withParameterTypes(Class<?> ... parameterTypes) {
        MethodLookup lookup = new MethodLookup();
        lookup.addParameterTypes(parameterTypes);
        return lookup;
    }

    public MethodLookup orParameterTypes(Class<?> ... parameterTypes) {
        this.addParameterTypes(parameterTypes);
        return this;
    }

    private void addParameterTypes(Class<?> ... parameterTypes) {
        this.combinationRepresentations.add(this.toString(parameterTypes));
        this.parameterTypeCombinations.add((Class[])parameterTypes.clone());
    }

    private String toString(Class<?> ... classes) {
        return Arrays.stream(classes).map(this::toString).collect(Collectors.joining(", ", "(", ")"));
    }

    private String toString(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }

    public Result find(String methodReference, ExtensionContext context) {
        if (MethodLookup.isBlank(methodReference)) {
            throw new PreconditionViolationException("methodReference must not be null or blank");
        }
        Matcher matcher = METHOD_REFERENCE_PATTERN.matcher(methodReference);
        if (!matcher.matches()) {
            throw new PreconditionViolationException(String.format("[%s] is not a valid method reference: it must be the method name, optionally preceded by a fully qualified class name followed by a '#', and optionally followed by a parameter list enclosed in parentheses.", methodReference));
        }
        String className = MethodLookup.className(matcher);
        String methodName = MethodLookup.methodName(matcher);
        String methodArguments = MethodLookup.methodArguments(matcher);
        Class factoryClass = className == null ? context.getRequiredTestClass() : (Class)ReflectionSupport.tryToLoadClass((String)className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
        return methodArguments == null ? this.findUsingParameterTypes(factoryClass, methodName) : this.findUsingMethodArguments(factoryClass, methodName, methodArguments);
    }

    private Result findUsingParameterTypes(Class<?> factoryClass, String methodName) {
        ListIterator<Class<?>[]> iterator = this.parameterTypeCombinations.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Class[] parameterTypes = iterator.next();
            Method match = ReflectionSupport.findMethod(factoryClass, (String)methodName, (Class[])parameterTypes).orElse(null);
            if (match == null) continue;
            return new Result(match, index);
        }
        if (this.parameterTypeCombinations.size() == 1) {
            throw new PreconditionViolationException(String.format("Could not find method [%s] in class [%s] with parameter combination %s", methodName, factoryClass.getName(), this.combinationRepresentations.get(0)));
        }
        throw new PreconditionViolationException(String.format("Could not find method [%s] in class [%s] with a parameter combination in %s", methodName, factoryClass.getName(), this.combinationRepresentations));
    }

    private Result findUsingMethodArguments(Class<?> factoryClass, String methodName, String methodArguments) {
        Method method = (Method)ReflectionSupport.findMethod(factoryClass, (String)methodName, (String)methodArguments).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method [%s(%s)] in class [%s]", methodName, methodArguments, factoryClass.getName())));
        ListIterator<Class<?>[]> iterator = this.parameterTypeCombinations.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Class[] parameterTypes = iterator.next();
            Method match = ReflectionSupport.findMethod(factoryClass, (String)methodName, (Class[])parameterTypes).orElse(null);
            if (match == null || !method.equals(match)) continue;
            return new Result(method, index);
        }
        if (this.parameterTypeCombinations.size() == 1) {
            throw new PreconditionViolationException(String.format("Method [%s(%s)] in class [%s] does not have parameter combination %s", methodName, methodArguments, factoryClass.getName(), this.combinationRepresentations.get(0)));
        }
        throw new PreconditionViolationException(String.format("Method [%s(%s)] in class [%s] does not have a parameter combination in %s", methodName, methodArguments, factoryClass.getName(), this.combinationRepresentations));
    }

    public static Method findMethod(String methodReference, ExtensionContext context) {
        if (MethodLookup.isBlank(methodReference)) {
            throw new PreconditionViolationException("methodReference must not be null or blank");
        }
        Matcher matcher = METHOD_REFERENCE_PATTERN.matcher(methodReference);
        if (!matcher.matches()) {
            throw new PreconditionViolationException(String.format("[%s] is not a valid method reference: it must be the method name, optionally preceded by a fully qualified class name followed by a '#', and optionally followed by a parameter list enclosed in parentheses.", methodReference));
        }
        String className = MethodLookup.className(matcher);
        String methodName = MethodLookup.methodName(matcher);
        String methodArguments = MethodLookup.methodArguments(matcher);
        Class factoryClass = className == null ? context.getRequiredTestClass() : (Class)ReflectionSupport.tryToLoadClass((String)className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
        return methodArguments == null ? MethodLookup.findSingleMethodWithName(factoryClass, methodName) : MethodLookup.findMethodUsingMethodArguments(factoryClass, methodName, methodArguments);
    }

    private static Method findSingleMethodWithName(Class<?> factoryClass, String methodName) {
        List methods = ReflectionSupport.findMethods(factoryClass, method -> methodName.equals(method.getName()), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        if (methods.isEmpty()) {
            throw new PreconditionViolationException(String.format("Could not find method [%s] in class [%s]", methodName, factoryClass.getName()));
        }
        if (methods.size() > 1) {
            throw new PreconditionViolationException(String.format("Found several methods named [%s] in class [%s]", methodName, factoryClass.getName()));
        }
        return (Method)methods.get(0);
    }

    private static Method findMethodUsingMethodArguments(Class<?> factoryClass, String methodName, String methodArguments) {
        return (Method)ReflectionSupport.findMethod(factoryClass, (String)methodName, (String)methodArguments).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method [%s(%s)] in class [%s]", methodName, methodArguments, factoryClass.getName())));
    }

    private static boolean isBlank(String value) {
        return value == null || value.chars().allMatch(Character::isWhitespace);
    }

    private static Pattern createMethodReferencePattern() {
        String javaIdentifier = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        String javaType = String.format("%s(?:\\.%s)*", javaIdentifier, javaIdentifier);
        String classNamePart = String.format("(?<className>%s)", javaType);
        String methodNamePart = String.format("(?<methodName>%s)", javaIdentifier);
        String methodArgumentsPart = String.format("(?<methodArguments>(?:%s(?:,\\s*%s)*)?)", javaType, javaType);
        String regex = String.format("(?:%s#)?%s(?:\\(%s\\))?", classNamePart, methodNamePart, methodArgumentsPart);
        return Pattern.compile(regex);
    }

    static String className(Matcher matcher) {
        return matcher.group("className");
    }

    static String methodName(Matcher matcher) {
        return matcher.group("methodName");
    }

    static String methodArguments(Matcher matcher) {
        return matcher.group("methodArguments");
    }

    public static final class Result {
        private final Method method;
        private final int index;

        Result(Method method, int index) {
            this.method = method;
            this.index = index;
        }

        public Method method() {
            return this.method;
        }

        public int index() {
            return this.index;
        }
    }
}

