/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.logging;

import com.github.robtimus.junit.support.extension.logging.LogResourceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

final class JdkLogResourceFactory
extends LogResourceFactory {
    JdkLogResourceFactory() {
    }

    @Override
    Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
        return Factory.startCapture(logger, context);
    }

    @Override
    Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
        return Factory.disableLogging(logger);
    }

    private static final class Factory {
        private Factory() {
        }

        private static Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.startCapture((Logger)logger, context));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogCaptor startCapture(Logger logger, ExtensionContext context) {
            List<Handler> originalHandlers = Factory.listHandlers(logger);
            boolean originalUseParentHandlers = logger.getUseParentHandlers();
            originalHandlers.forEach(logger::removeHandler);
            logger.setUseParentHandlers(false);
            Handler capturingHandler = (Handler)Mockito.mock(Handler.class);
            logger.addHandler(capturingHandler);
            return () -> {
                Factory.restoreSettings(logger, originalHandlers, originalUseParentHandlers);
                context.getExecutionException().ifPresent(t -> Factory.logCaptured(logger, capturingHandler));
            };
        }

        private static List<Handler> listHandlers(Logger logger) {
            return new ArrayList<Handler>(Arrays.asList(logger.getHandlers()));
        }

        private static void restoreSettings(Logger logger, List<Handler> originalHandlers, boolean originalUseParentHandlers) {
            List<Handler> handlers = Factory.listHandlers(logger);
            handlers.forEach(logger::removeHandler);
            originalHandlers.forEach(logger::addHandler);
            logger.setUseParentHandlers(originalUseParentHandlers);
        }

        private static void logCaptured(Logger logger, Handler capturingHandler) {
            ArgumentCaptor recordCaptor = ArgumentCaptor.forClass(LogRecord.class);
            ((Handler)Mockito.verify((Object)capturingHandler, (VerificationMode)Mockito.atLeast((int)0))).publish((LogRecord)recordCaptor.capture());
            List logRecords = recordCaptor.getAllValues();
            logRecords.forEach(logger::log);
        }

        private static Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.disableLogging((Logger)logger));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogDisabler disableLogging(Logger logger) {
            Level originalLevel = logger.getLevel();
            logger.setLevel(Level.OFF);
            return () -> logger.setLevel(originalLevel);
        }
    }
}

