/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.logging;

import com.github.robtimus.junit.support.extension.logging.LogResourceFactory;
import com.github.robtimus.junit.support.extension.testlogger.Log4jNullAppender;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

final class Log4jLogResourceFactory
extends LogResourceFactory {
    Log4jLogResourceFactory() {
    }

    @Override
    Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
        return Factory.startCapture(logger, context);
    }

    @Override
    Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
        return Factory.disableLogging(logger);
    }

    private static final class Factory {
        private Factory() {
        }

        private static Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.startCapture((Logger)logger, context));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogCaptor startCapture(Logger logger, ExtensionContext context) {
            List<Appender> originalAppenders = Factory.listAppenders(logger);
            boolean originalAdditive = logger.isAdditive();
            originalAppenders.forEach(arg_0 -> ((Logger)logger).removeAppender(arg_0));
            logger.setAdditive(false);
            Log4jNullAppender capturingAppender = (Log4jNullAppender)((Object)Mockito.spy((Object)((Object)Log4jNullAppender.create("LogOnFailure-" + UUID.randomUUID().toString()))));
            logger.addAppender((Appender)capturingAppender);
            return () -> {
                Factory.restoreSettings(logger, originalAppenders, originalAdditive);
                context.getExecutionException().ifPresent(t -> Factory.logCaptured(logger, capturingAppender));
            };
        }

        private static List<Appender> listAppenders(Logger logger) {
            return new ArrayList<Appender>(logger.getAppenders().values());
        }

        private static void restoreSettings(Logger logger, List<Appender> originalAppenders, boolean originalAdditive) {
            List<Appender> appenders = Factory.listAppenders(logger);
            appenders.forEach(arg_0 -> ((Logger)logger).removeAppender(arg_0));
            originalAppenders.forEach(arg_0 -> ((Logger)logger).addAppender(arg_0));
            logger.setAdditive(originalAdditive);
        }

        private static void logCaptured(Logger logger, Log4jNullAppender capturingAppender) {
            ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(LogEvent.class);
            ((Log4jNullAppender)((Object)Mockito.verify((Object)((Object)capturingAppender), (VerificationMode)Mockito.atLeast((int)0)))).ignore((LogEvent)eventCaptor.capture());
            List events = eventCaptor.getAllValues();
            LoggerConfig loggerConfig = logger.get();
            events.forEach(arg_0 -> ((LoggerConfig)loggerConfig).log(arg_0));
        }

        private static Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.disableLogging((Logger)logger));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogDisabler disableLogging(Logger logger) {
            Level originalLevel = logger.getLevel();
            logger.setLevel(Level.OFF);
            return () -> logger.setLevel(originalLevel);
        }
    }
}

