/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.github.robtimus.junit.support.extension.logging.LogResourceFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

final class LogbackLogResourceFactory
extends LogResourceFactory {
    LogbackLogResourceFactory() {
    }

    @Override
    Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
        return Factory.startCapture(logger, context);
    }

    @Override
    Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
        return Factory.disableLogging(logger);
    }

    private static final class Factory {
        private Factory() {
        }

        private static Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.startCapture((Logger)logger, context));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogCaptor startCapture(Logger logger, ExtensionContext context) {
            List<Appender<ILoggingEvent>> originalAppenders = Factory.listAppenders(logger);
            boolean originalAdditive = logger.isAdditive();
            originalAppenders.forEach(arg_0 -> ((Logger)logger).detachAppender(arg_0));
            logger.setAdditive(false);
            Appender capturingAppender = (Appender)Mockito.mock(Appender.class);
            logger.addAppender(capturingAppender);
            return () -> {
                Factory.restoreSettings(logger, originalAppenders, originalAdditive);
                context.getExecutionException().ifPresent(t -> Factory.logCaptured(logger, (Appender<ILoggingEvent>)capturingAppender));
            };
        }

        private static List<Appender<ILoggingEvent>> listAppenders(Logger logger) {
            ArrayList<Appender<ILoggingEvent>> appenders = new ArrayList<Appender<ILoggingEvent>>();
            Iterator i = logger.iteratorForAppenders();
            while (i.hasNext()) {
                appenders.add((Appender<ILoggingEvent>)((Appender)i.next()));
            }
            return appenders;
        }

        private static void restoreSettings(Logger logger, List<Appender<ILoggingEvent>> originalAppenders, boolean originalAdditive) {
            List<Appender<ILoggingEvent>> appenders = Factory.listAppenders(logger);
            appenders.forEach(arg_0 -> ((Logger)logger).detachAppender(arg_0));
            originalAppenders.forEach(arg_0 -> ((Logger)logger).addAppender(arg_0));
            logger.setAdditive(originalAdditive);
        }

        private static void logCaptured(Logger logger, Appender<ILoggingEvent> capturingAppender) {
            ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(ILoggingEvent.class);
            ((Appender)Mockito.verify(capturingAppender, (VerificationMode)Mockito.atLeast((int)0))).doAppend((Object)((ILoggingEvent)eventCaptor.capture()));
            List events = eventCaptor.getAllValues();
            events.stream().filter(event -> logger.isEnabledFor(event.getLevel())).forEach(arg_0 -> ((Logger)logger).callAppenders(arg_0));
        }

        private static Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.disableLogging((Logger)logger));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogDisabler disableLogging(Logger logger) {
            Level originalLevel = logger.getLevel();
            logger.setLevel(Level.OFF);
            return () -> logger.setLevel(originalLevel);
        }
    }
}

