/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.logging;

import com.github.robtimus.junit.support.extension.logging.JdkLogResourceFactory;
import com.github.robtimus.junit.support.extension.logging.Log4jLogResourceFactory;
import com.github.robtimus.junit.support.extension.logging.LogResourceFactory;
import com.github.robtimus.junit.support.extension.logging.LogbackLogResourceFactory;
import com.github.robtimus.junit.support.extension.logging.Reload4jLogResourceFactory;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

abstract class LoggingExtension<R>
implements BeforeEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{LoggingExtension.class});
    private static final List<LogResourceFactory> LOG_RESOURCE_FACTORIES = Stream.of(new JdkLogResourceFactory(), new Log4jLogResourceFactory(), new LogbackLogResourceFactory(), new Reload4jLogResourceFactory()).filter(LogResourceFactory::isAvailable).collect(Collectors.toUnmodifiableList());
    private final Predicate<Field> fieldPredicate;
    private final Class<R> resourceType;
    private final ResourceFactory<R> resourceFactory;
    private final MethodHandles.Lookup lookup;

    LoggingExtension(Predicate<Field> fieldPredicate, Class<R> resourceType, ResourceFactory<R> resourceFactory) {
        this.fieldPredicate = fieldPredicate;
        this.resourceType = resourceType;
        this.resourceFactory = resourceFactory;
        this.lookup = MethodHandles.lookup();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        for (Field field : ReflectionSupport.findFields((Class)context.getRequiredTestClass(), this.fieldPredicate, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN)) {
            this.configureLogging(field, context);
        }
    }

    private void configureLogging(Field field, ExtensionContext context) throws ReflectiveOperationException {
        Object logger = this.getLogger(field, context);
        context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)field, k -> this.newResource(logger, context), this.resourceType);
    }

    private Object getLogger(Field field, ExtensionContext context) throws ReflectiveOperationException {
        this.getClass().getModule().addReads(field.getDeclaringClass().getModule());
        if (Modifier.isStatic(field.getModifiers())) {
            return this.getLookup(field, null).findStaticVarHandle(field.getDeclaringClass(), field.getName(), field.getType()).get();
        }
        Object target = context.getRequiredTestInstance();
        return this.getLookup(field, target).findVarHandle(field.getDeclaringClass(), field.getName(), field.getType()).get(target);
    }

    private MethodHandles.Lookup getLookup(Field field, Object target) throws IllegalAccessException {
        return field.canAccess(target) ? this.lookup : MethodHandles.privateLookupIn(field.getDeclaringClass(), this.lookup);
    }

    private R newResource(Object logger, ExtensionContext context) {
        return (R)LOG_RESOURCE_FACTORIES.stream().map(factory -> this.resourceFactory.newResource((LogResourceFactory)factory, logger, context)).filter(Optional::isPresent).map(Optional::orElseThrow).findAny().orElseThrow(() -> this.unsupportedLoggerException(logger));
    }

    private JUnitException unsupportedLoggerException(Object logger) {
        if (logger == null) {
            return new PreconditionViolationException("null not supported");
        }
        return new PreconditionViolationException("Object type not supported: " + logger.getClass().getName());
    }

    static interface ResourceFactory<R> {
        public Optional<R> newResource(LogResourceFactory var1, Object var2, ExtensionContext var3);
    }
}

