/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.logging;

import com.github.robtimus.junit.support.extension.logging.LogResourceFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

final class Reload4jLogResourceFactory
extends LogResourceFactory {
    Reload4jLogResourceFactory() {
    }

    @Override
    Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
        return Factory.startCapture(logger, context);
    }

    @Override
    Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
        return Factory.disableLogging(logger);
    }

    private static final class Factory {
        private Factory() {
        }

        private static Optional<LogResourceFactory.LogCaptor> startCapture(Object logger, ExtensionContext context) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.startCapture((Logger)logger, context));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogCaptor startCapture(Logger logger, ExtensionContext context) {
            List<Appender> originalAppenders = Factory.listAppenders(logger);
            boolean originalAdditivity = logger.getAdditivity();
            logger.removeAllAppenders();
            logger.setAdditivity(false);
            Appender capturingAppender = (Appender)Mockito.mock(Appender.class);
            logger.addAppender(capturingAppender);
            return () -> {
                Factory.restoreSettings(logger, originalAppenders, originalAdditivity);
                context.getExecutionException().ifPresent(t -> Factory.logCaptured(logger, capturingAppender));
            };
        }

        private static List<Appender> listAppenders(Logger logger) {
            ArrayList<Appender> appenders = new ArrayList<Appender>();
            Enumeration e = logger.getAllAppenders();
            while (e.hasMoreElements()) {
                appenders.add((Appender)e.nextElement());
            }
            return appenders;
        }

        private static void restoreSettings(Logger logger, List<Appender> originalAppenders, boolean originalAdditivity) {
            logger.removeAllAppenders();
            originalAppenders.forEach(arg_0 -> ((Logger)logger).addAppender(arg_0));
            logger.setAdditivity(originalAdditivity);
        }

        private static void logCaptured(Logger logger, Appender capturingAppender) {
            ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(LoggingEvent.class);
            ((Appender)Mockito.verify((Object)capturingAppender, (VerificationMode)Mockito.atLeast((int)0))).doAppend((LoggingEvent)eventCaptor.capture());
            List events = eventCaptor.getAllValues();
            events.stream().filter(event -> logger.isEnabledFor((Priority)event.getLevel())).forEach(arg_0 -> ((Logger)logger).callAppenders(arg_0));
        }

        private static Optional<LogResourceFactory.LogDisabler> disableLogging(Object logger) {
            if (logger instanceof Logger) {
                return Optional.of(Factory.disableLogging((Logger)logger));
            }
            return Optional.empty();
        }

        private static LogResourceFactory.LogDisabler disableLogging(Logger logger) {
            Level originalLevel = logger.getLevel();
            logger.setLevel(Level.OFF);
            return () -> logger.setLevel(originalLevel);
        }
    }
}

