/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testlogger;

import com.github.robtimus.junit.support.extension.testlogger.LogCaptor;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContextHelper;
import com.github.robtimus.junit.support.extension.testlogger.TestLoggerExtension;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class JdkLoggerContext
extends LoggerContext {
    private static final String ROOT_LOGGER_NAME = "";
    private final Helper helper;

    private JdkLoggerContext(Logger logger) {
        this.helper = new Helper(logger);
    }

    static JdkLoggerContext forLogger(String name) {
        Logger logger = Logger.getLogger(name);
        return new JdkLoggerContext(logger);
    }

    static JdkLoggerContext forLogger(Class<?> c) {
        return JdkLoggerContext.forLogger(c.getName());
    }

    static JdkLoggerContext forRootLogger() {
        return JdkLoggerContext.forLogger(ROOT_LOGGER_NAME);
    }

    public JdkLoggerContext setLevel(Level level) {
        Objects.requireNonNull(level);
        this.helper.setLevel(level);
        return this;
    }

    public JdkLoggerContext addHandler(Handler handler) {
        Objects.requireNonNull(handler);
        this.helper.addAppender(handler);
        return this;
    }

    public JdkLoggerContext setHandler(Handler handler) {
        Objects.requireNonNull(handler);
        this.helper.setAppender(handler);
        return this;
    }

    public JdkLoggerContext removeHandler(Handler handler) {
        Objects.requireNonNull(handler);
        this.helper.removeAppender(handler);
        return this;
    }

    public JdkLoggerContext removeHandlers() {
        this.helper.removeAppenders();
        return this;
    }

    public JdkLoggerContext removeHandlers(Predicate<? super Handler> filter) {
        Objects.requireNonNull(filter);
        this.helper.removeAppenders(filter);
        return this;
    }

    public JdkLoggerContext useParentHandlers(boolean useParentHandlers) {
        this.helper.useParentAppenders(useParentHandlers);
        return this;
    }

    public LogCaptor<LogRecord> capture() {
        return this.helper.logCaptor();
    }

    Stream<Handler> streamHandlers() {
        return this.helper.streamAppenders();
    }

    @Override
    void saveSettings() {
        this.helper.saveSettings();
    }

    @Override
    public void restore() {
        this.helper.restore();
    }

    static final class Factory
    extends TestLoggerExtension.ContextFactory<JdkLoggerContext> {
        Factory() {
        }

        @Override
        JdkLoggerContext newLoggerContext(String loggerName) {
            return JdkLoggerContext.forLogger(loggerName);
        }

        @Override
        JdkLoggerContext newLoggerContext(Class<?> loggerClass) {
            return JdkLoggerContext.forLogger(loggerClass);
        }

        @Override
        JdkLoggerContext newRootLoggerContext() {
            return JdkLoggerContext.forRootLogger();
        }

        @Override
        String keyPrefix() {
            return JdkLoggerContext.class.getSimpleName();
        }

        @Override
        String loggerName(Class<?> loggerClass) {
            return loggerClass.getName();
        }

        @Override
        String rootLoggerName() {
            return JdkLoggerContext.ROOT_LOGGER_NAME;
        }
    }

    private static final class Helper
    extends LoggerContextHelper<Level, LogRecord, Handler> {
        private final Logger logger;
        private Handler captorHandler;
        private LogCaptor<LogRecord> logCaptor;

        private Helper(Logger logger) {
            this.logger = logger;
        }

        @Override
        Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        void setLevel(Level level) {
            this.logger.setLevel(level);
        }

        @Override
        Iterable<Handler> appenders() {
            return Arrays.asList(this.logger.getHandlers());
        }

        @Override
        void addAppender(Handler handler) {
            this.logger.addHandler(handler);
        }

        @Override
        void removeAppender(Handler handler, boolean force) {
            if (force || this.isNonHelperHandler(handler)) {
                this.logger.removeHandler(handler);
            }
        }

        private boolean isNonHelperHandler(Handler handler) {
            return handler != this.captorHandler;
        }

        @Override
        boolean useParentAppenders() {
            return this.logger.getUseParentHandlers();
        }

        @Override
        void useParentAppenders(boolean useParentHandlers) {
            this.logger.setUseParentHandlers(useParentHandlers);
        }

        @Override
        LogCaptor<LogRecord> logCaptor() {
            if (this.logCaptor == null) {
                this.captorHandler = (Handler)Mockito.mock(Handler.class);
                this.logCaptor = new LogCaptor<LogRecord>(LogRecord.class, (mode, recordCaptor) -> ((Handler)Mockito.verify((Object)this.captorHandler, (VerificationMode)mode)).publish((LogRecord)recordCaptor.capture()), () -> Mockito.reset((Object[])new Handler[]{this.captorHandler}));
                this.addAppender(this.captorHandler);
            }
            return this.logCaptor;
        }
    }
}

