/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testlogger;

import com.github.robtimus.junit.support.extension.testlogger.Log4jNullAppender;
import com.github.robtimus.junit.support.extension.testlogger.LogCaptor;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContextHelper;
import com.github.robtimus.junit.support.extension.testlogger.TestLoggerExtension;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class Log4jLoggerContext
extends LoggerContext {
    private final Helper helper;

    private Log4jLoggerContext(Logger logger) {
        this.helper = new Helper(logger);
    }

    static Log4jLoggerContext forLogger(String name) {
        Logger logger = (Logger)LogManager.getLogger((String)name);
        return new Log4jLoggerContext(logger);
    }

    static Log4jLoggerContext forLogger(Class<?> c) {
        Logger logger = (Logger)LogManager.getLogger(c);
        return new Log4jLoggerContext(logger);
    }

    static Log4jLoggerContext forRootLogger() {
        Logger logger = (Logger)LogManager.getRootLogger();
        return new Log4jLoggerContext(logger);
    }

    static String className(Class<?> c) {
        String canonicalName = c.getCanonicalName();
        return canonicalName != null ? canonicalName : c.getName();
    }

    public Log4jLoggerContext setLevel(Level level) {
        Objects.requireNonNull(level);
        this.helper.setLevel(level);
        return this;
    }

    public Log4jLoggerContext addAppender(Appender appender) {
        Objects.requireNonNull(appender);
        this.helper.addAppender(appender);
        return this;
    }

    public Log4jLoggerContext setAppender(Appender appender) {
        Objects.requireNonNull(appender);
        this.helper.setAppender(appender);
        return this;
    }

    public Log4jLoggerContext removeAppender(Appender appender) {
        Objects.requireNonNull(appender);
        this.helper.removeAppender(appender);
        return this;
    }

    public Log4jLoggerContext removeAppenders() {
        this.helper.removeAppenders();
        return this;
    }

    public Log4jLoggerContext removeAppenders(Predicate<? super Appender> filter) {
        Objects.requireNonNull(filter);
        this.helper.removeAppenders(filter);
        return this;
    }

    public Log4jLoggerContext useParentAppenders(boolean useParentAppenders) {
        this.helper.useParentAppenders(useParentAppenders);
        return this;
    }

    public LogCaptor<LogEvent> capture() {
        return this.helper.logCaptor();
    }

    Stream<Appender> streamAppenders() {
        return this.helper.streamAppenders();
    }

    @Override
    void saveSettings() {
        this.helper.saveSettings();
    }

    @Override
    public void restore() {
        this.helper.restore();
    }

    static final class Factory
    extends TestLoggerExtension.ContextFactory<Log4jLoggerContext> {
        Factory() {
        }

        @Override
        Log4jLoggerContext newLoggerContext(String loggerName) {
            return Log4jLoggerContext.forLogger(loggerName);
        }

        @Override
        Log4jLoggerContext newLoggerContext(Class<?> loggerClass) {
            return Log4jLoggerContext.forLogger(loggerClass);
        }

        @Override
        Log4jLoggerContext newRootLoggerContext() {
            return Log4jLoggerContext.forRootLogger();
        }

        @Override
        String keyPrefix() {
            return Log4jLoggerContext.class.getSimpleName();
        }

        @Override
        String loggerName(Class<?> loggerClass) {
            return Log4jLoggerContext.className(loggerClass);
        }

        @Override
        String rootLoggerName() {
            return "";
        }
    }

    private static final class Helper
    extends LoggerContextHelper<Level, LogEvent, Appender> {
        private final Logger logger;
        private Log4jNullAppender captorAppender;
        private LogCaptor<LogEvent> logCaptor;

        private Helper(Logger logger) {
            this.logger = logger;
        }

        @Override
        Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        void setLevel(Level level) {
            this.logger.setLevel(level);
        }

        @Override
        Iterable<Appender> appenders() {
            return this.logger.getAppenders().values();
        }

        @Override
        void addAppender(Appender appender) {
            this.logger.addAppender(appender);
        }

        @Override
        void removeAppender(Appender appender, boolean force) {
            if (force || this.isNonHelperAppender(appender)) {
                this.logger.removeAppender(appender);
            }
        }

        private boolean isNonHelperAppender(Appender appender) {
            return appender != this.captorAppender;
        }

        @Override
        boolean useParentAppenders() {
            return this.logger.isAdditive();
        }

        @Override
        void useParentAppenders(boolean useParentAppenders) {
            this.logger.setAdditive(useParentAppenders);
        }

        @Override
        LogCaptor<LogEvent> logCaptor() {
            if (this.logCaptor == null) {
                this.captorAppender = (Log4jNullAppender)((Object)Mockito.spy((Object)((Object)Log4jNullAppender.create("LogCaptor-" + UUID.randomUUID().toString()))));
                this.logCaptor = new LogCaptor<LogEvent>(LogEvent.class, (mode, eventCaptor) -> ((Log4jNullAppender)((Object)((Object)Mockito.verify((Object)((Object)this.captorAppender), (VerificationMode)mode)))).ignore((LogEvent)eventCaptor.capture()), () -> Mockito.reset((Object[])new Log4jNullAppender[]{this.captorAppender}));
                this.addAppender((Appender)this.captorAppender);
            }
            return this.logCaptor;
        }

        @Override
        void saveSettings() {
            long originalAppenderCount = super.streamAppenders().count();
            Log4jNullAppender dummyAppender = Log4jNullAppender.create(UUID.randomUUID().toString());
            this.logger.addAppender((Appender)dummyAppender);
            this.logger.removeAppender((Appender)dummyAppender);
            long appenderCount = super.streamAppenders().count();
            if (appenderCount != originalAppenderCount) {
                this.logger.setAdditive(true);
            }
            super.saveSettings();
        }
    }
}

