/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testlogger;

import java.util.List;
import java.util.function.BiConsumer;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class LogCaptor<T> {
    private final Class<T> eventType;
    private final BiConsumer<VerificationMode, ArgumentCaptor<T>> verifier;
    private final Runnable resetter;

    LogCaptor(Class<T> eventType, BiConsumer<VerificationMode, ArgumentCaptor<T>> verifier, Runnable resetter) {
        this.eventType = eventType;
        this.verifier = verifier;
        this.resetter = resetter;
    }

    public List<T> logged() {
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(this.eventType);
        this.verifier.accept(Mockito.atLeast((int)0), eventCaptor);
        return eventCaptor.getAllValues();
    }

    public void reset() {
        this.resetter.run();
    }
}

