/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testlogger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.github.robtimus.junit.support.extension.testlogger.LogCaptor;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContextHelper;
import com.github.robtimus.junit.support.extension.testlogger.TestLoggerExtension;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

public final class LogbackLoggerContext
extends LoggerContext {
    private final Helper helper;

    private LogbackLoggerContext(Logger logger) {
        this.helper = new Helper(logger);
    }

    static LogbackLoggerContext forLogger(String name) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)name);
        return new LogbackLoggerContext(logger);
    }

    static LogbackLoggerContext forLogger(Class<?> c) {
        Logger logger = (Logger)LoggerFactory.getLogger(c);
        return new LogbackLoggerContext(logger);
    }

    static LogbackLoggerContext forRootLogger() {
        return LogbackLoggerContext.forLogger("ROOT");
    }

    public LogbackLoggerContext setLevel(Level level) {
        Objects.requireNonNull(level);
        this.helper.setLevel(level);
        return this;
    }

    public LogbackLoggerContext addAppender(Appender<ILoggingEvent> appender) {
        Objects.requireNonNull(appender);
        this.helper.addAppender(appender);
        return this;
    }

    public LogbackLoggerContext setAppender(Appender<ILoggingEvent> appender) {
        Objects.requireNonNull(appender);
        this.helper.setAppender(appender);
        return this;
    }

    public LogbackLoggerContext removeAppender(Appender<ILoggingEvent> appender) {
        Objects.requireNonNull(appender);
        this.helper.removeAppender(appender);
        return this;
    }

    public LogbackLoggerContext removeAppenders() {
        this.helper.removeAppenders();
        return this;
    }

    public LogbackLoggerContext removeAppenders(Predicate<? super Appender<ILoggingEvent>> filter) {
        Objects.requireNonNull(filter);
        this.helper.removeAppenders(filter);
        return this;
    }

    public LogbackLoggerContext useParentAppenders(boolean useParentAppenders) {
        this.helper.useParentAppenders(useParentAppenders);
        return this;
    }

    public LogCaptor<ILoggingEvent> capture() {
        return this.helper.logCaptor();
    }

    Stream<Appender<ILoggingEvent>> streamAppenders() {
        return this.helper.streamAppenders();
    }

    @Override
    void saveSettings() {
        this.helper.saveSettings();
    }

    @Override
    public void restore() {
        this.helper.restore();
    }

    static final class Factory
    extends TestLoggerExtension.ContextFactory<LogbackLoggerContext> {
        Factory() {
        }

        @Override
        LogbackLoggerContext newLoggerContext(String loggerName) {
            return LogbackLoggerContext.forLogger(loggerName);
        }

        @Override
        LogbackLoggerContext newLoggerContext(Class<?> loggerClass) {
            return LogbackLoggerContext.forLogger(loggerClass);
        }

        @Override
        LogbackLoggerContext newRootLoggerContext() {
            return LogbackLoggerContext.forRootLogger();
        }

        @Override
        String keyPrefix() {
            return LogbackLoggerContext.class.getSimpleName();
        }

        @Override
        String loggerName(Class<?> loggerClass) {
            return loggerClass.getName();
        }

        @Override
        String rootLoggerName() {
            return "ROOT";
        }
    }

    private static final class Helper
    extends LoggerContextHelper<Level, ILoggingEvent, Appender<ILoggingEvent>> {
        private final Logger logger;
        private Appender<ILoggingEvent> captorAppender;
        private LogCaptor<ILoggingEvent> logCaptor;

        private Helper(Logger logger) {
            this.logger = logger;
        }

        @Override
        Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        void setLevel(Level level) {
            this.logger.setLevel(level);
        }

        @Override
        Iterable<Appender<ILoggingEvent>> appenders() {
            return () -> ((Logger)this.logger).iteratorForAppenders();
        }

        @Override
        void addAppender(Appender<ILoggingEvent> appender) {
            this.logger.addAppender(appender);
        }

        @Override
        void removeAppender(Appender<ILoggingEvent> appender, boolean force) {
            if (force || this.isNonHelperAppender(appender)) {
                this.logger.detachAppender(appender);
            }
        }

        private boolean isNonHelperAppender(Appender<ILoggingEvent> appender) {
            return appender != this.captorAppender;
        }

        @Override
        boolean useParentAppenders() {
            return this.logger.isAdditive();
        }

        @Override
        void useParentAppenders(boolean useParentAppenders) {
            this.logger.setAdditive(useParentAppenders);
        }

        @Override
        LogCaptor<ILoggingEvent> logCaptor() {
            if (this.logCaptor == null) {
                this.captorAppender = (Appender)Mockito.mock(Appender.class);
                this.logCaptor = new LogCaptor<ILoggingEvent>(ILoggingEvent.class, (mode, eventCaptor) -> ((Appender)Mockito.verify(this.captorAppender, (VerificationMode)mode)).doAppend((Object)((ILoggingEvent)eventCaptor.capture())), () -> Mockito.reset((Object[])new Appender[]{this.captorAppender}));
                this.addAppender(this.captorAppender);
            }
            return this.logCaptor;
        }
    }
}

