/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testlogger;

import com.github.robtimus.junit.support.extension.testlogger.LogCaptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

abstract class LoggerContextHelper<L, E, A> {
    private L originalLevel;
    private List<A> originalAppenders;
    private boolean originalUseParentAppenders;

    LoggerContextHelper() {
    }

    abstract L getLevel();

    abstract void setLevel(L var1);

    final void addAppenders(List<A> appenders) {
        for (A appender : appenders) {
            this.addAppender(appender);
        }
    }

    final void setAppender(A appender) {
        this.removeAppenders();
        this.addAppender(appender);
    }

    final void removeAppenders() {
        this.removeAppenders(false);
    }

    private void removeAppenders(boolean force) {
        for (A appender : this.appenders()) {
            this.removeAppender(appender, force);
        }
    }

    final void removeAppenders(Predicate<? super A> filter) {
        for (A existingAppender : this.appenders()) {
            if (!filter.test(existingAppender)) continue;
            this.removeAppender(existingAppender, false);
        }
    }

    final Stream<A> streamAppenders() {
        return StreamSupport.stream(this.appenders().spliterator(), false);
    }

    private List<A> listAppenders() {
        ArrayList<A> appenders = new ArrayList<A>();
        for (A appender : this.appenders()) {
            appenders.add(appender);
        }
        return appenders;
    }

    abstract Iterable<A> appenders();

    abstract void addAppender(A var1);

    final void removeAppender(A appender) {
        this.removeAppender(appender, false);
    }

    abstract void removeAppender(A var1, boolean var2);

    abstract boolean useParentAppenders();

    abstract void useParentAppenders(boolean var1);

    abstract LogCaptor<E> logCaptor();

    void saveSettings() {
        this.originalLevel = this.getLevel();
        this.originalAppenders = this.listAppenders();
        this.originalUseParentAppenders = this.useParentAppenders();
    }

    void restore() {
        this.setLevel(this.originalLevel);
        this.removeAppenders(true);
        this.addAppenders(this.originalAppenders);
        this.useParentAppenders(this.originalUseParentAppenders);
    }
}

