/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testlogger;

import com.github.robtimus.junit.support.extension.testlogger.LogCaptor;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContextHelper;
import com.github.robtimus.junit.support.extension.testlogger.TestLoggerExtension;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class Reload4jLoggerContext
extends LoggerContext {
    private final Helper helper;

    private Reload4jLoggerContext(Logger logger) {
        this.helper = new Helper(logger);
    }

    static Reload4jLoggerContext forLogger(String name) {
        Logger logger = Logger.getLogger((String)name);
        return new Reload4jLoggerContext(logger);
    }

    static Reload4jLoggerContext forLogger(Class<?> c) {
        Logger logger = Logger.getLogger(c);
        return new Reload4jLoggerContext(logger);
    }

    static Reload4jLoggerContext forRootLogger() {
        Logger logger = Logger.getRootLogger();
        return new Reload4jLoggerContext(logger);
    }

    public Reload4jLoggerContext setLevel(Level level) {
        Objects.requireNonNull(level);
        this.helper.setLevel(level);
        return this;
    }

    public Reload4jLoggerContext addAppender(Appender appender) {
        Objects.requireNonNull(appender);
        this.helper.addAppender(appender);
        return this;
    }

    public Reload4jLoggerContext setAppender(Appender appender) {
        Objects.requireNonNull(appender);
        this.helper.setAppender(appender);
        return this;
    }

    public Reload4jLoggerContext removeAppender(Appender appender) {
        Objects.requireNonNull(appender);
        this.helper.removeAppender(appender);
        return this;
    }

    public Reload4jLoggerContext removeAppenders() {
        this.helper.removeAppenders();
        return this;
    }

    public Reload4jLoggerContext removeAppenders(Predicate<? super Appender> filter) {
        Objects.requireNonNull(filter);
        this.helper.removeAppenders(filter);
        return this;
    }

    public Reload4jLoggerContext useParentAppenders(boolean useParentAppenders) {
        this.helper.useParentAppenders(useParentAppenders);
        return this;
    }

    public LogCaptor<LoggingEvent> capture() {
        return this.helper.logCaptor();
    }

    Stream<Appender> streamAppenders() {
        return this.helper.streamAppenders();
    }

    @Override
    void saveSettings() {
        this.helper.saveSettings();
    }

    @Override
    public void restore() {
        this.helper.restore();
    }

    static final class Factory
    extends TestLoggerExtension.ContextFactory<Reload4jLoggerContext> {
        private static final String ROOT_LOGGER_NAME = UUID.randomUUID().toString();

        Factory() {
        }

        @Override
        Reload4jLoggerContext newLoggerContext(String loggerName) {
            return Reload4jLoggerContext.forLogger(loggerName);
        }

        @Override
        Reload4jLoggerContext newLoggerContext(Class<?> loggerClass) {
            return Reload4jLoggerContext.forLogger(loggerClass);
        }

        @Override
        Reload4jLoggerContext newRootLoggerContext() {
            return Reload4jLoggerContext.forRootLogger();
        }

        @Override
        String keyPrefix() {
            return Reload4jLoggerContext.class.getSimpleName();
        }

        @Override
        String loggerName(Class<?> loggerClass) {
            return loggerClass.getName();
        }

        @Override
        String rootLoggerName() {
            return ROOT_LOGGER_NAME;
        }
    }

    private static final class Helper
    extends LoggerContextHelper<Level, LoggingEvent, Appender> {
        private final Logger logger;
        private Appender captorAppender;
        private LogCaptor<LoggingEvent> logCaptor;

        private Helper(Logger logger) {
            this.logger = logger;
        }

        @Override
        Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        void setLevel(Level level) {
            this.logger.setLevel(level);
        }

        @Override
        Iterable<Appender> appenders() {
            return () -> this.logger.getAllAppenders().asIterator();
        }

        @Override
        void addAppender(Appender appender) {
            this.logger.addAppender(appender);
        }

        @Override
        void removeAppender(Appender appender, boolean force) {
            if (force || this.isNonHelperAppender(appender)) {
                this.logger.removeAppender(appender);
            }
        }

        private boolean isNonHelperAppender(Appender appender) {
            return appender != this.captorAppender;
        }

        @Override
        boolean useParentAppenders() {
            return this.logger.getAdditivity();
        }

        @Override
        void useParentAppenders(boolean useParentAppenders) {
            this.logger.setAdditivity(useParentAppenders);
        }

        @Override
        LogCaptor<LoggingEvent> logCaptor() {
            if (this.logCaptor == null) {
                this.captorAppender = (Appender)Mockito.mock(Appender.class);
                this.logCaptor = new LogCaptor<LoggingEvent>(LoggingEvent.class, (mode, eventCaptor) -> ((Appender)Mockito.verify((Object)this.captorAppender, (VerificationMode)mode)).doAppend((LoggingEvent)eventCaptor.capture()), () -> Mockito.reset((Object[])new Appender[]{this.captorAppender}));
                this.addAppender(this.captorAppender);
            }
            return this.logCaptor;
        }
    }
}

