/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testlogger;

import com.github.robtimus.junit.support.extension.InjectingExtension;
import com.github.robtimus.junit.support.extension.InjectionTarget;
import com.github.robtimus.junit.support.extension.testlogger.JdkLoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.Log4jLoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.LogbackLoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.LoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.Reload4jLoggerContext;
import com.github.robtimus.junit.support.extension.testlogger.TestLogger;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.AnnotationSupport;

class TestLoggerExtension
extends InjectingExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestLoggerExtension.class});
    private static final Map<Class<? extends LoggerContext>, ContextFactory<?>> CONTEXT_FACTORIES = Map.of(JdkLoggerContext.class, new JdkLoggerContext.Factory(), Log4jLoggerContext.class, new Log4jLoggerContext.Factory(), LogbackLoggerContext.class, new LogbackLoggerContext.Factory(), Reload4jLoggerContext.class, new Reload4jLoggerContext.Factory());

    TestLoggerExtension() {
        super(TestLoggerExtension::hasSupportedAnnotation, MethodHandles.lookup());
    }

    private static boolean hasSupportedAnnotation(Field field) {
        return AnnotationSupport.isAnnotated((AnnotatedElement)field, TestLogger.class) || AnnotationSupport.isAnnotated((AnnotatedElement)field, TestLogger.ForClass.class) || AnnotationSupport.isAnnotated((AnnotatedElement)field, TestLogger.Root.class);
    }

    @Override
    protected Optional<JUnitException> validateTarget(InjectionTarget target, ExtensionContext context) {
        Class<?> targetType = target.type();
        return CONTEXT_FACTORIES.containsKey(targetType) ? Optional.empty() : Optional.of(target.createException("Target type not supported: " + targetType));
    }

    @Override
    protected Object resolveValue(InjectionTarget target, ExtensionContext context) throws Exception {
        Class<?> targetType = target.type();
        ContextFactory<?> contextFactory = CONTEXT_FACTORIES.get(targetType);
        return this.resolveContext(target, contextFactory, context);
    }

    private LoggerContext resolveContext(InjectionTarget target, ContextFactory<?> contextFactory, ExtensionContext context) {
        TestLogger testLogger = target.findAnnotation(TestLogger.class).orElse(null);
        TestLogger.ForClass testLoggerForClass = target.findAnnotation(TestLogger.ForClass.class).orElse(null);
        TestLogger.Root testLoggerRoot = target.findAnnotation(TestLogger.Root.class).orElse(null);
        this.validateAnnotations(testLogger, testLoggerForClass, testLoggerRoot);
        if (testLogger != null) {
            String loggerName = testLogger.value();
            String key = contextFactory.key(loggerName);
            return ((CloseableContext)context.getStore((ExtensionContext.Namespace)TestLoggerExtension.NAMESPACE).getOrComputeIfAbsent((Object)key, (Function<String, CloseableContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$resolveContext$0(com.github.robtimus.junit.support.extension.testlogger.TestLoggerExtension$ContextFactory java.lang.String java.lang.String ), (Ljava/lang/String;)Lcom/github/robtimus/junit/support/extension/testlogger/TestLoggerExtension$CloseableContext;)(contextFactory, (String)loggerName), CloseableContext.class)).context;
        }
        if (testLoggerForClass != null) {
            Class<?> loggerClass = testLoggerForClass.value();
            String key = contextFactory.key(loggerClass);
            return ((CloseableContext)context.getStore((ExtensionContext.Namespace)TestLoggerExtension.NAMESPACE).getOrComputeIfAbsent((Object)key, (Function<String, CloseableContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$resolveContext$1(com.github.robtimus.junit.support.extension.testlogger.TestLoggerExtension$ContextFactory java.lang.Class java.lang.String ), (Ljava/lang/String;)Lcom/github/robtimus/junit/support/extension/testlogger/TestLoggerExtension$CloseableContext;)(contextFactory, loggerClass), CloseableContext.class)).context;
        }
        String key = contextFactory.rootKey();
        return ((CloseableContext)context.getStore((ExtensionContext.Namespace)TestLoggerExtension.NAMESPACE).getOrComputeIfAbsent((Object)key, (Function<String, CloseableContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$resolveContext$2(com.github.robtimus.junit.support.extension.testlogger.TestLoggerExtension$ContextFactory java.lang.String ), (Ljava/lang/String;)Lcom/github/robtimus/junit/support/extension/testlogger/TestLoggerExtension$CloseableContext;)(contextFactory), CloseableContext.class)).context;
    }

    private void validateAnnotations(TestLogger testLogger, TestLogger.ForClass testLoggerForClass, TestLogger.Root testLoggerRoot) {
        long count = Stream.of(testLogger, testLoggerForClass, testLoggerRoot).filter(Objects::nonNull).count();
        if (count != 1L) {
            throw new PreconditionViolationException("Exactly one of @TestLogger, @TestLogger.ForClass and @TestLogger.Root required");
        }
    }

    private static /* synthetic */ CloseableContext lambda$resolveContext$2(ContextFactory contextFactory, String o) {
        return contextFactory.newRootContext();
    }

    private static /* synthetic */ CloseableContext lambda$resolveContext$1(ContextFactory contextFactory, Class loggerClass, String k) {
        return contextFactory.newContext(loggerClass);
    }

    private static /* synthetic */ CloseableContext lambda$resolveContext$0(ContextFactory contextFactory, String loggerName, String k) {
        return contextFactory.newContext(loggerName);
    }

    private static final class CloseableContext
    implements ExtensionContext.Store.CloseableResource {
        private final LoggerContext context;

        private CloseableContext(LoggerContext context) {
            this.context = context;
            context.saveSettings();
        }

        public void close() throws Throwable {
            this.context.restore();
        }
    }

    static abstract class ContextFactory<C extends LoggerContext> {
        ContextFactory() {
        }

        private CloseableContext newContext(String loggerName) {
            C context = this.newLoggerContext(loggerName);
            return new CloseableContext((LoggerContext)context);
        }

        private CloseableContext newContext(Class<?> loggerClass) {
            C context = this.newLoggerContext(loggerClass);
            return new CloseableContext((LoggerContext)context);
        }

        private CloseableContext newRootContext() {
            C context = this.newRootLoggerContext();
            return new CloseableContext((LoggerContext)context);
        }

        abstract C newLoggerContext(String var1);

        abstract C newLoggerContext(Class<?> var1);

        abstract C newRootLoggerContext();

        abstract String keyPrefix();

        abstract String loggerName(Class<?> var1);

        abstract String rootLoggerName();

        private String key(String loggerName) {
            return this.keyPrefix() + "." + loggerName;
        }

        private String key(Class<?> loggerClass) {
            return this.key(this.loggerName(loggerClass));
        }

        private String rootKey() {
            return this.key(this.rootLoggerName());
        }
    }
}

