/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testresource;

import com.github.robtimus.junit.support.extension.AnnotationBasedInjectingExtension;
import com.github.robtimus.junit.support.extension.InjectionTarget;
import com.github.robtimus.junit.support.extension.MethodLookup;
import com.github.robtimus.junit.support.extension.testresource.EOL;
import com.github.robtimus.junit.support.extension.testresource.Encoding;
import com.github.robtimus.junit.support.extension.testresource.LoadWith;
import com.github.robtimus.junit.support.extension.testresource.TestResource;
import com.github.robtimus.junit.support.extension.testresource.TestResourceLoaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.ReflectionSupport;

class TestResourceExtension
extends AnnotationBasedInjectingExtension<TestResource> {
    private static final Map<Class<?>, ResourceConverter> RESOURCE_CONVERTERS = Map.of(String.class, TestResourceExtension::readContentAsString, CharSequence.class, TestResourceExtension::readContentAsCharSequence, StringBuilder.class, TestResourceExtension::readContentAsStringBuilder, byte[].class, (inputStream, target, context) -> TestResourceExtension.readContentAsBytes(inputStream, target));
    private static final Map<String, String> EOL_VALUES = Map.of("LF", "\n", "CR", "\r", "CRLF", "\r\n", "SYSTEM", System.lineSeparator(), "ORIGINAL", "##original##", "NONE", "");
    private static final Map<String, Supplier<String>> ENCODING_LOOKUPS = Map.of("DEFAULT", () -> Charset.defaultCharset().name(), "SYSTEM", TestResourceExtension::lookupSystemEncoding, "NATIVE", TestResourceExtension::lookupNativeEncoding);
    private static final MethodLookup LOAD_AS_LOOKUP = MethodLookup.withParameterTypes(Reader.class, InjectionTarget.class).orParameterTypes(Reader.class, Class.class).orParameterTypes(Reader.class).orParameterTypes(InputStream.class, InjectionTarget.class).orParameterTypes(InputStream.class, Class.class).orParameterTypes(InputStream.class);

    TestResourceExtension() {
        super(TestResource.class, MethodHandles.lookup());
    }

    @Override
    protected Optional<JUnitException> validateTarget(InjectionTarget target, TestResource resource, ExtensionContext context) {
        if (target.isAnnotated(LoadWith.class)) {
            return Optional.empty();
        }
        Class<?> targetType = target.type();
        return RESOURCE_CONVERTERS.containsKey(targetType) ? Optional.empty() : Optional.of(target.createException("Target type not supported: " + targetType));
    }

    @Override
    protected Object resolveValue(InjectionTarget target, TestResource resource, ExtensionContext context) throws IOException {
        LoadWith loadWith = target.findAnnotation(LoadWith.class).orElse(null);
        if (loadWith != null) {
            TestResourceExtension.validateNoEOL(target, "@EOL not allowed in combination with @LoadWith");
            MethodLookup.Result lookupResult = LOAD_AS_LOOKUP.find(loadWith.value(), context);
            switch (lookupResult.index()) {
                case 0: {
                    return this.resolveValueFromReader(resource, lookupResult.method(), target, target, context);
                }
                case 1: {
                    return this.resolveValueFromReader(resource, lookupResult.method(), target, target.type(), context);
                }
                case 2: {
                    return this.resolveValueFromReader(resource, lookupResult.method(), target, null, context);
                }
                case 3: {
                    return this.resolveValueFromInputStream(resource, lookupResult.method(), target, target, context);
                }
                case 4: {
                    return this.resolveValueFromInputStream(resource, lookupResult.method(), target, target.type(), context);
                }
            }
            return this.resolveValueFromInputStream(resource, lookupResult.method(), target, null, context);
        }
        return this.resolveValueFromInputStream(resource, target, context);
    }

    private Object resolveValueFromInputStream(TestResource resource, Method factoryMethod, InjectionTarget target, Object additionalMethodArgument, ExtensionContext context) throws IOException {
        try (InputStream inputStream = target.declaringClass().getResourceAsStream(resource.value());){
            this.validateResource(resource, target, inputStream);
            TestResourceExtension.validateNoEncoding(target, "@Encoding not allowed when using InputStream");
            Object testInstance = context.getTestInstance().orElse(null);
            Object object = factoryMethod.getParameterCount() == 1 ? ReflectionSupport.invokeMethod((Method)factoryMethod, testInstance, (Object[])new Object[]{inputStream}) : ReflectionSupport.invokeMethod((Method)factoryMethod, testInstance, (Object[])new Object[]{inputStream, additionalMethodArgument});
            return object;
        }
    }

    private Object resolveValueFromReader(TestResource resource, Method factoryMethod, InjectionTarget target, Object additionalMethodArgument, ExtensionContext context) throws IOException {
        try (InputStream inputStream = target.declaringClass().getResourceAsStream(resource.value());){
            Object object;
            this.validateResource(resource, target, inputStream);
            String encoding = TestResourceExtension.lookupEncoding(target, context);
            try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);){
                Object testInstance = context.getTestInstance().orElse(null);
                object = factoryMethod.getParameterCount() == 1 ? ReflectionSupport.invokeMethod((Method)factoryMethod, testInstance, (Object[])new Object[]{reader}) : ReflectionSupport.invokeMethod((Method)factoryMethod, testInstance, (Object[])new Object[]{reader, additionalMethodArgument});
            }
            return object;
        }
    }

    private Object resolveValueFromInputStream(TestResource resource, InjectionTarget target, ExtensionContext context) throws IOException {
        Class<?> targetType = target.type();
        try (InputStream inputStream = target.declaringClass().getResourceAsStream(resource.value());){
            this.validateResource(resource, target, inputStream);
            ResourceConverter resourceConverter = RESOURCE_CONVERTERS.get(targetType);
            Object object = resourceConverter.convert(inputStream, target, context);
            return object;
        }
    }

    private void validateResource(TestResource resource, InjectionTarget target, InputStream inputStream) {
        if (inputStream == null) {
            throw target.createException("Resource not found: " + resource.value());
        }
    }

    private static String readContentAsString(InputStream inputStream, InjectionTarget target, ExtensionContext context) throws IOException {
        String lineSeparator = TestResourceExtension.lookupLineSeparator(target, context);
        String encoding = TestResourceExtension.lookupEncoding(target, context);
        try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);){
            String string = "##original##".equals(lineSeparator) ? TestResourceLoaders.toString(reader) : TestResourceLoaders.toString(reader, lineSeparator);
            return string;
        }
    }

    private static CharSequence readContentAsCharSequence(InputStream inputStream, InjectionTarget target, ExtensionContext context) throws IOException {
        String lineSeparator = TestResourceExtension.lookupLineSeparator(target, context);
        String encoding = TestResourceExtension.lookupEncoding(target, context);
        try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);){
            CharSequence charSequence = "##original##".equals(lineSeparator) ? TestResourceLoaders.toCharSequence(reader) : TestResourceLoaders.toCharSequence(reader, lineSeparator);
            return charSequence;
        }
    }

    private static StringBuilder readContentAsStringBuilder(InputStream inputStream, InjectionTarget target, ExtensionContext context) throws IOException {
        String lineSeparator = TestResourceExtension.lookupLineSeparator(target, context);
        String encoding = TestResourceExtension.lookupEncoding(target, context);
        try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);){
            StringBuilder stringBuilder = "##original##".equals(lineSeparator) ? TestResourceLoaders.toStringBuilder(reader) : TestResourceLoaders.toStringBuilder(reader, lineSeparator);
            return stringBuilder;
        }
    }

    private static byte[] readContentAsBytes(InputStream inputStream, InjectionTarget target) throws IOException {
        TestResourceExtension.validateNoEOL(target, "@EOL not allowed for byte[]");
        TestResourceExtension.validateNoEncoding(target, "@Encoding not allowed for byte[]");
        return TestResourceLoaders.toBytes(inputStream);
    }

    static String lookupLineSeparator(InjectionTarget target, ExtensionContext context) {
        EOL eol = target.findAnnotation(EOL.class, true).orElse(null);
        if (eol == null) {
            return TestResourceExtension.lookupDefaultLineSeparator(context);
        }
        return "##system##".equals(eol.value()) ? System.lineSeparator() : eol.value();
    }

    private static String lookupDefaultLineSeparator(ExtensionContext context) {
        String eolParameter = context.getConfigurationParameter("com.github.robtimus.junit.support.extension.testresource.lineSeparator").orElse("ORIGINAL");
        return EOL_VALUES.getOrDefault(eolParameter, eolParameter);
    }

    static String lookupEncoding(InjectionTarget target, ExtensionContext context) {
        String encodingValue;
        Encoding encoding = target.findAnnotation(Encoding.class, true).orElse(null);
        if (encoding == null) {
            return TestResourceExtension.lookupDefaultEncoding(context);
        }
        switch (encodingValue = encoding.value()) {
            case "##default##": {
                return Charset.defaultCharset().name();
            }
            case "##system##": {
                return TestResourceExtension.lookupSystemEncoding();
            }
            case "##native##": {
                return TestResourceExtension.lookupNativeEncoding();
            }
        }
        return encodingValue;
    }

    private static String lookupDefaultEncoding(ExtensionContext context) {
        String encodingParameter = context.getConfigurationParameter("com.github.robtimus.junit.support.extension.testresource.encoding").orElse("UTF-8");
        Supplier<String> encodingLookup = ENCODING_LOOKUPS.get(encodingParameter);
        return encodingLookup != null ? encodingLookup.get() : encodingParameter;
    }

    private static String lookupSystemEncoding() {
        String encoding = System.getProperty("file.encoding");
        if (encoding == null) {
            throw new PreconditionViolationException("System property [file.encoding] not available");
        }
        return encoding;
    }

    private static String lookupNativeEncoding() {
        String encoding = System.getProperty("native.encoding");
        if (encoding == null) {
            throw new PreconditionViolationException("System property [native.encoding] not available");
        }
        return encoding;
    }

    private static void validateNoEOL(InjectionTarget target, String message) {
        EOL eol = target.findAnnotation(EOL.class).orElse(null);
        if (eol != null) {
            throw new PreconditionViolationException(message);
        }
    }

    private static void validateNoEncoding(InjectionTarget target, String message) {
        Encoding encoding = target.findAnnotation(Encoding.class).orElse(null);
        if (encoding != null) {
            throw new PreconditionViolationException(message);
        }
    }

    private static interface ResourceConverter {
        public Object convert(InputStream var1, InjectionTarget var2, ExtensionContext var3) throws IOException;
    }
}

