/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.extension.testresource;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TestResourceLoaders {
    private TestResourceLoaders() {
    }

    public static String toString(Reader reader) throws IOException {
        return TestResourceLoaders.toStringBuilder(reader).toString();
    }

    public static String toString(Reader reader, String lineSeparator) throws IOException {
        Objects.requireNonNull(lineSeparator);
        return TestResourceLoaders.toString(reader).replace("\r\n", "\n").replace("\r", "\n").replace("\n", lineSeparator);
    }

    public static StringBuilder toStringBuilder(Reader reader) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        while ((len = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, len);
        }
        return sb;
    }

    public static StringBuilder toStringBuilder(Reader reader, String lineSeparator) throws IOException {
        return new StringBuilder(TestResourceLoaders.toString(reader, lineSeparator));
    }

    public static CharSequence toCharSequence(Reader reader) throws IOException {
        return TestResourceLoaders.toStringBuilder(reader);
    }

    public static CharSequence toCharSequence(Reader reader, String lineSeparator) throws IOException {
        return TestResourceLoaders.toString(reader, lineSeparator);
    }

    public static byte[] toBytes(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        return outputStream.toByteArray();
    }

    public static List<String> toLines(Reader reader) throws IOException {
        try {
            return TestResourceLoaders.lines(reader).collect(Collectors.toList());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static String[] toLinesArray(Reader reader) throws IOException {
        try {
            return (String[])TestResourceLoaders.lines(reader).toArray(String[]::new);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static Stream<String> lines(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        return bufferedReader.lines();
    }

    public static Properties toProperties(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }
}

