/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.params;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

public final class ArgumentsCombiner {
    private Stream<? extends Arguments> stream;

    private ArgumentsCombiner(Stream<? extends Arguments> stream) {
        this.stream = stream;
    }

    public static ArgumentsCombiner withBooleans(boolean[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = IntStream.range(0, arguments.length).mapToObj(i -> Arguments.arguments((Object[])new Object[]{arguments[i]}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner withChars(char[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = IntStream.range(0, arguments.length).mapToObj(i -> Arguments.arguments((Object[])new Object[]{Character.valueOf(arguments[i])}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner withBytes(byte[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = IntStream.range(0, arguments.length).mapToObj(i -> Arguments.arguments((Object[])new Object[]{arguments[i]}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner withShorts(short[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = IntStream.range(0, arguments.length).mapToObj(i -> Arguments.arguments((Object[])new Object[]{arguments[i]}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner withInts(int[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = Arrays.stream(arguments).mapToObj(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner withLongs(long[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = Arrays.stream(arguments).mapToObj(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner withFloats(float[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = IntStream.range(0, arguments.length).mapToObj(i -> Arguments.arguments((Object[])new Object[]{Float.valueOf(arguments[i])}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner withDoubles(double[] arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = Arrays.stream(arguments).mapToObj(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner with(Object ... arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = Arrays.stream(arguments).map(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner with(Collection<?> arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = arguments.stream().map(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner with(Stream<?> arguments) {
        Objects.requireNonNull(arguments);
        Stream<Arguments> stream = arguments.map(ArgumentsCombiner::asArguments);
        return new ArgumentsCombiner(stream);
    }

    public static ArgumentsCombiner with(ArgumentsProvider argumentsProvider, ExtensionContext context) {
        Objects.requireNonNull(argumentsProvider);
        Objects.requireNonNull(context);
        Stream<? extends Arguments> stream = ArgumentsCombiner.argumentsStream(argumentsProvider, context);
        return new ArgumentsCombiner(stream);
    }

    public ArgumentsCombiner crossJoinBooleans(boolean[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> IntStream.range(0, arguments.length).mapToObj(i -> ArgumentsCombiner.combineArguments(args, (Object)arguments[i])));
        return this;
    }

    public ArgumentsCombiner crossJoinChars(char[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> IntStream.range(0, arguments.length).mapToObj(i -> ArgumentsCombiner.combineArguments(args, (Object)Character.valueOf(arguments[i]))));
        return this;
    }

    public ArgumentsCombiner crossJoinBytes(byte[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> IntStream.range(0, arguments.length).mapToObj(i -> ArgumentsCombiner.combineArguments(args, (Object)arguments[i])));
        return this;
    }

    public ArgumentsCombiner crossJoinShorts(short[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> IntStream.range(0, arguments.length).mapToObj(i -> ArgumentsCombiner.combineArguments(args, (Object)arguments[i])));
        return this;
    }

    public ArgumentsCombiner crossJoinInts(int[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> Arrays.stream(arguments).mapToObj(arg -> ArgumentsCombiner.combineArguments(args, (Object)arg)));
        return this;
    }

    public ArgumentsCombiner crossJoinLongs(long[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> Arrays.stream(arguments).mapToObj(arg -> ArgumentsCombiner.combineArguments(args, (Object)arg)));
        return this;
    }

    public ArgumentsCombiner crossJoinFloats(float[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> IntStream.range(0, arguments.length).mapToObj(i -> ArgumentsCombiner.combineArguments(args, (Object)Float.valueOf(arguments[i]))));
        return this;
    }

    public ArgumentsCombiner crossJoinDoubles(double[] arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> Arrays.stream(arguments).mapToObj(arg -> ArgumentsCombiner.combineArguments(args, (Object)arg)));
        return this;
    }

    public ArgumentsCombiner crossJoin(Object ... arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> Arrays.stream(arguments).map(arg -> ArgumentsCombiner.combineArguments(args, arg)));
        return this;
    }

    public ArgumentsCombiner crossJoin(Collection<?> arguments) {
        Objects.requireNonNull(arguments);
        this.stream = this.stream.flatMap(args -> arguments.stream().map(arg -> ArgumentsCombiner.combineArguments(args, arg)));
        return this;
    }

    public ArgumentsCombiner crossJoin(Supplier<? extends Stream<?>> argumentsProvider) {
        Objects.requireNonNull(argumentsProvider);
        this.stream = this.stream.flatMap(args -> ((Stream)argumentsProvider.get()).map(arg -> ArgumentsCombiner.combineArguments(args, arg)));
        return this;
    }

    public ArgumentsCombiner crossJoin(ArgumentsProvider argumentsProvider, ExtensionContext context) {
        Objects.requireNonNull(argumentsProvider);
        Objects.requireNonNull(context);
        this.stream = this.stream.flatMap(args -> ArgumentsCombiner.argumentsStream(argumentsProvider, context).map(args2 -> ArgumentsCombiner.combineArguments(args, args2)));
        return this;
    }

    public ArgumentsCombiner excludeCombination(Object ... values) {
        Objects.requireNonNull(values);
        Predicate<Object[]> filter = arguments -> {
            if (((Object[])arguments).length != values.length) {
                throw new IllegalStateException(String.format("Incorrect number of values given. Expected %d, was %d: %s", ((Object[])arguments).length, values.length, Arrays.toString(values)));
            }
            return Arrays.equals(values, arguments);
        };
        return this.excludeCombinations(filter);
    }

    public ArgumentsCombiner excludeCombinations(Predicate<? super Object[]> filter) {
        Objects.requireNonNull(filter);
        this.stream = this.stream.filter(arguments -> !filter.test(arguments.get()));
        return this;
    }

    public Stream<? extends Arguments> stream() {
        return this.stream;
    }

    private static Stream<? extends Arguments> argumentsStream(ArgumentsProvider argumentsProvider, ExtensionContext context) {
        try {
            return argumentsProvider.provideArguments(context);
        }
        catch (Exception e) {
            return (Stream)ArgumentsCombiner.throwAsUncheckedException(e);
        }
    }

    private static <T extends Throwable, R> R throwAsUncheckedException(Throwable t) throws T {
        throw t;
    }

    static Arguments asArguments(Object argument) {
        return argument instanceof Arguments ? (Arguments)argument : Arguments.arguments((Object[])new Object[]{argument});
    }

    public static Arguments combineArguments(Object o1, Object o2) {
        if (o1 instanceof Arguments && o2 instanceof Arguments) {
            return ArgumentsCombiner.combineArguments((Arguments)o1, (Arguments)o2);
        }
        if (o1 instanceof Arguments) {
            return ArgumentsCombiner.combineArguments((Arguments)o1, o2);
        }
        if (o2 instanceof Arguments) {
            return ArgumentsCombiner.combineArguments(o1, (Arguments)o2);
        }
        return Arguments.arguments((Object[])new Object[]{o1, o2});
    }

    private static Arguments combineArguments(Arguments arguments1, Arguments arguments2) {
        Object[] args1 = arguments1.get();
        Object[] args2 = arguments2.get();
        Object[] result = new Object[args1.length + args2.length];
        System.arraycopy(args1, 0, result, 0, args1.length);
        System.arraycopy(args2, 0, result, args1.length, args2.length);
        return Arguments.arguments((Object[])result);
    }

    private static Arguments combineArguments(Arguments arguments, Object argument) {
        Object[] args = arguments.get();
        Object[] result = new Object[args.length + 1];
        System.arraycopy(args, 0, result, 0, args.length);
        result[args.length] = argument;
        return Arguments.arguments((Object[])result);
    }

    private static Arguments combineArguments(Object argument, Arguments arguments) {
        Object[] args = arguments.get();
        Object[] result = new Object[args.length + 1];
        result[0] = argument;
        System.arraycopy(args, 0, result, 1, args.length);
        return Arguments.arguments((Object[])result);
    }
}

