/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test;

import com.github.robtimus.junit.support.util.DisplayNameUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;

public interface CovariantReturnTests<T> {
    public Class<T> objectType();

    default public Class<?> covariantReturnType() {
        return this.objectType();
    }

    default public Class<?> baseReturnType() {
        return this.covariantReturnType().getSuperclass();
    }

    default public Stream<Method> methods() {
        Class<T> objectType = this.objectType();
        Class<T> superType = objectType.getSuperclass();
        Class<?> baseReturnType = this.baseReturnType();
        return Arrays.stream(superType.getMethods()).filter(m -> baseReturnType.equals(m.getReturnType()));
    }

    @TestFactory
    @DisplayName(value="covariant return types")
    default public Stream<DynamicContainer> testCovariantReturnTypes() {
        Class objectType = this.objectType();
        Class<?> covariantReturnType = this.covariantReturnType();
        return this.methods().map(m -> {
            String overriddenOrHidden = Modifier.isStatic(m.getModifiers()) ? "hidden" : "overridden";
            try {
                Method override = objectType.getDeclaredMethod(m.getName(), m.getParameterTypes());
                DynamicTest isOverridden = DynamicTest.dynamicTest((String)("is " + overriddenOrHidden), () -> {});
                DynamicTest hasCovariantReturnType = DynamicTest.dynamicTest((String)"has covariant return type", () -> Assertions.assertEquals((Object)covariantReturnType, override.getReturnType()));
                return DynamicContainer.dynamicContainer((String)DisplayNameUtils.getMethodDisplayName(m), Arrays.asList(isOverridden, hasCovariantReturnType));
            }
            catch (NoSuchMethodException e) {
                DynamicTest isOverridden = DynamicTest.dynamicTest((String)("is " + overriddenOrHidden), () -> Assertions.fail((String)("method is not " + overriddenOrHidden)));
                return DynamicContainer.dynamicContainer((String)DisplayNameUtils.getMethodDisplayName(m), Arrays.asList(isOverridden));
            }
        });
    }
}

