/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test;

import com.github.robtimus.junit.support.util.DisplayNameUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.mockito.Mockito;

public interface DelegateTests<T> {
    public Class<T> delegateType();

    public T wrap(T var1);

    public Stream<DelegateMethod<T>> methods();

    @TestFactory
    @DisplayName(value="delegates")
    default public Stream<DynamicTest> testDelegates() {
        Class<T> delegateType = this.delegateType();
        return this.methods().map(m -> m.asDynamicTest(delegateType, this::wrap));
    }

    default public DelegateMethod<T> method(String name) {
        Method method = (Method)Assertions.assertDoesNotThrow(() -> DelegateMethod.getMethod(this.delegateType(), name, new Class[0]));
        String displayName = name + "()";
        int modifiers = method.getModifiers();
        Consumer<Object> action = t -> Assertions.assertDoesNotThrow(() -> method.invoke(t, new Object[0]));
        return new DelegateMethod<Object>(displayName, modifiers, action);
    }

    default public DelegateMethod<T> method(String name, Class<?> ... parameterTypes) {
        Method method = (Method)Assertions.assertDoesNotThrow(() -> DelegateMethod.getMethod(this.delegateType(), name, parameterTypes));
        Object[] args = Arrays.stream(parameterTypes).map(t -> Parameter.DEFAULT_VALUES.getOrDefault(t, null)).toArray();
        int modifiers = method.getModifiers();
        Consumer<Object> action = t -> Assertions.assertDoesNotThrow(() -> method.invoke(t, args));
        return new DelegateMethod<Object>(name, parameterTypes, modifiers, action);
    }

    default public DelegateMethod<T> method(String name, Parameter ... parameters) {
        Class[] parameterTypes = (Class[])Arrays.stream(parameters).map(p -> p.type).toArray(Class[]::new);
        Method method = (Method)Assertions.assertDoesNotThrow(() -> DelegateMethod.getMethod(this.delegateType(), name, parameterTypes));
        Object[] args = Arrays.stream(parameters).map(p -> p.value).toArray();
        int modifiers = method.getModifiers();
        Consumer<Object> action = t -> Assertions.assertDoesNotThrow(() -> method.invoke(t, args));
        return new DelegateMethod<Object>(name, parameterTypes, modifiers, action);
    }

    default public <U> Parameter parameter(U value) {
        return new Parameter(value.getClass(), value);
    }

    default public Parameter parameter(Class<?> type) {
        return new Parameter(type, Parameter.DEFAULT_VALUES.getOrDefault(type, null));
    }

    default public <U> Parameter parameter(Class<U> type, U value) {
        return new Parameter(type, value);
    }

    default public Parameter parameter(boolean value) {
        return new Parameter(Boolean.TYPE, value);
    }

    default public Parameter parameter(char value) {
        return new Parameter(Character.TYPE, Character.valueOf(value));
    }

    default public Parameter parameter(byte value) {
        return new Parameter(Byte.TYPE, value);
    }

    default public Parameter parameter(short value) {
        return new Parameter(Short.TYPE, value);
    }

    default public Parameter parameter(int value) {
        return new Parameter(Integer.TYPE, value);
    }

    default public Parameter parameter(long value) {
        return new Parameter(Long.TYPE, value);
    }

    default public Parameter parameter(float value) {
        return new Parameter(Float.TYPE, Float.valueOf(value));
    }

    default public Parameter parameter(double value) {
        return new Parameter(Double.TYPE, value);
    }

    public static final class Parameter {
        private static final Map<Class<?>, Object> DEFAULT_VALUES = Map.of(Boolean.TYPE, false, Character.TYPE, Character.valueOf('\u0000'), Byte.TYPE, (byte)0, Short.TYPE, (short)0, Integer.TYPE, 0, Long.TYPE, 0L, Float.TYPE, Float.valueOf(0.0f), Double.TYPE, 0.0);
        private final Class<?> type;
        private final Object value;

        private Parameter(Class<?> type, Object value) {
            this.type = Objects.requireNonNull(type);
            this.value = value;
        }
    }

    public static final class DelegateMethod<T> {
        private final String displayName;
        private final int modifiers;
        private final Consumer<T> action;

        private DelegateMethod(String displayName, int modifiers, Consumer<T> action) {
            this.displayName = displayName;
            this.modifiers = modifiers;
            this.action = action;
        }

        private DelegateMethod(String name, Class<?>[] parameterTypes, int modifiers, Consumer<T> action) {
            this.displayName = DisplayNameUtils.getMethodDisplayName(name, parameterTypes);
            this.modifiers = modifiers;
            this.action = action;
        }

        private DynamicTest asDynamicTest(Class<T> delegateType, UnaryOperator<T> wrapper) {
            return DynamicTest.dynamicTest((String)this.displayName, () -> {
                this.validate();
                Object delegate = Mockito.mock((Class)delegateType);
                this.action.accept(wrapper.apply(delegate));
                this.action.accept(Mockito.verify((Object)delegate));
            });
        }

        private void validate() {
            this.validateNotEquals();
            this.validateNotHashCode();
            this.validateModifiers();
        }

        private void validateModifiers() {
            Assertions.assertFalse((Modifier.isPrivate(this.modifiers) || Modifier.isStatic(this.modifiers) || Modifier.isFinal(this.modifiers) ? 1 : 0) != 0, () -> String.format("Method %s: private, static or final not supported", this.displayName));
        }

        private void validateNotEquals() {
            Assertions.assertFalse((boolean)"equals(Object)".equals(this.displayName), (String)"equals(Object) not supported");
        }

        private void validateNotHashCode() {
            Assertions.assertFalse((boolean)"hashCode()".equals(this.displayName), (String)"hashCode() not supported");
        }

        private static Method getMethod(Class<?> type, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
            NoSuchMethodException exception = null;
            try {
                return type.getMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                exception = e;
                for (Class<?> c = type; c != null; c = c.getSuperclass()) {
                    try {
                        return type.getDeclaredMethod(name, parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
                throw exception;
            }
        }
    }
}

