/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

final class CollectionAssertions {
    private CollectionAssertions() {
    }

    static void assertHasElements(Collection<?> collection, Collection<?> expected, boolean fixedOrder) {
        if (expected.isEmpty()) {
            MatcherAssert.assertThat(collection, (Matcher)Matchers.empty());
        } else if (fixedOrder) {
            Assertions.assertEquals(CollectionAssertions.asList(expected), CollectionAssertions.asList(collection));
        } else if (collection instanceof Set && expected instanceof Set) {
            Assertions.assertEquals(expected, collection);
        } else {
            MatcherAssert.assertThat(collection, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
        }
    }

    private static List<?> asList(Collection<?> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList(collection);
    }

    static void assertHasElements(Object[] array, Collection<?> expected, boolean fixedOrder) {
        if (expected.isEmpty()) {
            MatcherAssert.assertThat((Object)array, (Matcher)Matchers.emptyArray());
        } else if (fixedOrder) {
            Assertions.assertArrayEquals((Object[])expected.toArray(), (Object[])array);
        } else {
            MatcherAssert.assertThat((Object)array, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])expected.toArray()));
        }
    }
}

