/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionUtils;
import com.github.robtimus.junit.support.test.collections.IncompatibleObject;
import com.github.robtimus.junit.support.test.collections.IterableTests;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsIncompatibleNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsNullNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.RemoveIncompatibleNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.RemoveNullNotSupported;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public interface CollectionTests<T>
extends IterableTests<T> {
    @Override
    public Collection<T> iterable();

    public Collection<T> nonContainedElements();

    public static final class RetainAllArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            RetainAllTests instance = (RetainAllTests)context.getRequiredTestInstance();
            ArrayList expected = new ArrayList(instance.expectedElements());
            Object nonContained = instance.nonContainedElements().iterator().next();
            ArrayList<Arguments> arguments = new ArrayList<Arguments>();
            for (int i = 0; i <= expected.size(); ++i) {
                arguments.add(Arguments.arguments((Object[])new Object[]{new ArrayList(expected.subList(0, i)), i < expected.size()}));
                ArrayList withNonContained = new ArrayList(expected.subList(0, i));
                withNonContained.add(nonContained);
                arguments.add(Arguments.arguments((Object[])new Object[]{withNonContained, i < expected.size()}));
            }
            return arguments.stream();
        }
    }

    public static final class RemoveAllArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            RemoveAllTests instance = (RemoveAllTests)context.getRequiredTestInstance();
            ArrayList expected = new ArrayList(instance.expectedElements());
            Object nonContained = instance.nonContainedElements().iterator().next();
            ArrayList<Arguments> arguments = new ArrayList<Arguments>();
            for (int i = 0; i <= expected.size(); ++i) {
                arguments.add(Arguments.arguments((Object[])new Object[]{new ArrayList(expected.subList(0, i)), i > 0}));
                ArrayList withNonContained = new ArrayList(expected.subList(0, i));
                withNonContained.add(nonContained);
                arguments.add(Arguments.arguments((Object[])new Object[]{withNonContained, i > 0}));
            }
            return arguments.stream();
        }
    }

    public static final class RemoveArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            RemoveTests instance = (RemoveTests)context.getRequiredTestInstance();
            Stream<Arguments> expected = instance.expectedElements().stream().map(e -> Arguments.arguments((Object[])new Object[]{e, true}));
            Stream<Arguments> notExpected = instance.nonContainedElements().stream().map(e -> Arguments.arguments((Object[])new Object[]{e, false}));
            return Stream.of(expected, notExpected).flatMap(Function.identity());
        }
    }

    @DisplayName(value="clear()")
    public static interface ClearTests<T>
    extends CollectionTests<T> {
        @Test
        @DisplayName(value="clear()")
        default public void testClear() {
            Iterable collection = this.iterable();
            collection.clear();
            CollectionAssertions.assertHasElements(collection, Collections.emptyList(), this.fixedOrder());
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="retainAll(Collection)")
    public static interface RetainAllTests<T>
    extends CollectionTests<T> {
        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=RetainAllArgumentsProvider.class)
        @DisplayName(value="retainAll(Collection)")
        default public void testRetainAll(Collection<?> c, boolean expected) {
            Iterable collection = this.iterable();
            Assertions.assertEquals((Object)expected, (Object)collection.retainAll(c));
            Collection expectedElements = this.expectedElements();
            if (expected) {
                expectedElements = new ArrayList(expectedElements);
                expectedElements.retainAll(c);
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Collection) with a null collection")
        default public void testRetainAllWithNullCollection() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> RetainAllTests.lambda$testRetainAllWithNullCollection$0((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Collection) with a collection with a null")
        default public void testRetainAllWithCollectionWithNull(TestInfo testInfo) {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            ArrayList c = new ArrayList(expectedElements);
            c.add(null);
            ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.retainAll(c));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> RetainAllTests.lambda$testRetainAllWithCollectionWithNull$2((Collection)collection, c));
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Collection) with a collection with an incompatible object")
        default public void testRetainAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            ArrayList c = new ArrayList(expectedElements);
            c.add(new IncompatibleObject());
            ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.retainAll(c));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> RetainAllTests.lambda$testRetainAllWithCollectionWithIncompatibleObject$4((Collection)collection, c));
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRetainAllWithCollectionWithIncompatibleObject$4(Collection collection, Collection c) throws Throwable {
            collection.retainAll(c);
        }

        private static /* synthetic */ void lambda$testRetainAllWithCollectionWithNull$2(Collection collection, Collection c) throws Throwable {
            collection.retainAll(c);
        }

        private static /* synthetic */ void lambda$testRetainAllWithNullCollection$0(Collection collection) throws Throwable {
            collection.retainAll(null);
        }
    }

    @DisplayName(value="removeIf(Predicate)")
    public static interface RemoveIfTests<T>
    extends CollectionTests<T> {
        @Test
        @DisplayName(value="removeIf(Predicate) with matching predicate")
        default public void testRemoveIfWithMatchingPredicate() {
            Iterable collection = this.iterable();
            boolean isEmpty = collection.isEmpty();
            Assertions.assertEquals((Object)(!isEmpty ? 1 : 0), (Object)collection.removeIf(e -> true));
            CollectionAssertions.assertHasElements(collection, Collections.emptyList(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeIf(Predicate) with non-matching predicate")
        default public void testRemoveIfWithNonMatchingPredicate() {
            Iterable collection = this.iterable();
            Assertions.assertFalse((boolean)collection.removeIf(e -> false));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeIf(Predicate) with null predicate")
        default public void testRemoveIfWithNullPredicate() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> RemoveIfTests.lambda$testRemoveIfWithNullPredicate$2((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRemoveIfWithNullPredicate$2(Collection collection) throws Throwable {
            collection.removeIf(null);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="removeAll(Collection)")
    public static interface RemoveAllTests<T>
    extends CollectionTests<T> {
        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=RemoveAllArgumentsProvider.class)
        @DisplayName(value="removeAll(Collection)")
        default public void testRemoveAll(Collection<?> c, boolean expected) {
            Iterable collection = this.iterable();
            Assertions.assertEquals((Object)expected, (Object)collection.removeAll(c));
            Collection expectedElements = this.expectedElements();
            if (expected) {
                expectedElements = new ArrayList(expectedElements);
                expectedElements.removeAll(c);
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Collection) with a null collection")
        default public void testRemoveAllWithNullCollection() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> RemoveAllTests.lambda$testRemoveAllWithNullCollection$0((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Collection) with a collection with a null")
        default public void testRemoveAllWithCollectionWithNull(TestInfo testInfo) {
            Iterable collection = this.iterable();
            Set<Object> c = Collections.singleton(null);
            RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.removeAll(c));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> RemoveAllTests.lambda$testRemoveAllWithCollectionWithNull$2((Collection)collection, c));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Collection) with a collection with an incompatible object")
        default public void testRemoveAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
            Iterable collection = this.iterable();
            Set<IncompatibleObject> c = Collections.singleton(new IncompatibleObject());
            RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.removeAll(c));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> RemoveAllTests.lambda$testRemoveAllWithCollectionWithIncompatibleObject$4((Collection)collection, c));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRemoveAllWithCollectionWithIncompatibleObject$4(Collection collection, Collection c) throws Throwable {
            collection.removeAll(c);
        }

        private static /* synthetic */ void lambda$testRemoveAllWithCollectionWithNull$2(Collection collection, Collection c) throws Throwable {
            collection.removeAll(c);
        }

        private static /* synthetic */ void lambda$testRemoveAllWithNullCollection$0(Collection collection) throws Throwable {
            collection.removeAll(null);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="containsAll(Collection)")
    public static interface ContainsAllTests<T>
    extends CollectionTests<T> {
        @Test
        @DisplayName(value="containsAll(Collection)")
        default public void testContainsAll() {
            Iterable collection = this.iterable();
            ArrayList expected = new ArrayList(this.expectedElements());
            Object nonContained = this.nonContainedElements().iterator().next();
            for (int i = 0; i <= expected.size(); ++i) {
                Assertions.assertTrue((boolean)collection.containsAll(expected.subList(0, i)));
                ArrayList withNonContained = new ArrayList(expected.subList(0, i));
                withNonContained.add(nonContained);
                Assertions.assertFalse((boolean)collection.containsAll(withNonContained));
            }
        }

        @Test
        @DisplayName(value="containsAll(Collection) with a null collection")
        default public void testContainsAllWithNullCollection() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> ContainsAllTests.lambda$testContainsAllWithNullCollection$0((Collection)collection));
        }

        @Test
        @DisplayName(value="containsAll(Collection) with a collection with a null")
        default public void testContainsAllWithCollectionWithNull(TestInfo testInfo) {
            Iterable collection = this.iterable();
            ArrayList c = new ArrayList(this.expectedElements());
            c.add(null);
            ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.containsAll(c));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> ContainsAllTests.lambda$testContainsAllWithCollectionWithNull$2((Collection)collection, c));
            }
        }

        @Test
        @DisplayName(value="containsAll(Collection) with a collection with an incompatible object")
        default public void testContainsAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
            Iterable collection = this.iterable();
            ArrayList c = new ArrayList(this.expectedElements());
            c.add(new IncompatibleObject());
            ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.containsAll(c));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> ContainsAllTests.lambda$testContainsAllWithCollectionWithIncompatibleObject$4((Collection)collection, c));
            }
        }

        private static /* synthetic */ void lambda$testContainsAllWithCollectionWithIncompatibleObject$4(Collection collection, Collection c) throws Throwable {
            collection.containsAll(c);
        }

        private static /* synthetic */ void lambda$testContainsAllWithCollectionWithNull$2(Collection collection, Collection c) throws Throwable {
            collection.containsAll(c);
        }

        private static /* synthetic */ void lambda$testContainsAllWithNullCollection$0(Collection collection) throws Throwable {
            collection.containsAll(null);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="remove(Object)")
    public static interface RemoveTests<T>
    extends CollectionTests<T> {
        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=RemoveArgumentsProvider.class)
        @DisplayName(value="remove(Object)")
        default public void testRemove(Object o, boolean expected) {
            Iterable collection = this.iterable();
            Assertions.assertEquals((Object)expected, (Object)collection.remove(o));
            Collection expectedElements = this.expectedElements();
            if (expected) {
                expectedElements = new ArrayList(expectedElements);
                expectedElements.remove(o);
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove(Object) with null")
        default public void testRemoveNull(TestInfo testInfo) {
            Iterable collection = this.iterable();
            RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.remove(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> RemoveTests.lambda$testRemoveNull$1((Collection)collection));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove(Object) with incompatible object")
        default public void testRemoveIncompatibleObject(TestInfo testInfo) {
            Iterable collection = this.iterable();
            RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.remove(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> RemoveTests.lambda$testRemoveIncompatibleObject$3((Collection)collection));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRemoveIncompatibleObject$3(Collection collection) throws Throwable {
            collection.remove(new IncompatibleObject());
        }

        private static /* synthetic */ void lambda$testRemoveNull$1(Collection collection) throws Throwable {
            collection.remove(null);
        }
    }

    @DisplayName(value="toArray(IntFunction)")
    public static interface ToArrayWithGeneratorTests<T>
    extends CollectionTests<T> {
        @Test
        @DisplayName(value="toArray(IntFunction)")
        default public void testToArrayWithGenerator() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            Class<?> genericType = CollectionUtils.commonType(expectedElements);
            IntFunction<T[]> generator = length -> (Object[])Array.newInstance(genericType, length);
            Object[] array = collection.toArray(generator);
            CollectionAssertions.assertHasElements(array, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="toArray(IntFunction) with null generator")
        default public void testToArrayWithNullGenerator() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> ToArrayWithGeneratorTests.lambda$testToArrayWithNullGenerator$1((Collection)collection));
        }

        private static /* synthetic */ void lambda$testToArrayWithNullGenerator$1(Collection collection) throws Throwable {
            collection.toArray((IntFunction<T[]>)null);
        }
    }

    @DisplayName(value="toArray(Object[])")
    public static interface ToArrayTests<T>
    extends CollectionTests<T> {
        @Test
        @DisplayName(value="toArray(Object[]) with same length")
        default public void testToArrayWithSameLength() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            Class<?> genericType = CollectionUtils.commonType(expectedElements);
            Object[] a = (Object[])Array.newInstance(genericType, collection.size());
            Object[] array = collection.toArray(a);
            Assertions.assertSame((Object)a, (Object)array);
            CollectionAssertions.assertHasElements(array, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="toArray(Object[]) with larger length")
        default public void testToArrayWithLargerLength() {
            Iterable collection = this.iterable();
            Object[] a = new Object[collection.size() + 2];
            IncompatibleObject o = new IncompatibleObject();
            Arrays.fill(a, o);
            Object[] array = collection.toArray(a);
            Assertions.assertSame((Object)a, (Object)array);
            CollectionAssertions.assertHasElements(Arrays.copyOfRange(array, 0, collection.size()), this.expectedElements(), this.fixedOrder());
            CollectionAssertions.assertHasElements(Arrays.copyOfRange(array, collection.size(), a.length), Arrays.asList(null, o), true);
        }

        @Test
        @DisplayName(value="toArray(Object[]) with smaller length")
        default public void testToArrayWithSmallerLength() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            Class<?> genericType = CollectionUtils.commonType(expectedElements);
            Object[] a = (Object[])Array.newInstance(genericType, 0);
            Object[] array = collection.toArray(a);
            Assertions.assertNotSame((Object)a, (Object)array);
            Assertions.assertInstanceOf(a.getClass(), (Object)array);
            CollectionAssertions.assertHasElements(array, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="toArray(Object[]) with null array")
        default public void testToArrayWithNullArray() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> ToArrayTests.lambda$testToArrayWithNullArray$0((Collection)collection));
        }

        private static /* synthetic */ void lambda$testToArrayWithNullArray$0(Collection collection) throws Throwable {
            collection.toArray((Object[])null);
        }
    }

    @DisplayName(value="toArray()")
    public static interface ToObjectArrayTests<T>
    extends CollectionTests<T> {
        @Test
        @DisplayName(value="toArray()")
        default public void testToObjectArray() {
            Iterable collection = this.iterable();
            Object[] array = collection.toArray();
            CollectionAssertions.assertHasElements(array, this.expectedElements(), this.fixedOrder());
        }
    }

    @DisplayName(value="contains(Object)")
    public static interface ContainsTests<T>
    extends CollectionTests<T> {
        @Test
        @DisplayName(value="contains(Object)")
        default public void testContains() {
            Iterable collection = this.iterable();
            for (Object o : this.expectedElements()) {
                Assertions.assertTrue((boolean)collection.contains(o));
            }
            for (Object o : this.nonContainedElements()) {
                Assertions.assertFalse((boolean)collection.contains(o));
            }
        }

        @Test
        @DisplayName(value="contains(Object) with null")
        default public void testContainsWithNull(TestInfo testInfo) {
            Iterable collection = this.iterable();
            ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.contains(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> ContainsTests.lambda$testContainsWithNull$1((Collection)collection));
            }
        }

        @Test
        @DisplayName(value="contains(Object) with an incompatible object")
        default public void testContainsWithIncompatibleObject(TestInfo testInfo) {
            Iterable collection = this.iterable();
            ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)collection.contains(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> ContainsTests.lambda$testContainsWithIncompatibleObject$3((Collection)collection));
            }
        }

        private static /* synthetic */ void lambda$testContainsWithIncompatibleObject$3(Collection collection) throws Throwable {
            collection.contains(new IncompatibleObject());
        }

        private static /* synthetic */ void lambda$testContainsWithNull$1(Collection collection) throws Throwable {
            collection.contains(null);
        }
    }
}

