/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class CollectionUtils {
    private CollectionUtils() {
    }

    static <T> List<T> toList(Iterable<T> iterable) {
        return CollectionUtils.toList(iterable.iterator());
    }

    static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            T element = iterator.next();
            result.add(element);
        }
        return result;
    }

    static Class<?> commonType(Collection<?> collection) {
        if (collection.isEmpty()) {
            return String.class;
        }
        Iterator<?> iterator = collection.iterator();
        Class<?> common = iterator.next().getClass();
        while (common != Object.class && iterator.hasNext()) {
            common = CollectionUtils.commonType(common, iterator.next().getClass());
        }
        if (common != Object.class && Modifier.isPublic(common.getModifiers())) {
            return common;
        }
        iterator = collection.iterator();
        Set<Class<Class<?>>> commonInterfaces = CollectionUtils.collectAllInterfaces(iterator.next().getClass());
        while (!commonInterfaces.isEmpty() && iterator.hasNext()) {
            commonInterfaces.retainAll(CollectionUtils.collectAllInterfaces(iterator.next().getClass()));
        }
        HashSet publicCommonInterfaces = new HashSet(commonInterfaces);
        publicCommonInterfaces.removeIf(i -> !Modifier.isPublic(i.getModifiers()));
        if (!publicCommonInterfaces.isEmpty()) {
            return (Class)publicCommonInterfaces.iterator().next();
        }
        return commonInterfaces.isEmpty() ? common : commonInterfaces.iterator().next();
    }

    private static Class<?> commonType(Class<?> c1, Class<?> c2) {
        if (c1.isAssignableFrom(c2)) {
            return c1;
        }
        if (c2.isAssignableFrom(c1)) {
            return c2;
        }
        return CollectionUtils.commonType(c1.getSuperclass(), c2.getSuperclass());
    }

    private static Set<Class<?>> collectAllInterfaces(Class<?> c) {
        HashSet allInterfaces = new HashSet();
        while (c != null) {
            Collections.addAll(allInterfaces, c.getInterfaces());
            c = c.getSuperclass();
        }
        return allInterfaces;
    }
}

