/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface EnumerationTests<T> {
    public Enumeration<T> enumeration();

    public Collection<T> expectedElements();

    public boolean fixedOrder();

    @DisplayName(value="asIterator()")
    public static interface AsIteratorTests<T>
    extends EnumerationTests<T> {
        @Test
        @DisplayName(value="asIterator()")
        default public void testAsIterator() {
            Enumeration enumeration = this.enumeration();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            Iterator iterator = enumeration.asIterator();
            while (iterator.hasNext()) {
                Assertions.assertTrue((boolean)enumeration.hasMoreElements());
                Object element = iterator.next();
                elements.add(element);
            }
            Assertions.assertFalse((boolean)enumeration.hasMoreElements());
            Assertions.assertThrows(NoSuchElementException.class, iterator::next);
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="next() without hasNext()")
        default public void testNextWithoutHasNext() {
            Enumeration enumeration = this.enumeration();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            Iterator iterator = enumeration.asIterator();
            for (int i = 0; i < expectedElements.size(); ++i) {
                Object element = iterator.next();
                elements.add(element);
            }
            Assertions.assertThrows(NoSuchElementException.class, iterator::next);
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }
    }

    @DisplayName(value="iteration")
    public static interface IterationTests<T>
    extends EnumerationTests<T> {
        @Test
        @DisplayName(value="iteration")
        default public void testIteration() {
            Enumeration enumeration = this.enumeration();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            while (enumeration.hasMoreElements()) {
                Assertions.assertTrue((boolean)enumeration.hasMoreElements());
                Object element = enumeration.nextElement();
                elements.add(element);
            }
            Assertions.assertThrows(NoSuchElementException.class, enumeration::nextElement);
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="nextElement() without hasMoreElements()")
        default public void testNextElementWithoutHasMoreElements() {
            Enumeration enumeration = this.enumeration();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            for (int i = 0; i < expectedElements.size(); ++i) {
                Object element = enumeration.nextElement();
                elements.add(element);
            }
            Assertions.assertThrows(NoSuchElementException.class, enumeration::nextElement);
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }
    }
}

