/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface IterableTests<T> {
    public Iterable<T> iterable();

    public Collection<T> expectedElements();

    public boolean fixedOrder();

    @DisplayName(value="forEach(Consumer)")
    public static interface ForEachTests<T>
    extends IterableTests<T> {
        @Test
        @DisplayName(value="forEach(Consumer)")
        default public void testForEach() {
            Iterable<Object> iterable = this.iterable();
            ArrayList elements = new ArrayList();
            iterable.forEach(elements::add);
            CollectionAssertions.assertHasElements(elements, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="forEach(Consumer) with null consumer")
        default public void testForEachWithNullConsumer() {
            Iterable iterable = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> iterable.forEach(null));
        }
    }
}

