/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface IteratorTests<T> {
    public Iterable<T> iterable();

    public Collection<T> expectedElements();

    public boolean fixedOrder();

    @DisplayName(value="forEachRemaining(Consumer)")
    public static interface ForEachRemainingTests<T>
    extends IteratorTests<T> {
        default public boolean hasFailFastNullCheck() {
            return true;
        }

        @Test
        @DisplayName(value="forEachRemaining(Consumer)")
        default public void testForEachRemaining() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            int skip = 2;
            while (skip > 0 && iterator.hasNext()) {
                Object element = iterator.next();
                expectedElements.remove(element);
            }
            ArrayList remaining = new ArrayList();
            iterator.forEachRemaining(remaining::add);
            CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="forEachRemaining(Consumer) with null consumer")
        default public void testForEachRemainingWithNullConsumer() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            boolean hasFailFastNullCheck = this.hasFailFastNullCheck();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            Assertions.assertThrows(NullPointerException.class, () -> iterator.forEachRemaining(null));
            while (iterator.hasNext()) {
                Object element = iterator.next();
                elements.add(element);
                if (!iterator.hasNext() && !hasFailFastNullCheck) continue;
                Assertions.assertThrows(NullPointerException.class, () -> iterator.forEachRemaining(null));
            }
            if (!hasFailFastNullCheck) {
                expectedElements = new ArrayList();
                boolean skip = true;
                for (Object element : iterable) {
                    if (!skip) {
                        expectedElements.add(element);
                    }
                    skip = !skip;
                }
            }
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }
    }

    @DisplayName(value="remove()")
    public static interface RemoveTests<T>
    extends IteratorTests<T> {
        @Test
        @DisplayName(value="remove() for every element")
        default public void testRemoveEveryElement() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            List remaining = CollectionUtils.toList(iterable);
            CollectionAssertions.assertHasElements(remaining, Collections.emptyList(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove() for every even-indexed element")
        default public void testRemoveEveryEvenIndexedElement() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            boolean remove = true;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (remove) {
                    expectedElements.remove(element);
                    iterator.remove();
                }
                remove = !remove;
            }
            List remaining = CollectionUtils.toList(iterable);
            CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove() before next()")
        default public void testRemoveBeforeNext() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            Assertions.assertThrows(IllegalStateException.class, iterator::remove);
            List remaining = CollectionUtils.toList(iterable);
            CollectionAssertions.assertHasElements(remaining, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove() after remove()")
        default public void testRemoveAfterRemove() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            boolean remove = true;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (remove) {
                    expectedElements.remove(element);
                    iterator.remove();
                    Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                }
                remove = !remove;
            }
            List remaining = CollectionUtils.toList(iterable);
            CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
        }
    }

    @DisplayName(value="iteration")
    public static interface IterationTests<T>
    extends IteratorTests<T> {
        @Test
        @DisplayName(value="iteration")
        default public void testIteration() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            while (iterator.hasNext()) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Object element = iterator.next();
                elements.add(element);
            }
            Assertions.assertThrows(NoSuchElementException.class, iterator::next);
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="next() without hasNext()")
        default public void testNextWithoutHasNext() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            for (int i = 0; i < expectedElements.size(); ++i) {
                Object element = iterator.next();
                elements.add(element);
            }
            Assertions.assertThrows(NoSuchElementException.class, iterator::next);
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }
    }
}

