/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.IteratorTests;
import com.github.robtimus.junit.support.test.collections.annotation.StoreNullNotSupported;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public interface ListIteratorTests<T>
extends IteratorTests<T> {
    @Override
    public List<T> iterable();

    @Override
    public List<T> expectedElements();

    @Override
    default public boolean fixedOrder() {
        return true;
    }

    @DisplayName(value="add(Object)")
    public static interface AddTests<T>
    extends ListIteratorTests<T> {
        public T newElement();

        @Test
        @DisplayName(value="add(Object) using next()")
        default public void testAddUsingNext() {
            Iterable list = this.iterable();
            ListIterator<T> iterator = list.listIterator();
            T newElement = this.newElement();
            iterator.add(newElement);
            while (iterator.hasNext()) {
                iterator.next();
                iterator.add(newElement);
            }
            ArrayList<T> expectedElements = new ArrayList<T>(this.expectedElements());
            for (int i = expectedElements.size(); i >= 0; --i) {
                expectedElements.add(i, newElement);
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="add(Object) with null using next()")
        default public void testAddNullUsingNext(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            if (annotation == null) {
                iterator.add(null);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> iterator.add(null));
            }
            while (iterator.hasNext()) {
                iterator.next();
                if (annotation == null) {
                    iterator.add(null);
                    continue;
                }
                Assertions.assertThrows(annotation.expected(), () -> iterator.add(null));
            }
            if (annotation == null) {
                ArrayList expectedElements = new ArrayList(this.expectedElements());
                for (int i = expectedElements.size(); i >= 0; --i) {
                    expectedElements.add(i, null);
                }
                Assertions.assertEquals(expectedElements, (Object)list);
            } else {
                Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
            }
        }

        @Test
        @DisplayName(value="add(Object) using previous()")
        default public void testAddUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator<T> iterator = list.listIterator(list.size());
            T newElement = this.newElement();
            iterator.add(newElement);
            Assertions.assertTrue((boolean)iterator.hasPrevious());
            Assertions.assertEquals(newElement, iterator.previous());
            while (iterator.hasPrevious()) {
                iterator.previous();
                iterator.add(newElement);
                Assertions.assertTrue((boolean)iterator.hasPrevious());
                Assertions.assertEquals(newElement, iterator.previous());
            }
            ArrayList<T> expectedElements = new ArrayList<T>(this.expectedElements());
            for (int i = expectedElements.size(); i >= 0; --i) {
                expectedElements.add(i, newElement);
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="add(Object) with null using previous()")
        default public void testAddNullUsingPrevious(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            if (annotation == null) {
                iterator.add(null);
                Assertions.assertTrue((boolean)iterator.hasPrevious());
                Assertions.assertNull(iterator.previous());
            } else {
                Assertions.assertThrows(annotation.expected(), () -> iterator.add(null));
            }
            while (iterator.hasPrevious()) {
                iterator.previous();
                if (annotation == null) {
                    iterator.add(null);
                    Assertions.assertTrue((boolean)iterator.hasPrevious());
                    Assertions.assertNull(iterator.previous());
                    continue;
                }
                Assertions.assertThrows(annotation.expected(), () -> iterator.add(null));
            }
            if (annotation == null) {
                ArrayList expectedElements = new ArrayList(this.expectedElements());
                for (int i = expectedElements.size(); i >= 0; --i) {
                    expectedElements.add(i, null);
                }
                Assertions.assertEquals(expectedElements, (Object)list);
            } else {
                Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
            }
        }
    }

    @DisplayName(value="set(Object)")
    public static interface SetTests<T>
    extends ListIteratorTests<T> {
        public UnaryOperator<T> replaceElementOperator();

        default public T singleElement() {
            Collection expectedElements = this.expectedElements();
            return (T)expectedElements.get(expectedElements.size() / 2);
        }

        @Test
        @DisplayName(value="set(Object) using next()")
        default public void testSetUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            UnaryOperator operator = this.replaceElementOperator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                iterator.set(operator.apply(element));
            }
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            expectedElements.replaceAll(operator);
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) with null replacement using next()")
        default public void testSetWithNullReplacementUsingNext(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            while (iterator.hasNext()) {
                iterator.next();
                if (annotation == null) {
                    iterator.set(null);
                    continue;
                }
                Assertions.assertThrows(annotation.expected(), () -> iterator.set(null));
            }
            if (annotation == null) {
                ArrayList expectedElements = new ArrayList(this.expectedElements());
                Collections.fill(expectedElements, null);
                Assertions.assertEquals(expectedElements, (Object)list);
            } else {
                Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
            }
        }

        @Test
        @DisplayName(value="set(Object) before next()")
        default public void testSetBeforeNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            Object element = this.singleElement();
            Assertions.assertThrows(IllegalStateException.class, () -> iterator.set(element));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) after set(Object) using next()")
        default public void testSetAfterSetUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            UnaryOperator<Object> operator = this.replaceElementOperator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                iterator.set(operator.apply(element));
                iterator.set(operator.apply(operator.apply(element)));
            }
            ArrayList<Object> expectedElements = new ArrayList<Object>(this.expectedElements());
            expectedElements.replaceAll(operator);
            expectedElements.replaceAll(operator);
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) using previous()")
        default public void testSetUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            UnaryOperator operator = this.replaceElementOperator();
            while (iterator.hasPrevious()) {
                Object element = iterator.previous();
                iterator.set(operator.apply(element));
            }
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            expectedElements.replaceAll(operator);
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) with null replacement using previous()")
        default public void testSetWithNullReplacementUsingPrevious(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            while (iterator.hasPrevious()) {
                iterator.previous();
                if (annotation == null) {
                    iterator.set(null);
                    continue;
                }
                Assertions.assertThrows(annotation.expected(), () -> iterator.set(null));
            }
            if (annotation == null) {
                ArrayList expectedElements = new ArrayList(this.expectedElements());
                Collections.fill(expectedElements, null);
                Assertions.assertEquals(expectedElements, (Object)list);
            } else {
                Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
            }
        }

        @Test
        @DisplayName(value="set(Object) before previous()")
        default public void testSetBeforePrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            Object element = this.singleElement();
            Assertions.assertThrows(IllegalStateException.class, () -> iterator.set(element));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) after set(Object) using previous()")
        default public void testSetAfterSetUsingPrevous() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            UnaryOperator<Object> operator = this.replaceElementOperator();
            while (iterator.hasPrevious()) {
                Object element = iterator.previous();
                iterator.set(operator.apply(element));
                iterator.set(operator.apply(operator.apply(element)));
            }
            ArrayList<Object> expectedElements = new ArrayList<Object>(this.expectedElements());
            expectedElements.replaceAll(operator);
            expectedElements.replaceAll(operator);
            Assertions.assertEquals(expectedElements, (Object)list);
        }
    }

    @DisplayName(value="remove()")
    public static interface RemoveTests<T>
    extends ListIteratorTests<T> {
        @Test
        @DisplayName(value="remove() for every element using next()")
        default public void testRemoveEveryElementUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            Assertions.assertEquals(Collections.emptyList(), (Object)list);
        }

        @Test
        @DisplayName(value="remove() for every even-indexed element using next()")
        default public void testRemoveEveryEvenIndexedElementUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            boolean remove = true;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (remove) {
                    expectedElements.remove(element);
                    iterator.remove();
                }
                remove = !remove;
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="remove() before next()")
        default public void testRemoveBeforeNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            Assertions.assertThrows(IllegalStateException.class, iterator::remove);
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove() after remove() using next()")
        default public void testRemoveAfterRemoveUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            boolean remove = true;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (remove) {
                    expectedElements.remove(element);
                    iterator.remove();
                    Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                }
                remove = !remove;
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="remove() for every element using previous()")
        default public void testRemoveEveryElementUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            while (iterator.hasPrevious()) {
                iterator.previous();
                iterator.remove();
            }
            Assertions.assertEquals(Collections.emptyList(), (Object)list);
        }

        @Test
        @DisplayName(value="remove() for every even-indexed element using previous()")
        default public void testRemoveEveryEvenIndexedElementUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            boolean remove = true;
            while (iterator.hasPrevious()) {
                Object element = iterator.previous();
                if (remove) {
                    expectedElements.remove(element);
                    iterator.remove();
                }
                remove = !remove;
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="remove() before previous()")
        default public void testRemoveBeforePrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            Assertions.assertThrows(IllegalStateException.class, iterator::remove);
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove() after remove() using previous()")
        default public void testRemoveAfterRemoveUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            boolean remove = true;
            while (iterator.hasPrevious()) {
                Object element = iterator.previous();
                if (remove) {
                    expectedElements.remove(element);
                    iterator.remove();
                    Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                }
                remove = !remove;
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }
    }

    @DisplayName(value="iteration")
    public static interface IterationTests<T>
    extends ListIteratorTests<T> {
        @Test
        @DisplayName(value="iteration using next()")
        default public void testIterationUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            int index = 0;
            while (iterator.hasNext()) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertEquals((int)index, (int)iterator.nextIndex());
                Object element = iterator.next();
                elements.add(element);
                ++index;
            }
            Assertions.assertThrows(NoSuchElementException.class, iterator::next);
            Assertions.assertEquals((int)index, (int)iterator.nextIndex());
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="iteration using previous()")
        default public void testIterationUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            int index = list.size() - 1;
            while (iterator.hasPrevious()) {
                Assertions.assertTrue((boolean)iterator.hasPrevious());
                Assertions.assertEquals((int)index, (int)iterator.previousIndex());
                Object element = iterator.previous();
                elements.add(0, element);
                --index;
            }
            Assertions.assertThrows(NoSuchElementException.class, iterator::previous);
            Assertions.assertEquals((int)index, (int)iterator.previousIndex());
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="next() without hasNext()")
        default public void testNextWithoutHasNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            for (int i = 0; i < expectedElements.size(); ++i) {
                Object element = iterator.next();
                elements.add(element);
            }
            Assertions.assertThrows(NoSuchElementException.class, iterator::next);
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="previous() without hasPrevious()")
        default public void testPreviousWithoutHasPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            for (int i = 0; i < expectedElements.size(); ++i) {
                Object element = iterator.previous();
                elements.add(0, element);
            }
            Assertions.assertThrows(NoSuchElementException.class, iterator::previous);
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }
    }
}

