/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionTests;
import com.github.robtimus.junit.support.test.collections.IncompatibleObject;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsIncompatibleNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsNullNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.StoreNullNotSupported;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public interface ListTests<T>
extends CollectionTests<T> {
    @Override
    public List<T> iterable();

    @Override
    public List<T> expectedElements();

    @Override
    default public boolean fixedOrder() {
        return true;
    }

    public static final class EqualsArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            EqualsTests instance = (EqualsTests)context.getRequiredTestInstance();
            ArrayList expected = new ArrayList(instance.expectedElements());
            Object nonContained = instance.nonContainedElements().iterator().next();
            ArrayList<Arguments> arguments = new ArrayList<Arguments>();
            arguments.add(Arguments.arguments((Object[])new Object[]{new ArrayList(expected), true}));
            if (!expected.isEmpty()) {
                arguments.add(Arguments.arguments((Object[])new Object[]{new ArrayList(expected.subList(0, expected.size() - 1)), false}));
            }
            ArrayList withNonContained = new ArrayList(expected);
            withNonContained.add(nonContained);
            arguments.add(Arguments.arguments((Object[])new Object[]{withNonContained, false}));
            return arguments.stream();
        }
    }

    @DisplayName(value="spliterator()")
    public static interface SpliteratorTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="spliterator() has ORDERED characteristic")
        default public void testSpliteratorHasOrderedCharacteristic() {
            Collection list = this.iterable();
            Spliterator spliterator = list.spliterator();
            Assertions.assertTrue((boolean)spliterator.hasCharacteristics(16));
        }

        @Test
        @DisplayName(value="spliterator() has SIZED characteristic")
        default public void testSpliteratorHasSizedCharacteristic() {
            Collection list = this.iterable();
            Spliterator spliterator = list.spliterator();
            Assertions.assertTrue((boolean)spliterator.hasCharacteristics(64));
        }
    }

    @DisplayName(value="subList(int, int)")
    public static interface SubListTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="subList(int, int) with full range")
        default public void testSubListWithFullRange() {
            Collection list = this.iterable();
            List subList = list.subList(0, list.size());
            Assertions.assertEquals((Object)this.expectedElements(), subList);
        }

        @Test
        @DisplayName(value="subList(int, int) with partial range")
        default public void testSubListWithPartialRange() {
            Collection list = this.iterable();
            List subList = list.subList(1, list.size() - 1);
            Assertions.assertEquals(this.expectedElements().subList(1, list.size() - 1), subList);
        }

        @Test
        @DisplayName(value="subList(int, int) with negative from")
        default public void testSubListWithNegativeFrom() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SubListTests.lambda$testSubListWithNegativeFrom$0((List)list));
        }

        @Test
        @DisplayName(value="subList(int, int) with to larger than size")
        default public void testSubListWithToLargerThanSize() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SubListTests.lambda$testSubListWithToLargerThanSize$1((List)list));
        }

        @Test
        @DisplayName(value="subList(int, int) with to smaller than from")
        default public void testSubListWithToSmallerThanFrom() {
            Collection list = this.iterable();
            int from = list.size() / 2;
            int to = from - 1;
            ThrowableAssertions.assertThrowsOneOf(IndexOutOfBoundsException.class, IllegalArgumentException.class, () -> SubListTests.lambda$testSubListWithToSmallerThanFrom$2((List)list, from, to));
        }

        private static /* synthetic */ void lambda$testSubListWithToSmallerThanFrom$2(List list, int from, int to) throws Throwable {
            list.subList(from, to);
        }

        private static /* synthetic */ void lambda$testSubListWithToLargerThanSize$1(List list) throws Throwable {
            list.subList(0, list.size() + 1);
        }

        private static /* synthetic */ void lambda$testSubListWithNegativeFrom$0(List list) throws Throwable {
            list.subList(-1, list.size());
        }
    }

    @DisplayName(value="listIterator(int)")
    public static interface ListIteratorIndexedTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="listIterator(int) with index 0")
        default public void testListIteratorIndexedWithIndexZero() {
            Collection list = this.iterable();
            ListIterator iterator = list.listIterator(0);
            Assertions.assertFalse((boolean)iterator.hasPrevious());
            ArrayList elements = new ArrayList(list.size());
            while (iterator.hasNext()) {
                Object element = iterator.next();
                elements.add(element);
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="listIterator(int) with index equal to size")
        default public void testListIteratorIndexedWithIndexEqualToSize() {
            Collection list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            Assertions.assertFalse((boolean)iterator.hasNext());
            ArrayList elements = new ArrayList(list.size());
            while (iterator.hasPrevious()) {
                Object element = iterator.previous();
                elements.add(element);
            }
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            Collections.reverse(expectedElements);
            Assertions.assertEquals(expectedElements, elements);
        }

        @Test
        @DisplayName(value="listIterator(int) with index equal to size / 2")
        default public void testListIteratorIndexedWithIndexEqualToSizeDivTwo() {
            Collection list = this.iterable();
            ListIterator iterator = list.listIterator(list.size() / 2);
            Assertions.assertTrue((boolean)iterator.hasPrevious());
            ArrayList elements = new ArrayList(list.size());
            while (iterator.hasNext()) {
                Object element = iterator.next();
                elements.add(element);
            }
            Assertions.assertEquals(this.expectedElements().subList(list.size() / 2, list.size()), elements);
        }

        @Test
        @DisplayName(value="listIterator(int) with negative index")
        default public void testListIteratorIndexedWithNegativeIndex() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ListIteratorIndexedTests.lambda$testListIteratorIndexedWithNegativeIndex$0((List)list));
        }

        @Test
        @DisplayName(value="listIterator(int) with index larger than size")
        default public void testListIteratorIndexedWithIndexLargerThanSize() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ListIteratorIndexedTests.lambda$testListIteratorIndexedWithIndexLargerThanSize$1((List)list));
        }

        private static /* synthetic */ void lambda$testListIteratorIndexedWithIndexLargerThanSize$1(List list) throws Throwable {
            list.listIterator(list.size() + 1);
        }

        private static /* synthetic */ void lambda$testListIteratorIndexedWithNegativeIndex$0(List list) throws Throwable {
            list.listIterator(-1);
        }
    }

    @DisplayName(value="lastIndexOf(Object)")
    public static interface LastIndexOfTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="lastIndexOf(Object)")
        default public void testLastIndexOf() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object o : expectedElements) {
                Assertions.assertEquals((int)expectedElements.lastIndexOf(o), (int)list.lastIndexOf(o));
            }
            for (Object o : this.nonContainedElements()) {
                Assertions.assertEquals((int)-1, (int)list.lastIndexOf(o));
            }
        }

        @Test
        @DisplayName(value="lastIndexOf(Object) with null")
        default public void testLastIndexOfWithNull(TestInfo testInfo) {
            Collection list = this.iterable();
            ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertEquals((int)-1, (int)list.lastIndexOf(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> LastIndexOfTests.lambda$testLastIndexOfWithNull$1((List)list));
            }
        }

        @Test
        @DisplayName(value="lastIndexOf(Object) with an incompatible object")
        default public void testLastIndexOfWithIncompatibleObject(TestInfo testInfo) {
            Collection list = this.iterable();
            ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertEquals((int)-1, (int)list.lastIndexOf(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> LastIndexOfTests.lambda$testLastIndexOfWithIncompatibleObject$3((List)list));
            }
        }

        private static /* synthetic */ void lambda$testLastIndexOfWithIncompatibleObject$3(List list) throws Throwable {
            list.lastIndexOf(new IncompatibleObject());
        }

        private static /* synthetic */ void lambda$testLastIndexOfWithNull$1(List list) throws Throwable {
            list.lastIndexOf(null);
        }
    }

    @DisplayName(value="indexOf(Object)")
    public static interface IndexOfTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="indexOf(Object)")
        default public void testIndexOf() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object o : expectedElements) {
                Assertions.assertEquals((int)expectedElements.indexOf(o), (int)list.indexOf(o));
            }
            for (Object o : this.nonContainedElements()) {
                Assertions.assertEquals((int)-1, (int)list.indexOf(o));
            }
        }

        @Test
        @DisplayName(value="indexOf(Object) with null")
        default public void testIndexOfWithNull(TestInfo testInfo) {
            Collection list = this.iterable();
            ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertEquals((int)-1, (int)list.indexOf(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> IndexOfTests.lambda$testIndexOfWithNull$1((List)list));
            }
        }

        @Test
        @DisplayName(value="indexOf(Object) with an incompatible object")
        default public void testIndexOfWithIncompatibleObject(TestInfo testInfo) {
            Collection list = this.iterable();
            ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertEquals((int)-1, (int)list.indexOf(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> IndexOfTests.lambda$testIndexOfWithIncompatibleObject$3((List)list));
            }
        }

        private static /* synthetic */ void lambda$testIndexOfWithIncompatibleObject$3(List list) throws Throwable {
            list.indexOf(new IncompatibleObject());
        }

        private static /* synthetic */ void lambda$testIndexOfWithNull$1(List list) throws Throwable {
            list.indexOf(null);
        }
    }

    @DisplayName(value="remove(int)")
    public static interface RemoveIndexedTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="remove(int) with every index")
        default public void testRemoveIndexedWithEveryIndex() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (int i = list.size() - 1; i >= 0; --i) {
                Object removed = list.remove(i);
                Assertions.assertEquals(expectedElements.get(i), removed);
            }
            Assertions.assertEquals(Collections.emptyList(), (Object)list);
        }

        @Test
        @DisplayName(value="remove(int) with even indexes")
        default public void testRemoveIndexedWithEvenIndexes() {
            Collection list = this.iterable();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            int start = expectedElements.size() - 1;
            if (start % 2 == 1) {
                --start;
            }
            for (int i = start; i >= 0; i -= 2) {
                Object removed = list.remove(i);
                Assertions.assertEquals(expectedElements.get(i), removed);
                expectedElements.remove(i);
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="remove(int) with negative index")
        default public void testRemoveIndexedWithNegativeIndex() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> RemoveIndexedTests.lambda$testRemoveIndexedWithNegativeIndex$0((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove(int) with index equal to size")
        default public void testRemoveIndexedWithIndexEqualToSize() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> RemoveIndexedTests.lambda$testRemoveIndexedWithIndexEqualToSize$1((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testRemoveIndexedWithIndexEqualToSize$1(List list) throws Throwable {
            list.remove(list.size());
        }

        private static /* synthetic */ void lambda$testRemoveIndexedWithNegativeIndex$0(List list) throws Throwable {
            list.remove(-1);
        }
    }

    @DisplayName(value="addAll(int, Collection)")
    public static interface AddAllIndexedTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="addAll(int, Collection) with index 0")
        default public void testAddAllIndexedWithIndexZero() {
            Collection list = this.iterable();
            Collection nonContainedElements = this.nonContainedElements();
            Assertions.assertTrue((boolean)list.addAll(0, nonContainedElements));
            Collection expectedElements = this.expectedElements();
            Assertions.assertTrue((boolean)list.addAll(0, expectedElements));
            ArrayList expected = new ArrayList(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(expectedElements);
            expected.addAll(nonContainedElements);
            expected.addAll(expectedElements);
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with index equal to size")
        default public void testAddAllIndexedWithIndexEqualToSize() {
            Collection list = this.iterable();
            Collection nonContainedElements = this.nonContainedElements();
            Assertions.assertEquals((Object)(!nonContainedElements.isEmpty() ? 1 : 0), (Object)list.addAll(list.size(), nonContainedElements));
            Collection expectedElements = this.expectedElements();
            Assertions.assertEquals((Object)(!expectedElements.isEmpty() ? 1 : 0), (Object)list.addAll(list.size(), expectedElements));
            ArrayList expected = new ArrayList(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(expectedElements);
            expected.addAll(nonContainedElements);
            expected.addAll(expectedElements);
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with index equal to size / 2")
        default public void testAddAllIndexedWithIndexEqualToSizeDivTwo() {
            Collection list = this.iterable();
            int index = list.size() / 2;
            Collection expectedElements = this.expectedElements();
            Assertions.assertTrue((boolean)list.addAll(index, expectedElements));
            Collection nonContainedElements = this.nonContainedElements();
            Assertions.assertTrue((boolean)list.addAll(index, nonContainedElements));
            ArrayList<Object> expected = new ArrayList<Object>(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(nonContainedElements);
            expected.addAll(expectedElements);
            expected.addAll(0, expectedElements.subList(0, index));
            expected.addAll(expectedElements.subList(index, expectedElements.size()));
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with an empty collection")
        default public void testAddAllIndexedWithEmptyCollection() {
            Collection list = this.iterable();
            Assertions.assertFalse((boolean)list.addAll(0, Collections.emptyList()));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with a null collection")
        default public void testAddAllIndexedWithNullCollection() {
            Collection list = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithNullCollection$0((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with a collection with a null")
        default public void testAddAllIndexedWithCollectionWithNull(TestInfo testInfo) {
            Collection list = this.iterable();
            Set<Object> c = Collections.singleton(null);
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            ArrayList<Object> expectedElements = this.expectedElements();
            if (annotation == null) {
                Assertions.assertTrue((boolean)list.addAll(0, c));
                expectedElements = new ArrayList<Object>(expectedElements);
                expectedElements.addAll(0, c);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> AddAllIndexedTests.lambda$testAddAllIndexedWithCollectionWithNull$2((List)list, c));
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with negative index")
        default public void testAddAllIndexedWithNegativeIndex() {
            Collection list = this.iterable();
            Set c = Collections.singleton(this.nonContainedElements().iterator().next());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithNegativeIndex$3((List)list, c));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with index larger than size")
        default public void testAddAllIndexedWithIndexLargerThanSize() {
            Collection list = this.iterable();
            Set c = Collections.singleton(this.nonContainedElements().iterator().next());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithIndexLargerThanSize$4((List)list, c));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithIndexLargerThanSize$4(List list, Collection c) throws Throwable {
            list.addAll(list.size() + 1, c);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithNegativeIndex$3(List list, Collection c) throws Throwable {
            list.addAll(-1, c);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithCollectionWithNull$2(List list, Collection c) throws Throwable {
            list.addAll(0, c);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithNullCollection$0(List list) throws Throwable {
            list.addAll(0, null);
        }
    }

    @DisplayName(value="add(int, Object)")
    public static interface AddIndexedTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="add(int, Object) with index 0")
        default public void testAddIndexedWithIndexZero() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object object : expectedElements) {
                list.add(0, object);
            }
            Collection nonContainedElements = this.nonContainedElements();
            for (Object object : nonContainedElements) {
                list.add(0, object);
            }
            ArrayList expected = new ArrayList(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(expectedElements);
            expected.addAll(nonContainedElements);
            Collections.reverse(expected);
            expected.addAll(expectedElements);
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with index equal to size")
        default public void testAddIndexedWithIndexEqualToSize() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object object : expectedElements) {
                list.add(list.size(), object);
            }
            Collection nonContainedElements = this.nonContainedElements();
            for (Object object : nonContainedElements) {
                list.add(list.size(), object);
            }
            ArrayList expected = new ArrayList(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(expectedElements);
            expected.addAll(expectedElements);
            expected.addAll(nonContainedElements);
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with index equal to size / 2")
        default public void testAddIndexedWithIndexEqualToSizeDivTwo() {
            Collection list = this.iterable();
            int index = list.size() / 2;
            Collection expectedElements = this.expectedElements();
            for (Object object : expectedElements) {
                list.add(index, object);
            }
            Collection nonContainedElements = this.nonContainedElements();
            for (Object object : nonContainedElements) {
                list.add(index, object);
            }
            ArrayList<Object> expected = new ArrayList<Object>(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(expectedElements);
            expected.addAll(nonContainedElements);
            Collections.reverse(expected);
            expected.addAll(0, expectedElements.subList(0, index));
            expected.addAll(expectedElements.subList(index, expectedElements.size()));
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with null")
        default public void testAddIndexedWithNull(TestInfo testInfo) {
            Collection list = this.iterable();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            ArrayList<Object> expectedElements = this.expectedElements();
            if (annotation == null) {
                list.add(0, null);
                expectedElements = new ArrayList<Object>(expectedElements);
                expectedElements.add(0, null);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> AddIndexedTests.lambda$testAddIndexedWithNull$1((List)list));
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with negative index")
        default public void testAddIndexedWithNegativeIndex() {
            Collection list = this.iterable();
            Object object = this.nonContainedElements().iterator().next();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AddIndexedTests.lambda$testAddIndexedWithNegativeIndex$2((List)list, object));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with index larger than size")
        default public void testAddIndexedWithIndexLargerThanSize() {
            Collection list = this.iterable();
            Object object = this.nonContainedElements().iterator().next();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AddIndexedTests.lambda$testAddIndexedWithIndexLargerThanSize$3((List)list, object));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testAddIndexedWithIndexLargerThanSize$3(List list, Object object) throws Throwable {
            list.set(list.size() + 1, object);
        }

        private static /* synthetic */ void lambda$testAddIndexedWithNegativeIndex$2(List list, Object object) throws Throwable {
            list.add(-1, object);
        }

        private static /* synthetic */ void lambda$testAddIndexedWithNull$1(List list) throws Throwable {
            list.add(0, null);
        }
    }

    @DisplayName(value="set(int, Object)")
    public static interface SetTests<T>
    extends ListTests<T> {
        public UnaryOperator<T> replaceElementOperator();

        @Test
        @DisplayName(value="set(int, Object)")
        default public void testSet() {
            Collection list = this.iterable();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            UnaryOperator operator = this.replaceElementOperator();
            ListIterator i = expectedElements.listIterator();
            while (i.hasNext()) {
                int index = i.nextIndex();
                Object element = i.next();
                Assertions.assertEquals(element, list.set(index, operator.apply(element)));
            }
            expectedElements.replaceAll(operator);
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="set(int, Object) with null replacement")
        default public void testSetWithNullReplacement(TestInfo testInfo) {
            Collection list = this.iterable();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            ArrayList expectedElements = this.expectedElements();
            ListIterator i = expectedElements.listIterator();
            while (i.hasNext()) {
                int index = i.nextIndex();
                i.next();
                if (annotation == null) {
                    list.set(index, null);
                    continue;
                }
                Assertions.assertThrows(annotation.expected(), () -> SetTests.lambda$testSetWithNullReplacement$1((List)list, index));
            }
            if (annotation == null) {
                expectedElements = new ArrayList(expectedElements);
                Collections.fill(expectedElements, null);
                Assertions.assertEquals(expectedElements, (Object)list);
            } else {
                Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
            }
        }

        @Test
        @DisplayName(value="set(int, Object) with negative index")
        default public void testSetWithNegativeIndex() {
            Collection list = this.iterable();
            Object object = this.nonContainedElements().iterator().next();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SetTests.lambda$testSetWithNegativeIndex$2((List)list, object));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(int, Object) with index equal to size")
        default public void testSetWithIndexEqualToSize() {
            Collection list = this.iterable();
            Object object = this.nonContainedElements().iterator().next();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SetTests.lambda$testSetWithIndexEqualToSize$3((List)list, object));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testSetWithIndexEqualToSize$3(List list, Object object) throws Throwable {
            list.set(list.size(), object);
        }

        private static /* synthetic */ void lambda$testSetWithNegativeIndex$2(List list, Object object) throws Throwable {
            list.set(-1, object);
        }

        private static /* synthetic */ void lambda$testSetWithNullReplacement$1(List list, int index) throws Throwable {
            list.set(index, null);
        }
    }

    @DisplayName(value="get(int)")
    public static interface GetTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="get(int)")
        default public void testGet() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            ListIterator i = expectedElements.listIterator();
            while (i.hasNext()) {
                int index = i.nextIndex();
                Object element = i.next();
                Assertions.assertEquals(element, list.get(index));
            }
        }

        @Test
        @DisplayName(value="get(int) with negative index")
        default public void testGetWithNegativeIndex() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> GetTests.lambda$testGetWithNegativeIndex$0((List)list));
        }

        @Test
        @DisplayName(value="get(int) with index equal to size")
        default public void testGetWithIndexEqualToSize() {
            Collection list = this.iterable();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> GetTests.lambda$testGetWithIndexEqualToSize$1((List)list));
        }

        private static /* synthetic */ void lambda$testGetWithIndexEqualToSize$1(List list) throws Throwable {
            list.get(list.size());
        }

        private static /* synthetic */ void lambda$testGetWithNegativeIndex$0(List list) throws Throwable {
            list.get(-1);
        }
    }

    @DisplayName(value="hashCode()")
    public static interface HashCodeTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="hashCode()")
        default public void testHashCode() {
            Collection list = this.iterable();
            int expected = this.expectedElements().stream().mapToInt(Object::hashCode).reduce(1, (x, y) -> 31 * x + y);
            Assertions.assertEquals((int)expected, (int)list.hashCode());
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="equals(Object)")
    public static interface EqualsTests<T>
    extends ListTests<T> {
        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=EqualsArgumentsProvider.class)
        @DisplayName(value="equals(Object)")
        default public void testEquals(List<?> other, boolean expected) {
            Collection list = this.iterable();
            if (expected) {
                Assertions.assertEquals(other, (Object)list);
            } else {
                Assertions.assertNotEquals(other, (Object)list);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with self")
        default public void testEqualsSelf() {
            Collection list = this.iterable();
            Assertions.assertEquals((Object)list, (Object)list);
        }

        @Test
        @DisplayName(value="equals(Object) with null")
        default public void testEqualsNull() {
            Collection list = this.iterable();
            Assertions.assertNotEquals(null, (Object)list);
        }

        @Test
        @DisplayName(value="equals(Object) with set")
        default public void testEqualsSet() {
            Collection list = this.iterable();
            Assertions.assertNotEquals(new HashSet(list), (Object)list);
        }
    }

    @DisplayName(value="replaceAll(UnaryOperator)")
    public static interface ReplaceAllTests<T>
    extends ListTests<T> {
        public UnaryOperator<T> replaceElementOperator();

        @Test
        @DisplayName(value="replaceAll(UnaryOperator)")
        default public void testReplaceAll() {
            Collection list = this.iterable();
            UnaryOperator<T> operator = this.replaceElementOperator();
            list.replaceAll(operator);
            ArrayList<T> expectedElements = new ArrayList<T>(this.expectedElements());
            expectedElements.replaceAll(operator);
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="replaceAll(UnaryOperator) with null operator")
        default public void testReplaceAllWithNullOperator() {
            Collection list = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> ReplaceAllTests.lambda$testReplaceAllWithNullOperator$0((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testReplaceAllWithNullOperator$0(List list) throws Throwable {
            list.replaceAll(null);
        }
    }

    @DisplayName(value="addAll(Collection)")
    public static interface AddAllTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="addAll(Collection)")
        default public void testAddAll() {
            Collection list = this.iterable();
            Collection nonContainedElements = this.nonContainedElements();
            Assertions.assertTrue((boolean)list.addAll(nonContainedElements));
            Collection expectedElements = this.expectedElements();
            Assertions.assertTrue((boolean)list.addAll(expectedElements));
            ArrayList expected = new ArrayList(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(expectedElements);
            expected.addAll(nonContainedElements);
            expected.addAll(expectedElements);
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="addAll(Collection) with an empty collection")
        default public void testAddAllWithEmptyCollection() {
            Collection list = this.iterable();
            Assertions.assertFalse((boolean)list.addAll(Collections.emptyList()));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(Collection) with a null collection")
        default public void testAddAllWithNullCollection() {
            Collection list = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> AddAllTests.lambda$testAddAllWithNullCollection$0((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(Collection) with a collection with a null")
        default public void testAddAllWithCollectionWithNull(TestInfo testInfo) {
            Collection list = this.iterable();
            Set<Object> c = Collections.singleton(null);
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            ArrayList<Object> expectedElements = this.expectedElements();
            if (annotation == null) {
                Assertions.assertTrue((boolean)list.addAll(c));
                expectedElements = new ArrayList<Object>(expectedElements);
                expectedElements.addAll(c);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> AddAllTests.lambda$testAddAllWithCollectionWithNull$2((List)list, c));
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        private static /* synthetic */ void lambda$testAddAllWithCollectionWithNull$2(List list, Collection c) throws Throwable {
            list.addAll(c);
        }

        private static /* synthetic */ void lambda$testAddAllWithNullCollection$0(List list) throws Throwable {
            list.addAll(null);
        }
    }

    @DisplayName(value="add(Object)")
    public static interface AddTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="add(Object)")
        default public void testAdd() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object object : expectedElements) {
                Assertions.assertTrue((boolean)list.add(object));
            }
            Collection nonContainedElements = this.nonContainedElements();
            for (Object object : nonContainedElements) {
                Assertions.assertTrue((boolean)list.add(object));
            }
            ArrayList expected = new ArrayList(expectedElements.size() * 2 + nonContainedElements.size());
            expected.addAll(expectedElements);
            expected.addAll(expectedElements);
            expected.addAll(nonContainedElements);
            Assertions.assertEquals(expected, (Object)list);
        }

        @Test
        @DisplayName(value="add(Object) with null")
        default public void testAddNull(TestInfo testInfo) {
            Collection list = this.iterable();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            ArrayList<Object> expectedElements = this.expectedElements();
            if (annotation == null) {
                Assertions.assertTrue((boolean)list.add(null));
                expectedElements = new ArrayList<Object>(expectedElements);
                expectedElements.add(null);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> AddTests.lambda$testAddNull$1((List)list));
            }
            Assertions.assertEquals(expectedElements, (Object)list);
        }

        private static /* synthetic */ void lambda$testAddNull$1(List list) throws Throwable {
            list.add(null);
        }
    }
}

