/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.MapTests;
import com.github.robtimus.junit.support.test.collections.annotation.StoreNullNotSupported;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public interface MapEntryTests<K, V>
extends MapTests<K, V> {

    @DisplayName(value="equals(Object)")
    public static interface HashCodeTests<K, V>
    extends MapEntryTests<K, V> {
        @Test
        @DisplayName(value="hashCode()")
        default public void testHashCode() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                int expected = (key != null ? key.hashCode() : 0) ^ (value != null ? value.hashCode() : 0);
                Assertions.assertEquals((int)expected, (int)entry.hashCode());
            }
        }
    }

    @DisplayName(value="equals(Object)")
    public static interface EqualsTests<K, V>
    extends MapEntryTests<K, V> {
        @Test
        @DisplayName(value="equals(Object)")
        default public void testEquals() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                AbstractMap.SimpleEntry other = new AbstractMap.SimpleEntry(entry);
                Assertions.assertEquals(other, entry);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with self")
        default public void testEqualsSelf() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                Assertions.assertEquals(entry, entry);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with other key")
        default public void testEqualsWithOtherKey() {
            Map map = this.map();
            Object otherKey = this.nonContainedEntries().keySet().iterator().next();
            for (Map.Entry entry : map.entrySet()) {
                AbstractMap.SimpleEntry other = new AbstractMap.SimpleEntry(otherKey, entry.getValue());
                Assertions.assertNotEquals(other, entry);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with other value")
        default public void testEqualsWithOtherValue() {
            Map map = this.map();
            Object otherValue = this.nonContainedEntries().values().iterator().next();
            for (Map.Entry entry : map.entrySet()) {
                AbstractMap.SimpleEntry other = new AbstractMap.SimpleEntry(entry.getKey(), otherValue);
                Assertions.assertNotEquals(other, entry);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with null key")
        default public void testEqualsWithNullKey() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                AbstractMap.SimpleEntry other = new AbstractMap.SimpleEntry(null, entry.getValue());
                Assertions.assertNotEquals(other, entry);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with null value")
        default public void testEqualsWithNullValue() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                AbstractMap.SimpleEntry other = new AbstractMap.SimpleEntry(entry.getKey(), null);
                Assertions.assertNotEquals(other, entry);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with null")
        default public void testEqualsNull() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                Assertions.assertNotEquals(null, entry);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with incompatible object")
        default public void testEqualsIncompatibleObject() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                Assertions.assertNotEquals((Object)1, entry);
            }
        }
    }

    @DisplayName(value="setValue(Object)")
    public static interface SetValueTests<K, V>
    extends MapEntryTests<K, V> {
        public UnaryOperator<V> replaceValueOperator();

        @Test
        @DisplayName(value="setValue(Object)")
        default public void testSetValue() {
            Map map = this.map();
            HashMap<Object, Object> expectedEntries = new HashMap<Object, Object>(this.expectedEntries());
            UnaryOperator<V> operator = this.replaceValueOperator();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertEquals(expectedEntries.get(entry.getKey()), entry.setValue(operator.apply(value)));
            }
            expectedEntries.replaceAll((k, v) -> operator.apply(v));
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="setValue(Object) with null")
        default public void testSetValueWithNull(TestInfo testInfo) {
            Map map = this.map();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            Map<Object, Object> expectedEntries = this.expectedEntries();
            for (Map.Entry entry : map.entrySet()) {
                if (annotation == null) {
                    Assertions.assertEquals(expectedEntries.get(entry.getKey()), entry.setValue(null));
                    continue;
                }
                Assertions.assertThrows(annotation.expected(), () -> entry.setValue(null));
            }
            if (annotation == null) {
                expectedEntries = new HashMap(expectedEntries);
                expectedEntries.replaceAll((k, v) -> null);
                Assertions.assertEquals(expectedEntries, map);
            } else {
                Assertions.assertEquals(expectedEntries, map);
            }
        }
    }

    @DisplayName(value="getValue()")
    public static interface GetValueTests<K, V>
    extends MapEntryTests<K, V> {
        @Test
        @DisplayName(value="getValue()")
        default public void testGetValue() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : map.entrySet()) {
                Assertions.assertEquals(expectedEntries.get(entry.getKey()), entry.getValue());
            }
        }
    }
}

