/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionTests;
import com.github.robtimus.junit.support.test.collections.CollectionUtils;
import com.github.robtimus.junit.support.test.collections.IncompatibleObject;
import com.github.robtimus.junit.support.test.collections.IterableTests;
import com.github.robtimus.junit.support.test.collections.IteratorTests;
import com.github.robtimus.junit.support.test.collections.SetTests;
import com.github.robtimus.junit.support.test.collections.UnmodifiableCollectionTests;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsIncompatibleKeyNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsIncompatibleNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsNullKeyNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.ContainsNullNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.RemoveIncompatibleKeyNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.RemoveIncompatibleNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.RemoveNullKeyNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.RemoveNullNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.StoreNullKeyNotSupported;
import com.github.robtimus.junit.support.test.collections.annotation.StoreNullNotSupported;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public interface MapTests<K, V> {
    public Map<K, V> map();

    public Map<K, V> expectedEntries();

    public Map<K, V> nonContainedEntries();

    public static final class RemoveExactValueArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            RemoveExactValueTests instance = (RemoveExactValueTests)context.getRequiredTestInstance();
            Object nonContained = instance.nonContainedEntries().values().iterator().next();
            Stream<Arguments> expected = instance.expectedEntries().entrySet().stream().map(e -> Arguments.arguments((Object[])new Object[]{e.getKey(), e.getValue(), true}));
            Stream<Arguments> containedKeysWithDifferentValue = instance.expectedEntries().keySet().stream().map(e -> Arguments.arguments((Object[])new Object[]{e, nonContained, false}));
            Stream<Arguments> notExpected = instance.nonContainedEntries().keySet().stream().map(e -> Arguments.arguments((Object[])new Object[]{e, null, false}));
            return Stream.of(expected, containedKeysWithDifferentValue, notExpected).flatMap(Function.identity());
        }
    }

    public static final class EqualsArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            EqualsTests instance = (EqualsTests)context.getRequiredTestInstance();
            Map expected = instance.expectedEntries();
            Map.Entry nonContained = instance.nonContainedEntries().entrySet().iterator().next();
            ArrayList<Arguments> arguments = new ArrayList<Arguments>();
            arguments.add(Arguments.arguments((Object[])new Object[]{new HashMap(expected), true}));
            if (!expected.isEmpty()) {
                HashMap map = new HashMap(expected);
                Iterator iterator = map.entrySet().iterator();
                iterator.next();
                iterator.remove();
                arguments.add(Arguments.arguments((Object[])new Object[]{map, false}));
                HashMap withDifferentValue = new HashMap(expected);
                iterator = withDifferentValue.entrySet().iterator();
                Map.Entry entry = iterator.next();
                entry.setValue(nonContained);
                arguments.add(Arguments.arguments((Object[])new Object[]{map, false}));
            }
            HashMap withNonContained = new HashMap(expected);
            withNonContained.put(nonContained.getKey(), nonContained.getValue());
            arguments.add(Arguments.arguments((Object[])new Object[]{withNonContained, false}));
            return arguments.stream();
        }
    }

    public static final class RemoveArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            RemoveTests instance = (RemoveTests)context.getRequiredTestInstance();
            Stream<Arguments> expected = instance.expectedEntries().entrySet().stream().map(e -> Arguments.arguments((Object[])new Object[]{e.getKey(), e.getValue(), true}));
            Stream<Arguments> notExpected = instance.nonContainedEntries().keySet().stream().map(e -> Arguments.arguments((Object[])new Object[]{e, null, false}));
            return Stream.of(expected, notExpected).flatMap(Function.identity());
        }
    }

    @DisplayName(value="merge(Object, Object, BiFunction)")
    public static interface MergeTests<K, V>
    extends MapTests<K, V> {
        public BinaryOperator<V> combineValuesOperator();

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction)")
        default public void testMerge() {
            Object value;
            Map map = this.map();
            BinaryOperator operator = this.combineValuesOperator();
            HashMap<Object, Object> expectedEntries = new HashMap<Object, Object>(this.expectedEntries());
            Map nonContainedEntries = this.nonContainedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                value = entry.getValue();
                Object newValue = operator.apply(value, value);
                Assertions.assertEquals(newValue, map.merge(entry.getKey(), value, operator));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                value = entry.getValue();
                Assertions.assertEquals(value, map.merge(entry.getKey(), value, operator));
            }
            expectedEntries.replaceAll((k, v) -> operator.apply(v, v));
            expectedEntries.putAll(nonContainedEntries);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction) with function returning null")
        default public void testMergeWithFunctionReturningNull() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            Map nonContainedEntries = this.nonContainedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertNull((Object)map.merge(entry.getKey(), entry.getValue(), (v1, v2) -> null));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertEquals(value, (Object)map.merge(entry.getKey(), value, (v1, v2) -> null));
            }
            Assertions.assertEquals(nonContainedEntries, map);
        }

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction) with throwing function")
        default public void testMergeWithThrowingFunction() {
            Map map = this.map();
            RuntimeException exception = new RuntimeException();
            BinaryOperator operator = (v1, v2) -> {
                throw exception;
            };
            HashMap expectedEntries = new HashMap(this.expectedEntries());
            Map nonContainedEntries = this.nonContainedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> map.merge(entry.getKey(), entry.getValue(), operator));
                Assertions.assertSame((Object)exception, (Object)thrown);
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertEquals(value, map.merge(entry.getKey(), value, operator));
            }
            expectedEntries.putAll(nonContainedEntries);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction) with null function")
        default public void testMergeWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.merge(entry.getKey(), entry.getValue(), null));
            }
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.merge(entry.getKey(), entry.getValue(), null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="compute(Object, BiFunction)")
    public static interface ComputeTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="compute(Object, BiFunction)")
        default public void testCompute() {
            Map<Object, Object> map = this.map();
            HashMap<Object, Object> expectedEntries = new HashMap<Object, Object>(this.expectedEntries());
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertEquals(nonContained, (Object)map.compute(entry.getKey(), (k, v) -> nonContained));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertEquals(value, (Object)map.compute(entry.getKey(), (k, v) -> value));
            }
            expectedEntries.replaceAll((k, v) -> nonContained);
            expectedEntries.putAll(nonContainedEntries);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="compute(Object, BiFunction) with function returning null")
        default public void testComputeWithFunctionReturningNull() {
            Map<Object, Object> map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertNull((Object)map.compute(key, (k, v) -> null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                Assertions.assertNull((Object)map.compute(key, (k, v) -> null));
            }
            Assertions.assertEquals(Collections.emptyMap(), map);
        }

        @Test
        @DisplayName(value="compute(Object, BiFunction) with throwing function")
        default public void testComputeWithThrowingFunction() {
            RuntimeException thrown;
            Map map = this.map();
            RuntimeException exception = new RuntimeException();
            BiFunction<Object, Object, Object> function = (k, v) -> {
                throw exception;
            };
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> map.compute(key, function));
                Assertions.assertSame((Object)exception, (Object)thrown);
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> map.compute(key, function));
                Assertions.assertSame((Object)exception, (Object)thrown);
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="compute(Object, BiFunction) with null function")
        default public void testComputeWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.compute(key, null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.compute(key, null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="computeIfPresent(Object, BiFunction)")
    public static interface ComputeIfPresentTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction)")
        default public void testComputeIfPresent() {
            Map<Object, Object> map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            HashMap<Object, Object> expectedEntries = new HashMap<Object, Object>(this.expectedEntries());
            for (Object k2 : expectedEntries.keySet()) {
                Assertions.assertEquals(nonContained, (Object)map.computeIfPresent(k2, (k, v) -> nonContained));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertNull((Object)map.computeIfPresent(entry.getKey(), (k, v) -> value));
            }
            expectedEntries.replaceAll((k, v) -> nonContained);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction) with function returning null")
        default public void testComputeIfPresentWithFunctionReturningNull() {
            Map<Object, Object> map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertNull((Object)map.computeIfPresent(key, (k, v) -> null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                Assertions.assertNull((Object)map.computeIfPresent(key, (k, v) -> null));
            }
            Assertions.assertEquals(Collections.emptyMap(), map);
        }

        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction) with throwing function")
        default public void testComputeIfPresentWithThrowingFunction() {
            Map<Object, Object> map = this.map();
            RuntimeException exception = new RuntimeException();
            BiFunction<Object, Object, Object> function = (k, v) -> {
                throw exception;
            };
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> map.computeIfPresent(key, function));
                Assertions.assertSame((Object)exception, (Object)thrown);
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                Assertions.assertNull((Object)map.computeIfPresent(key, function));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction) with null function")
        default public void testComputeIfPresentWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.computeIfPresent(key, null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.computeIfPresent(key, null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="computeIfAbsent(Object, Function)")
    public static interface ComputeIfAbsentTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="computeIfAbsent(Object, Function)")
        default public void testComputeIfAbsent() {
            Map<Object, Object> map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            HashMap expectedEntries = new HashMap(this.expectedEntries());
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertEquals(entry.getValue(), (Object)map.computeIfAbsent(entry.getKey(), k -> nonContained));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertEquals(entry.getValue(), (Object)map.computeIfAbsent(entry.getKey(), k -> value));
            }
            expectedEntries.putAll(nonContainedEntries);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfAbsent(Object, Function) with function returning null")
        default public void testComputeIfAbsentWithFunctionReturningNull() {
            Map<Object, Object> map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertEquals(entry.getValue(), (Object)map.computeIfAbsent(entry.getKey(), k -> null));
            }
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                Assertions.assertNull((Object)map.computeIfAbsent(entry.getKey(), k -> null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfAbsent(Object, Function) with throwing function")
        default public void testComputeIfAbsentWithThrowingFunction() {
            Map<Object, Object> map = this.map();
            RuntimeException exception = new RuntimeException();
            Function<Object, Object> function = k -> {
                throw exception;
            };
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertEquals(entry.getValue(), (Object)map.computeIfAbsent(entry.getKey(), function));
            }
            for (Map.Entry key : this.nonContainedEntries().keySet()) {
                RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> map.computeIfAbsent(key, function));
                Assertions.assertSame((Object)exception, (Object)thrown);
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfAbsent(Object, Function) with null function")
        default public void testComputeIfAbsentWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.computeIfAbsent(key, null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                Assertions.assertThrows(NullPointerException.class, () -> map.computeIfAbsent(key, null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="replace(Object, Object)")
    public static interface ReplaceTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="replace(Object, Object)")
        default public void testReplace() {
            Map map = this.map();
            HashMap<Object, Object> expectedEntries = new HashMap<Object, Object>(this.expectedEntries());
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Assertions.assertNull(map.replace(entry.getKey(), entry.getValue()));
            }
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertEquals(entry.getValue(), map.replace(entry.getKey(), nonContained));
            }
            expectedEntries.replaceAll((k, v) -> nonContained);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="replace(Object, Object) with null key")
        default public void testReplaceExactValueWithNullKey(TestInfo testInfo) {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            StoreNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertNull(map.replace(null, nonContained));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.replace(null, nonContained));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="replace(Object, Object) with null value")
        default public void testReplaceExactValueWithNullValue(TestInfo testInfo) {
            Map map = this.map();
            Map<Object, Object> expectedEntries = this.expectedEntries();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            if (annotation == null) {
                for (Map.Entry entry : expectedEntries.entrySet()) {
                    Assertions.assertEquals(entry.getValue(), map.replace(entry.getKey(), null));
                }
                expectedEntries = new HashMap(expectedEntries);
                expectedEntries.replaceAll((k, v) -> null);
            } else {
                for (Object key : expectedEntries.keySet()) {
                    Assertions.assertThrows(annotation.expected(), () -> map.replace(key, null));
                }
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="replace(Object, Object, Object)")
    public static interface ReplaceExactValueTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="replace(Object, Object, Object)")
        default public void testReplaceExactValue() {
            Map map = this.map();
            HashMap<Object, Object> expectedEntries = new HashMap<Object, Object>(this.expectedEntries());
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Assertions.assertFalse((boolean)map.replace(entry.getKey(), entry.getValue(), nonContained));
            }
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertFalse((boolean)map.replace(entry.getKey(), nonContained, entry.getValue()));
            }
            Assertions.assertEquals(expectedEntries, map);
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertTrue((boolean)map.replace(entry.getKey(), entry.getValue(), nonContained));
            }
            expectedEntries.replaceAll((k, v) -> nonContained);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="replace(Object, Object, Object) with null key")
        default public void testReplaceExactValueWithNullKey(TestInfo testInfo) {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            StoreNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.replace(null, nonContained, nonContained));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.replace(null, nonContained, nonContained));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="replace(Object, Object, Object) with null value")
        default public void testReplaceExactValueWithNullValue(TestInfo testInfo) {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().keySet().iterator().next();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.replace(nonContained, null, null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.replace(nonContained, null, null));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="remove(Object, Object)")
    public static interface RemoveExactValueTests<K, V>
    extends MapTests<K, V> {
        @ParameterizedTest(name="{0}, {1}: {2}")
        @ArgumentsSource(value=RemoveExactValueArgumentsProvider.class)
        @DisplayName(value="remove(Object, Object)")
        default public void testRemoveExactValue(Object key, Object value, boolean expected) {
            Map map = this.map();
            Assertions.assertEquals((Object)expected, (Object)map.remove(key, value));
            Map expectedEntries = this.expectedEntries();
            if (expected) {
                expectedEntries = new HashMap(expectedEntries);
                expectedEntries.remove(key);
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with null key")
        default public void testRemoveExactValueWithNullKey(TestInfo testInfo) {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            RemoveNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.remove(null, nonContained));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.remove(null, nonContained));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with incompatible key")
        default public void testRemoveExactValueWithIncompatibleKey(TestInfo testInfo) {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            RemoveIncompatibleKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.remove(new IncompatibleObject(), nonContained));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.remove(new IncompatibleObject(), nonContained));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with null value")
        default public void testRemoveExactValueWithNullValue(TestInfo testInfo) {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().keySet().iterator().next();
            RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.remove(nonContained, null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.remove(nonContained, null));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with incompatible value")
        default public void testRemoveExactValueWithIncompatibleValue(TestInfo testInfo) {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().keySet().iterator().next();
            RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.remove(nonContained, new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.remove(nonContained, new IncompatibleObject()));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="putIfAbsent(Object, Object)")
    public static interface PutIfAbsentTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="putIfAbsent(Object, Object)")
        default public void testPutIfAbsent() {
            Map map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            HashMap expectedEntries = new HashMap(this.expectedEntries());
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertEquals(entry.getValue(), map.putIfAbsent(entry.getKey(), nonContained));
            }
            Assertions.assertEquals(expectedEntries, map);
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Assertions.assertNull(map.putIfAbsent(entry.getKey(), entry.getValue()));
            }
            expectedEntries.putAll(nonContainedEntries);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="putIfAbsent(Object, Object) with existing null value")
        default public void testPutIfAbsentWithExistingNullValue() {
            Map map = this.map();
            HashMap expectedEntries = new HashMap(this.expectedEntries());
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContainedKey = nonContainedEntries.keySet().iterator().next();
            Object nonContainedValue = nonContainedEntries.values().iterator().next();
            map.put(nonContainedKey, null);
            expectedEntries.put(nonContainedKey, null);
            Assertions.assertEquals(expectedEntries, map);
            Assertions.assertTrue((boolean)map.containsKey(nonContainedKey));
            Assertions.assertNull(map.get(nonContainedKey));
            Assertions.assertNull(map.putIfAbsent(nonContainedKey, nonContainedValue));
            expectedEntries.put(nonContainedKey, nonContainedValue);
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="replaceAll(BiFunction)")
    public static interface ReplaceAllTests<K, V>
    extends MapTests<K, V> {
        public BiFunction<K, V, V> replaceValueFunction();

        @Test
        @DisplayName(value="replaceAll(BiFunction)")
        default public void testReplaceAll() {
            Map<K, V> map = this.map();
            BiFunction<K, V, V> function = this.replaceValueFunction();
            map.replaceAll(function);
            HashMap<K, V> expectedEntries = new HashMap<K, V>(this.expectedEntries());
            expectedEntries.replaceAll(function);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="replaceAll(BiFunction) with null function")
        default public void testReplaceAllWithNullOperator() {
            Map map = this.map();
            Assertions.assertThrows(NullPointerException.class, () -> map.replaceAll(null));
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="forEach(BiConsumer)")
    public static interface ForEachTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="forEach(BiConsumer)")
        default public void testForEach() {
            Map<Object, Object> map = this.map();
            HashMap m = new HashMap();
            map.forEach(m::put);
            Assertions.assertEquals(this.expectedEntries(), m);
        }

        @Test
        @DisplayName(value="forEach(BiConsumer) with null consumer")
        default public void testForEachWithNullConsumer() {
            Map map = this.map();
            Assertions.assertThrows(NullPointerException.class, () -> map.forEach(null));
        }
    }

    @DisplayName(value="getOrDefault(Object, Object)")
    public static interface GetOrDefaultTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="getOrDefault(Object, Object)")
        default public void testGetOrDefault() {
            Map map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            ArrayList nonContained = new ArrayList(nonContainedEntries.entrySet());
            Object firstValue = ((Map.Entry)nonContained.get(0)).getValue();
            Object lastValue = ((Map.Entry)nonContained.get(nonContained.size() - 1)).getValue();
            for (Map.Entry entry : this.expectedEntries().entrySet()) {
                Assertions.assertEquals(entry.getValue(), map.getOrDefault(entry.getKey(), firstValue));
                Assertions.assertEquals(entry.getValue(), map.getOrDefault(entry.getKey(), lastValue));
                Assertions.assertEquals(entry.getValue(), map.getOrDefault(entry.getKey(), null));
            }
            for (Map.Entry key : nonContainedEntries.keySet()) {
                Assertions.assertEquals(firstValue, map.getOrDefault(key, firstValue));
                Assertions.assertEquals(lastValue, map.getOrDefault(key, lastValue));
                Assertions.assertNull(map.getOrDefault(key, null));
            }
        }

        @Test
        @DisplayName(value="getOrDefault(Object, Object) with null")
        default public void testGetOrDefaultWithNull(TestInfo testInfo) {
            Map map = this.map();
            ContainsNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullKeyNotSupported.class);
            ArrayList nonContained = new ArrayList(this.nonContainedEntries().entrySet());
            Object firstValue = ((Map.Entry)nonContained.get(0)).getValue();
            Object lastValue = ((Map.Entry)nonContained.get(nonContained.size() - 1)).getValue();
            if (annotation == null) {
                Assertions.assertEquals(firstValue, map.getOrDefault(null, firstValue));
                Assertions.assertEquals(lastValue, map.getOrDefault(null, lastValue));
                Assertions.assertNull(map.getOrDefault(null, null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.getOrDefault(null, firstValue));
                Assertions.assertThrows(annotation.expected(), () -> map.getOrDefault(null, lastValue));
                Assertions.assertThrows(annotation.expected(), () -> map.getOrDefault(null, null));
            }
        }

        @Test
        @DisplayName(value="getOrDefault(Object, Object) with an incompatible object")
        default public void testGetOrDefaultWithIncompatibleObject(TestInfo testInfo) {
            Map map = this.map();
            ContainsIncompatibleKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleKeyNotSupported.class);
            ArrayList nonContained = new ArrayList(this.nonContainedEntries().entrySet());
            Object firstValue = ((Map.Entry)nonContained.get(0)).getValue();
            Object lastValue = ((Map.Entry)nonContained.get(nonContained.size() - 1)).getValue();
            if (annotation == null) {
                Assertions.assertEquals(firstValue, map.getOrDefault(new IncompatibleObject(), firstValue));
                Assertions.assertEquals(lastValue, map.getOrDefault(new IncompatibleObject(), lastValue));
                Assertions.assertNull(map.getOrDefault(new IncompatibleObject(), null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.getOrDefault(new IncompatibleObject(), firstValue));
                Assertions.assertThrows(annotation.expected(), () -> map.getOrDefault(new IncompatibleObject(), lastValue));
                Assertions.assertThrows(annotation.expected(), () -> map.getOrDefault(new IncompatibleObject(), null));
            }
        }
    }

    @DisplayName(value="hashCode()")
    public static interface HashCodeTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="hashCode()")
        default public void testHashCode() {
            Map map = this.map();
            int expected = this.expectedEntries().entrySet().stream().mapToInt(Map.Entry::hashCode).sum();
            Assertions.assertEquals((int)expected, (int)map.hashCode());
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="equals(Object)")
    public static interface EqualsTests<K, V>
    extends MapTests<K, V> {
        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=EqualsArgumentsProvider.class)
        @DisplayName(value="equals(Object)")
        default public void testEquals(Map<?, ?> other, boolean expected) {
            Map map = this.map();
            if (expected) {
                Assertions.assertEquals(other, map);
            } else {
                Assertions.assertNotEquals(other, map);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with self")
        default public void testEqualsSelf() {
            Map map = this.map();
            Assertions.assertEquals(map, map);
        }

        @Test
        @DisplayName(value="equals(Object) with null")
        default public void testEqualsNull() {
            Map map = this.map();
            Assertions.assertNotEquals(null, map);
        }

        @Test
        @DisplayName(value="equals(Object) with set")
        default public void testEqualsList() {
            Map map = this.map();
            Assertions.assertNotEquals(map.entrySet(), map);
        }
    }

    @DisplayName(value="entrySet()")
    public static interface EntrySetTests<K, V>
    extends MapTests<K, V>,
    SetTests<Map.Entry<K, V>> {
        @Override
        default public Set<Map.Entry<K, V>> iterable() {
            return this.map().entrySet();
        }

        @Override
        default public Collection<Map.Entry<K, V>> expectedElements() {
            return this.expectedEntries().entrySet();
        }

        @Override
        default public Collection<Map.Entry<K, V>> nonContainedElements() {
            return this.nonContainedEntries().entrySet();
        }

        @DisplayName(value="spliterator()")
        public static interface SpliteratorTests<K, V>
        extends EntrySetTests<K, V>,
        SetTests.SpliteratorTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="hashCode()")
        public static interface HashCodeTests<K, V>
        extends EntrySetTests<K, V>,
        SetTests.HashCodeTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="equals(Object)")
        public static interface EqualsTests<K, V>
        extends EntrySetTests<K, V>,
        SetTests.EqualsTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="clear()")
        public static interface ClearTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ClearTests<Map.Entry<K, V>> {
            @Override
            @Test
            @DisplayName(value="clear()")
            default public void testClear() {
                Map map = this.map();
                Set entrySet = map.entrySet();
                entrySet.clear();
                CollectionAssertions.assertHasElements(entrySet, Collections.emptyList(), this.fixedOrder());
                Assertions.assertEquals(Collections.emptyMap(), map);
            }
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="retainAll(Collection)")
        public static interface RetainAllTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.RetainAllTests<Map.Entry<K, V>> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RetainAllArgumentsProvider.class)
            @DisplayName(value="retainAll(Collection)")
            default public void testRetainAll(Collection<?> c, boolean expected) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Assertions.assertEquals((Object)expected, (Object)entrySet.retainAll(c));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.entrySet();
                    expectedElements.retainAll(c);
                }
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a null collection")
            default public void testRetainAllWithNullCollection() {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Assertions.assertThrows(NullPointerException.class, () -> entrySet.retainAll(null));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a collection with a null")
            default public void testRetainAllWithCollectionWithNull(TestInfo testInfo) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                ArrayList c = new ArrayList(expectedElements);
                c.add(null);
                ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)entrySet.retainAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> entrySet.retainAll(c));
                }
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a collection with an incompatible object")
            default public void testRetainAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                ArrayList c = new ArrayList(expectedElements);
                c.add(new IncompatibleObject());
                ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)entrySet.retainAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> entrySet.retainAll(c));
                }
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="removeIf(Predicate)")
        public static interface RemoveIfTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.RemoveIfTests<Map.Entry<K, V>> {
            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with matching predicate")
            default public void testRemoveIfWithMatchingPredicate() {
                Map map = this.map();
                Set entrySet = map.entrySet();
                boolean isEmpty = entrySet.isEmpty();
                Assertions.assertEquals((Object)(!isEmpty ? 1 : 0), (Object)entrySet.removeIf(e -> true));
                CollectionAssertions.assertHasElements(entrySet, Collections.emptyList(), this.fixedOrder());
                Assertions.assertEquals(Collections.emptyMap(), map);
            }

            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with non-matching predicate")
            default public void testRemoveIfWithNonMatchingPredicate() {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Assertions.assertFalse((boolean)entrySet.removeIf(e -> false));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with null predicate")
            default public void testRemoveIfWithNullPredicate() {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Assertions.assertThrows(NullPointerException.class, () -> entrySet.removeIf(null));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="removeAll(Collection)")
        public static interface RemoveAllTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.RemoveAllTests<Map.Entry<K, V>> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RemoveAllArgumentsProvider.class)
            @DisplayName(value="removeAll(Collection)")
            default public void testRemoveAll(Collection<?> c, boolean expected) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Assertions.assertEquals((Object)expected, (Object)entrySet.removeAll(c));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.entrySet();
                    expectedElements.removeAll(c);
                }
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a null collection")
            default public void testRemoveAllWithNullCollection() {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Assertions.assertThrows(NullPointerException.class, () -> entrySet.removeAll(null));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a collection with a null")
            default public void testRemoveAllWithCollectionWithNull(TestInfo testInfo) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Set<Object> c = Collections.singleton(null);
                RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)entrySet.removeAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> entrySet.removeAll(c));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a collection with an incompatible object")
            default public void testRemoveAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Set<IncompatibleObject> c = Collections.singleton(new IncompatibleObject());
                RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)entrySet.removeAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> entrySet.removeAll(c));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="addAll(Collection)")
        public static interface AddAllTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.AddAllTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="containsAll(Collection)")
        public static interface ContainsAllTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ContainsAllTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="remove(Object)")
        public static interface RemoveTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.RemoveTests<Map.Entry<K, V>> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RemoveArgumentsProvider.class)
            @DisplayName(value="remove(Object)")
            default public void testRemove(Object o, boolean expected) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                Assertions.assertEquals((Object)expected, (Object)entrySet.remove(o));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.entrySet();
                    expectedElements.remove(o);
                }
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="remove(Object) with null")
            default public void testRemoveNull(TestInfo testInfo) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)entrySet.remove(null));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> entrySet.remove(null));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="remove(Object) with incompatible object")
            default public void testRemoveIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Set entrySet = map.entrySet();
                RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)entrySet.remove(new IncompatibleObject()));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> entrySet.remove(new IncompatibleObject()));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.entrySet();
                CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="add(Object)")
        public static interface AddTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.AddTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="toArray(IntFunction)")
        public static interface ToArrayWithGeneratorTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ToArrayWithGeneratorTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="toArray(Object[])")
        public static interface ToArrayTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ToArrayTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="toArray()")
        public static interface ToObjectArrayTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ToObjectArrayTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="contains(Object)")
        public static interface ContainsTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ContainsTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface ForEachTests<K, V>
        extends EntrySetTests<K, V>,
        IterableTests.ForEachTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface IteratorTests<K, V>
        extends EntrySetTests<K, V>,
        com.github.robtimus.junit.support.test.collections.IteratorTests<Map.Entry<K, V>> {
            @Override
            default public Set<Map.Entry<K, V>> iterable() {
                return EntrySetTests.super.iterable();
            }

            @Override
            default public Collection<Map.Entry<K, V>> expectedElements() {
                return EntrySetTests.super.expectedElements();
            }

            @DisplayName(value="forEachRemaining(Consumer)")
            public static interface ForEachRemainingTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$ForEachRemainingTests<Map.Entry<K, V>> {
            }

            @DisplayName(value="remove()")
            public static interface RemoveTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$RemoveTests<Map.Entry<K, V>> {
                @Override
                @Test
                @DisplayName(value="remove() for every element")
                default public void testRemoveEveryElement() {
                    Map map = this.map();
                    Set entrySet = map.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                    List remaining = CollectionUtils.toList(entrySet);
                    CollectionAssertions.assertHasElements(remaining, Collections.emptyList(), this.fixedOrder());
                    Assertions.assertEquals(Collections.emptyMap(), map);
                }

                @Override
                @Test
                @DisplayName(value="remove() for every even-indexed element")
                default public void testRemoveEveryEvenIndexedElement() {
                    Map map = this.map();
                    Set entrySet = map.entrySet();
                    Iterator iterator = entrySet.iterator();
                    HashMap expectedEntries = new HashMap(this.expectedEntries());
                    List expectedElements = expectedEntries.entrySet().stream().map(AbstractMap.SimpleImmutableEntry::new).collect(Collectors.toList());
                    boolean remove = true;
                    while (iterator.hasNext()) {
                        Map.Entry element = iterator.next();
                        if (remove) {
                            expectedElements.remove(element);
                            expectedEntries.remove(element.getKey(), element.getValue());
                            iterator.remove();
                        }
                        remove = !remove;
                    }
                    List remaining = CollectionUtils.toList(entrySet);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }

                @Override
                @Test
                @DisplayName(value="remove() before next()")
                default public void testRemoveBeforeNext() {
                    Map map = this.map();
                    Set entrySet = map.entrySet();
                    Iterator iterator = entrySet.iterator();
                    Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                    Map expectedEntries = this.expectedEntries();
                    Set expectedElements = expectedEntries.entrySet();
                    List remaining = CollectionUtils.toList(entrySet);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }

                @Override
                @Test
                @DisplayName(value="remove() after remove()")
                default public void testRemoveAfterRemove() {
                    Map map = this.map();
                    Set entrySet = map.entrySet();
                    Iterator iterator = entrySet.iterator();
                    HashMap expectedEntries = new HashMap(this.expectedEntries());
                    List expectedElements = expectedEntries.entrySet().stream().map(AbstractMap.SimpleImmutableEntry::new).collect(Collectors.toList());
                    boolean remove = true;
                    while (iterator.hasNext()) {
                        Map.Entry element = iterator.next();
                        if (remove) {
                            expectedElements.remove(element);
                            expectedEntries.remove(element.getKey(), element.getValue());
                            iterator.remove();
                            Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                        }
                        remove = !remove;
                    }
                    List remaining = CollectionUtils.toList(entrySet);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                }
            }

            @DisplayName(value="iteration")
            public static interface IterationTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$IterationTests<Map.Entry<K, V>> {
            }
        }
    }

    @DisplayName(value="values()")
    public static interface ValuesTests<K, V>
    extends MapTests<K, V>,
    CollectionTests<V> {
        @Override
        default public Collection<V> iterable() {
            return this.map().values();
        }

        @Override
        default public Collection<V> expectedElements() {
            return this.expectedEntries().values();
        }

        @Override
        default public Collection<V> nonContainedElements() {
            return this.nonContainedEntries().values();
        }

        @DisplayName(value="clear()")
        public static interface ClearTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ClearTests<V> {
            @Override
            @Test
            @DisplayName(value="clear()")
            default public void testClear() {
                Map map = this.map();
                Collection values = map.values();
                values.clear();
                CollectionAssertions.assertHasElements(values, Collections.emptyList(), this.fixedOrder());
                Assertions.assertEquals(Collections.emptyMap(), map);
            }
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="retainAll(Collection)")
        public static interface RetainAllTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.RetainAllTests<V> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RetainAllArgumentsProvider.class)
            @DisplayName(value="retainAll(Collection)")
            default public void testRetainAll(Collection<?> c, boolean expected) {
                Map map = this.map();
                Collection values = map.values();
                Assertions.assertEquals((Object)expected, (Object)values.retainAll(c));
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.values();
                    expectedElements.retainAll(c);
                }
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a null collection")
            default public void testRetainAllWithNullCollection() {
                Map map = this.map();
                Collection values = map.values();
                Assertions.assertThrows(NullPointerException.class, () -> values.retainAll(null));
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a collection with a null")
            default public void testRetainAllWithCollectionWithNull(TestInfo testInfo) {
                Map map = this.map();
                Collection values = map.values();
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                ArrayList c = new ArrayList(expectedElements);
                c.add(null);
                ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)values.retainAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> values.retainAll(c));
                }
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a collection with an incompatible object")
            default public void testRetainAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Collection values = map.values();
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                ArrayList c = new ArrayList(expectedElements);
                c.add(new IncompatibleObject());
                ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)values.retainAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> values.retainAll(c));
                }
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="removeIf(Predicate)")
        public static interface RemoveIfTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.RemoveIfTests<V> {
            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with matching predicate")
            default public void testRemoveIfWithMatchingPredicate() {
                Map map = this.map();
                Collection values = map.values();
                boolean isEmpty = values.isEmpty();
                Assertions.assertEquals((Object)(!isEmpty ? 1 : 0), (Object)values.removeIf(e -> true));
                CollectionAssertions.assertHasElements(values, Collections.emptyList(), this.fixedOrder());
                Assertions.assertEquals(Collections.emptyMap(), map);
            }

            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with non-matching predicate")
            default public void testRemoveIfWithNonMatchingPredicate() {
                Map map = this.map();
                Collection values = map.values();
                Assertions.assertFalse((boolean)values.removeIf(e -> false));
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with null predicate")
            default public void testRemoveIfWithNullPredicate() {
                Map map = this.map();
                Collection values = map.values();
                Assertions.assertThrows(NullPointerException.class, () -> values.removeIf(null));
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="removeAll(Collection)")
        public static interface RemoveAllTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.RemoveAllTests<V> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RemoveAllArgumentsProvider.class)
            @DisplayName(value="removeAll(Collection)")
            default public void testRemoveAll(Collection<?> c, boolean expected) {
                Map map = this.map();
                Collection values = map.values();
                Assertions.assertEquals((Object)expected, (Object)values.removeAll(c));
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.values();
                    expectedElements.removeAll(c);
                }
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a null collection")
            default public void testRemoveAllWithNullCollection() {
                Map map = this.map();
                Collection values = map.values();
                Assertions.assertThrows(NullPointerException.class, () -> values.removeAll(null));
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a collection with a null")
            default public void testRemoveAllWithCollectionWithNull(TestInfo testInfo) {
                Map map = this.map();
                Collection values = map.values();
                Set<Object> c = Collections.singleton(null);
                RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)values.removeAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> values.removeAll(c));
                }
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a collection with an incompatible object")
            default public void testRemoveAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Collection values = map.values();
                Set<IncompatibleObject> c = Collections.singleton(new IncompatibleObject());
                RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)values.removeAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> values.removeAll(c));
                }
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="addAll(Collection)")
        public static interface AddAllTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.AddAllTests<V> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="containsAll(Collection)")
        public static interface ContainsAllTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ContainsAllTests<V> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="remove(Object)")
        public static interface RemoveTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.RemoveTests<V> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RemoveArgumentsProvider.class)
            @DisplayName(value="remove(Object)")
            default public void testRemove(Object o, boolean expected) {
                Map map = this.map();
                Collection values = map.values();
                Assertions.assertEquals((Object)expected, (Object)values.remove(o));
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.values();
                    expectedElements.remove(o);
                }
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="remove(Object) with null")
            default public void testRemoveNull(TestInfo testInfo) {
                Map map = this.map();
                Collection values = map.values();
                RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)values.remove(null));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> values.remove(null));
                }
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="remove(Object) with incompatible object")
            default public void testRemoveIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Collection values = map.values();
                RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)values.remove(new IncompatibleObject()));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> values.remove(new IncompatibleObject()));
                }
                Map expectedEntries = this.expectedEntries();
                Collection expectedElements = expectedEntries.values();
                CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="add(Object)")
        public static interface AddTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.AddTests<V> {
        }

        @DisplayName(value="toArray(IntFunction)")
        public static interface ToArrayWithGeneratorTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ToArrayWithGeneratorTests<V> {
        }

        @DisplayName(value="toArray(Object[])")
        public static interface ToArrayTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ToArrayTests<V> {
        }

        @DisplayName(value="toArray()")
        public static interface ToObjectArrayTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ToObjectArrayTests<V> {
        }

        @DisplayName(value="contains(Object)")
        public static interface ContainsTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ContainsTests<V> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface ForEachTests<K, V>
        extends ValuesTests<K, V>,
        IterableTests.ForEachTests<V> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface IteratorTests<K, V>
        extends ValuesTests<K, V>,
        com.github.robtimus.junit.support.test.collections.IteratorTests<V> {
            @Override
            default public Collection<V> iterable() {
                return ValuesTests.super.iterable();
            }

            @Override
            default public Collection<V> expectedElements() {
                return ValuesTests.super.expectedElements();
            }

            @DisplayName(value="forEachRemaining(Consumer)")
            public static interface ForEachRemainingTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$ForEachRemainingTests<V> {
            }

            @DisplayName(value="remove()")
            public static interface RemoveTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$RemoveTests<V> {
                @Override
                @Test
                @DisplayName(value="remove() for every element")
                default public void testRemoveEveryElement() {
                    Map map = this.map();
                    Collection values = map.values();
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                    List remaining = CollectionUtils.toList(values);
                    CollectionAssertions.assertHasElements(remaining, Collections.emptyList(), this.fixedOrder());
                    Assertions.assertEquals(Collections.emptyMap(), map);
                }

                @Override
                @Test
                @DisplayName(value="remove() for every even-indexed element")
                default public void testRemoveEveryEvenIndexedElement() {
                    Map map = this.map();
                    Collection values = map.values();
                    Iterator iterator = values.iterator();
                    HashMap expectedEntries = new HashMap(this.expectedEntries());
                    Collection expectedElements = expectedEntries.values();
                    Iterator expectedIterator = expectedElements.iterator();
                    boolean remove = true;
                    while (iterator.hasNext()) {
                        iterator.next();
                        expectedIterator.next();
                        if (remove) {
                            expectedIterator.remove();
                            iterator.remove();
                        }
                        remove = !remove;
                    }
                    List remaining = CollectionUtils.toList(values);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }

                @Override
                @Test
                @DisplayName(value="remove() before next()")
                default public void testRemoveBeforeNext() {
                    Map map = this.map();
                    Collection values = map.values();
                    Iterator iterator = values.iterator();
                    Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                    Map expectedEntries = this.expectedEntries();
                    Collection expectedElements = expectedEntries.values();
                    List remaining = CollectionUtils.toList(values);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }

                @Override
                @Test
                @DisplayName(value="remove() after remove()")
                default public void testRemoveAfterRemove() {
                    Map map = this.map();
                    Collection values = map.values();
                    Iterator iterator = values.iterator();
                    HashMap expectedEntries = new HashMap(this.expectedEntries());
                    Collection expectedElements = expectedEntries.values();
                    Iterator expectedIterator = expectedElements.iterator();
                    boolean remove = true;
                    while (iterator.hasNext()) {
                        iterator.next();
                        expectedIterator.next();
                        if (remove) {
                            expectedIterator.remove();
                            iterator.remove();
                            Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                        }
                        remove = !remove;
                    }
                    List remaining = CollectionUtils.toList(values);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                }
            }

            @DisplayName(value="iteration")
            public static interface IterationTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$IterationTests<V> {
            }
        }
    }

    @DisplayName(value="keySet()")
    public static interface KeySetTests<K, V>
    extends MapTests<K, V>,
    SetTests<K> {
        @Override
        default public Set<K> iterable() {
            return this.map().keySet();
        }

        @Override
        default public Collection<K> expectedElements() {
            return this.expectedEntries().keySet();
        }

        @Override
        default public Collection<K> nonContainedElements() {
            return this.nonContainedEntries().keySet();
        }

        @DisplayName(value="spliterator()")
        public static interface SpliteratorTests<K, V>
        extends KeySetTests<K, V>,
        SetTests.SpliteratorTests<K> {
        }

        @DisplayName(value="hashCode()")
        public static interface HashCodeTests<K, V>
        extends KeySetTests<K, V>,
        SetTests.HashCodeTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="equals(Object)")
        public static interface EqualsTests<K, V>
        extends KeySetTests<K, V>,
        SetTests.EqualsTests<K> {
        }

        @DisplayName(value="clear()")
        public static interface ClearTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ClearTests<K> {
            @Override
            @Test
            @DisplayName(value="clear()")
            default public void testClear() {
                Map map = this.map();
                Set keySet = map.keySet();
                keySet.clear();
                CollectionAssertions.assertHasElements(keySet, Collections.emptyList(), this.fixedOrder());
                Assertions.assertEquals(Collections.emptyMap(), map);
            }
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="retainAll(Collection)")
        public static interface RetainAllTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.RetainAllTests<K> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RetainAllArgumentsProvider.class)
            @DisplayName(value="retainAll(Collection)")
            default public void testRetainAll(Collection<?> c, boolean expected) {
                Map map = this.map();
                Set keySet = map.keySet();
                Assertions.assertEquals((Object)expected, (Object)keySet.retainAll(c));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.keySet();
                    expectedElements.retainAll(c);
                }
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a null collection")
            default public void testRetainAllWithNullCollection() {
                Map map = this.map();
                Set keySet = map.keySet();
                Assertions.assertThrows(NullPointerException.class, () -> keySet.retainAll(null));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a collection with a null")
            default public void testRetainAllWithCollectionWithNull(TestInfo testInfo) {
                Map map = this.map();
                Set keySet = map.keySet();
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                ArrayList c = new ArrayList(expectedElements);
                c.add(null);
                ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)keySet.retainAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> keySet.retainAll(c));
                }
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="retainAll(Collection) with a collection with an incompatible object")
            default public void testRetainAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Set keySet = map.keySet();
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                ArrayList c = new ArrayList(expectedElements);
                c.add(new IncompatibleObject());
                ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)keySet.retainAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> keySet.retainAll(c));
                }
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="removeIf(Predicate)")
        public static interface RemoveIfTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.RemoveIfTests<K> {
            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with matching predicate")
            default public void testRemoveIfWithMatchingPredicate() {
                Map map = this.map();
                Set keySet = map.keySet();
                boolean isEmpty = keySet.isEmpty();
                Assertions.assertEquals((Object)(!isEmpty ? 1 : 0), (Object)keySet.removeIf(e -> true));
                CollectionAssertions.assertHasElements(keySet, Collections.emptyList(), this.fixedOrder());
                Assertions.assertEquals(Collections.emptyMap(), map);
            }

            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with non-matching predicate")
            default public void testRemoveIfWithNonMatchingPredicate() {
                Map map = this.map();
                Set keySet = map.keySet();
                Assertions.assertFalse((boolean)keySet.removeIf(e -> false));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeIf(Predicate) with null predicate")
            default public void testRemoveIfWithNullPredicate() {
                Map map = this.map();
                Set keySet = map.keySet();
                Assertions.assertThrows(NullPointerException.class, () -> keySet.removeIf(null));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="removeAll(Collection)")
        public static interface RemoveAllTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.RemoveAllTests<K> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RemoveAllArgumentsProvider.class)
            @DisplayName(value="removeAll(Collection)")
            default public void testRemoveAll(Collection<?> c, boolean expected) {
                Map map = this.map();
                Set keySet = map.keySet();
                Assertions.assertEquals((Object)expected, (Object)keySet.removeAll(c));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.keySet();
                    expectedElements.removeAll(c);
                }
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a null collection")
            default public void testRemoveAllWithNullCollection() {
                Map map = this.map();
                Set keySet = map.keySet();
                Assertions.assertThrows(NullPointerException.class, () -> keySet.removeAll(null));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a collection with a null")
            default public void testRemoveAllWithCollectionWithNull(TestInfo testInfo) {
                Map map = this.map();
                Set keySet = map.keySet();
                Set<Object> c = Collections.singleton(null);
                RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)keySet.removeAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> keySet.removeAll(c));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="removeAll(Collection) with a collection with an incompatible object")
            default public void testRemoveAllWithCollectionWithIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Set keySet = map.keySet();
                Set<IncompatibleObject> c = Collections.singleton(new IncompatibleObject());
                RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)keySet.removeAll(c));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> keySet.removeAll(c));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="addAll(Collection)")
        public static interface AddAllTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.AddAllTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="containsAll(Collection)")
        public static interface ContainsAllTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ContainsAllTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="remove(Object)")
        public static interface RemoveTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.RemoveTests<K> {
            @Override
            @ParameterizedTest(name="{0}: {1}")
            @ArgumentsSource(value=CollectionTests.RemoveArgumentsProvider.class)
            @DisplayName(value="remove(Object)")
            default public void testRemove(Object o, boolean expected) {
                Map map = this.map();
                Set keySet = map.keySet();
                Assertions.assertEquals((Object)expected, (Object)keySet.remove(o));
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                if (expected) {
                    expectedEntries = new HashMap(expectedEntries);
                    expectedElements = expectedEntries.keySet();
                    expectedElements.remove(o);
                }
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="remove(Object) with null")
            default public void testRemoveNull(TestInfo testInfo) {
                Map map = this.map();
                Set keySet = map.keySet();
                RemoveNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)keySet.remove(null));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> keySet.remove(null));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }

            @Override
            @Test
            @DisplayName(value="remove(Object) with incompatible object")
            default public void testRemoveIncompatibleObject(TestInfo testInfo) {
                Map map = this.map();
                Set keySet = map.keySet();
                RemoveIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleNotSupported.class);
                if (annotation == null) {
                    Assertions.assertFalse((boolean)keySet.remove(new IncompatibleObject()));
                } else {
                    Assertions.assertThrows(annotation.expected(), () -> keySet.remove(new IncompatibleObject()));
                }
                Map expectedEntries = this.expectedEntries();
                Set expectedElements = expectedEntries.keySet();
                CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                Assertions.assertEquals(expectedEntries, map);
            }
        }

        @DisplayName(value="add(Object)")
        public static interface AddTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.AddTests<K> {
        }

        @DisplayName(value="toArray(IntFunction)")
        public static interface ToArrayWithGeneratorTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ToArrayWithGeneratorTests<K> {
        }

        @DisplayName(value="toArray(Object[])")
        public static interface ToArrayTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ToArrayTests<K> {
        }

        @DisplayName(value="toArray()")
        public static interface ToObjectArrayTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ToObjectArrayTests<K> {
        }

        @DisplayName(value="contains(Object)")
        public static interface ContainsTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ContainsTests<K> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface ForEachTests<K, V>
        extends KeySetTests<K, V>,
        IterableTests.ForEachTests<K> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface IteratorTests<K, V>
        extends KeySetTests<K, V>,
        com.github.robtimus.junit.support.test.collections.IteratorTests<K> {
            @Override
            default public Set<K> iterable() {
                return KeySetTests.super.iterable();
            }

            @Override
            default public Collection<K> expectedElements() {
                return KeySetTests.super.expectedElements();
            }

            @DisplayName(value="forEachRemaining(Consumer)")
            public static interface ForEachRemainingTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$ForEachRemainingTests<K> {
            }

            @DisplayName(value="remove()")
            public static interface RemoveTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$RemoveTests<K> {
                @Override
                @Test
                @DisplayName(value="remove() for every element")
                default public void testRemoveEveryElement() {
                    Map map = this.map();
                    Set keySet = map.keySet();
                    Iterator iterator = keySet.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                    List remaining = CollectionUtils.toList(keySet);
                    CollectionAssertions.assertHasElements(remaining, Collections.emptyList(), this.fixedOrder());
                    Assertions.assertEquals(Collections.emptyMap(), map);
                }

                @Override
                @Test
                @DisplayName(value="remove() for every even-indexed element")
                default public void testRemoveEveryEvenIndexedElement() {
                    Map map = this.map();
                    Set keySet = map.keySet();
                    Iterator iterator = keySet.iterator();
                    HashMap expectedEntries = new HashMap(this.expectedEntries());
                    ArrayList expectedElements = new ArrayList(expectedEntries.keySet());
                    boolean remove = true;
                    while (iterator.hasNext()) {
                        Object element = iterator.next();
                        if (remove) {
                            expectedElements.remove(element);
                            expectedEntries.remove(element);
                            iterator.remove();
                        }
                        remove = !remove;
                    }
                    List remaining = CollectionUtils.toList(keySet);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }

                @Override
                @Test
                @DisplayName(value="remove() before next()")
                default public void testRemoveBeforeNext() {
                    Map map = this.map();
                    Set keySet = map.keySet();
                    Iterator iterator = keySet.iterator();
                    Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                    Map expectedEntries = this.expectedEntries();
                    Set expectedElements = expectedEntries.keySet();
                    List remaining = CollectionUtils.toList(keySet);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }

                @Override
                @Test
                @DisplayName(value="remove() after remove()")
                default public void testRemoveAfterRemove() {
                    Map map = this.map();
                    Set keySet = map.keySet();
                    Iterator iterator = keySet.iterator();
                    HashMap expectedEntries = new HashMap(this.expectedEntries());
                    ArrayList expectedElements = new ArrayList(expectedEntries.keySet());
                    boolean remove = true;
                    while (iterator.hasNext()) {
                        Object element = iterator.next();
                        if (remove) {
                            expectedElements.remove(element);
                            expectedEntries.remove(element);
                            iterator.remove();
                            Assertions.assertThrows(IllegalStateException.class, iterator::remove);
                        }
                        remove = !remove;
                    }
                    List remaining = CollectionUtils.toList(keySet);
                    CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
                }
            }

            @DisplayName(value="iteration")
            public static interface IterationTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$IterationTests<K> {
            }
        }
    }

    @DisplayName(value="clear()")
    public static interface ClearTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="clear()")
        default public void testClear() {
            Map map = this.map();
            map.clear();
            Assertions.assertEquals(Collections.emptyMap(), map);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="putAll(Map)")
    public static interface PutAllTests<K, V>
    extends MapTests<K, V> {
        public UnaryOperator<V> replaceValueOperator();

        @Test
        @DisplayName(value="putAll(Map)")
        default public void testPutAll() {
            Map map = this.map();
            HashMap expectedEntries = new HashMap(this.expectedEntries());
            map.putAll(Collections.emptyMap());
            Assertions.assertEquals(expectedEntries, map);
            UnaryOperator<V> operator = this.replaceValueOperator();
            HashMap m = new HashMap();
            Iterator i = expectedEntries.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                Object newValue = operator.apply(value);
                m.put(key, operator.apply(value));
                expectedEntries.put(key, newValue);
                if (!i.hasNext()) continue;
                i.next();
            }
            map.putAll(m);
            Assertions.assertEquals(expectedEntries, map);
            Map nonContainedEntries = this.nonContainedEntries();
            map.putAll(nonContainedEntries);
            expectedEntries.putAll(nonContainedEntries);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="putAll(Map) with a null map")
        default public void testPutAllWithNullMap() {
            Map map = this.map();
            Assertions.assertThrows(NullPointerException.class, () -> map.putAll(null));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="putAll(Map) with a map with a null key")
        default public void testPutAllWithMapWithNullKey(TestInfo testInfo) {
            Map map = this.map();
            Object nonContainedValue = this.nonContainedEntries().values().iterator().next();
            Map m = Collections.singletonMap(null, nonContainedValue);
            StoreNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullKeyNotSupported.class);
            Map expectedEntries = this.expectedEntries();
            if (annotation == null) {
                map.putAll(m);
                expectedEntries = new HashMap(expectedEntries);
                expectedEntries.put(null, nonContainedValue);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.putAll(m));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="putAll(Map) with a map with a null value")
        default public void testPutAllWithMapWithNullValue(TestInfo testInfo) {
            Map map = this.map();
            Map<Object, Object> expectedEntries = this.expectedEntries();
            HashMap<Object, Object> m = new HashMap<Object, Object>(expectedEntries);
            m.replaceAll((k, v) -> null);
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            if (annotation == null) {
                map.putAll(m);
                expectedEntries = new HashMap(expectedEntries);
                expectedEntries.replaceAll((k, v) -> null);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.putAll(m));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="remove(Object)")
    public static interface RemoveTests<K, V>
    extends MapTests<K, V> {
        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=RemoveArgumentsProvider.class)
        @DisplayName(value="remove(Object)")
        default public void testRemove(Object key, Object expectedValue, boolean expected) {
            Map map = this.map();
            Assertions.assertEquals((Object)expectedValue, map.remove(key));
            Map expectedEntries = this.expectedEntries();
            if (expected) {
                expectedEntries = new HashMap(expectedEntries);
                expectedEntries.remove(key);
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="remove(Object) with null")
        default public void testRemoveNull(TestInfo testInfo) {
            Map map = this.map();
            RemoveNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveNullKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertNull(map.remove(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.remove(null));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object) with incompatible object")
        default public void testRemoveIncompatibleObject(TestInfo testInfo) {
            Map map = this.map();
            RemoveIncompatibleKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(RemoveIncompatibleKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertNull(map.remove(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.remove(new IncompatibleObject()));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="put(Object, Object)")
    public static interface PutTests<K, V>
    extends MapTests<K, V> {
        public UnaryOperator<V> replaceValueOperator();

        @Test
        @DisplayName(value="put(Object, Object)")
        default public void testPut() {
            Map map = this.map();
            HashMap<Object, Object> expectedEntries = new HashMap<Object, Object>(this.expectedEntries());
            UnaryOperator operator = this.replaceValueOperator();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertEquals(value, map.put(entry.getKey(), operator.apply(value)));
            }
            Map nonContainedEntries = this.nonContainedEntries();
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Assertions.assertNull(map.put(entry.getKey(), entry.getValue()));
            }
            expectedEntries.replaceAll((k, v) -> operator.apply(v));
            expectedEntries.putAll(nonContainedEntries);
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="put(Object, Object) with null key")
        default public void testPutWithNullKey(TestInfo testInfo) {
            Map map = this.map();
            StoreNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullKeyNotSupported.class);
            Object nonContainedValue = this.nonContainedEntries().values().iterator().next();
            if (annotation == null) {
                Assertions.assertNull(map.put(null, nonContainedValue));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.put(null, nonContainedValue));
            }
            if (annotation == null) {
                HashMap expectedEntries = new HashMap(this.expectedEntries());
                expectedEntries.put(null, nonContainedValue);
                Assertions.assertEquals(expectedEntries, map);
            } else {
                Assertions.assertEquals(this.expectedEntries(), map);
            }
        }

        @Test
        @DisplayName(value="put(Object, Object) with null value")
        default public void testPutWithNullValue(TestInfo testInfo) {
            Map map = this.map();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            Map<Object, Object> expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                if (annotation == null) {
                    Assertions.assertEquals(entry.getValue(), map.put(entry.getKey(), null));
                    continue;
                }
                Assertions.assertThrows(annotation.expected(), () -> map.put(entry.getKey(), null));
            }
            if (annotation == null) {
                expectedEntries = new HashMap(expectedEntries);
                expectedEntries.replaceAll((k, v) -> null);
                Assertions.assertEquals(expectedEntries, map);
            } else {
                Assertions.assertEquals(this.expectedEntries(), map);
            }
        }
    }

    @DisplayName(value="get(Object)")
    public static interface GetTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="get(Object)")
        default public void testGet() {
            Map map = this.map();
            for (Map.Entry entry : this.expectedEntries().entrySet()) {
                Assertions.assertEquals(entry.getValue(), map.get(entry.getKey()));
            }
            for (Map.Entry key : this.nonContainedEntries().keySet()) {
                Assertions.assertNull(map.get(key));
            }
        }

        @Test
        @DisplayName(value="get(Object) with null")
        default public void testGetWithNull(TestInfo testInfo) {
            Map map = this.map();
            ContainsNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertNull(map.get(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.get(null));
            }
        }

        @Test
        @DisplayName(value="get(Object) with an incompatible object")
        default public void testGetWithIncompatibleObject(TestInfo testInfo) {
            Map map = this.map();
            ContainsIncompatibleKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertNull(map.get(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.get(new IncompatibleObject()));
            }
        }
    }

    @DisplayName(value="containsValue(Object)")
    public static interface ContainsValueTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="containsValue(Object)")
        default public void testContainsValue() {
            Map map = this.map();
            for (Object o : this.expectedEntries().values()) {
                Assertions.assertTrue((boolean)map.containsValue(o));
            }
            for (Object o : this.nonContainedEntries().values()) {
                Assertions.assertFalse((boolean)map.containsValue(o));
            }
        }

        @Test
        @DisplayName(value="containsValue(Object) with null")
        default public void testContainsValueWithNull(TestInfo testInfo) {
            Map map = this.map();
            ContainsNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.containsValue(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.containsValue(null));
            }
        }

        @Test
        @DisplayName(value="containsValue(Object) with an incompatible object")
        default public void testContainsValueWithIncompatibleObject(TestInfo testInfo) {
            Map map = this.map();
            ContainsIncompatibleNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.containsValue(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.containsValue(new IncompatibleObject()));
            }
        }
    }

    @DisplayName(value="containsKey(Object)")
    public static interface ContainsKeyTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="containsKey(Object)")
        default public void testContainsKey() {
            Map map = this.map();
            for (Object o : this.expectedEntries().keySet()) {
                Assertions.assertTrue((boolean)map.containsKey(o));
            }
            for (Object o : this.nonContainedEntries().keySet()) {
                Assertions.assertFalse((boolean)map.containsKey(o));
            }
        }

        @Test
        @DisplayName(value="containsKey(Object) with null")
        default public void testContainsKeyWithNull(TestInfo testInfo) {
            Map map = this.map();
            ContainsNullKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsNullKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.containsKey(null));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.containsKey(null));
            }
        }

        @Test
        @DisplayName(value="containsKey(Object) with an incompatible object")
        default public void testContainsKeyWithIncompatibleObject(TestInfo testInfo) {
            Map map = this.map();
            ContainsIncompatibleKeyNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(ContainsIncompatibleKeyNotSupported.class);
            if (annotation == null) {
                Assertions.assertFalse((boolean)map.containsKey(new IncompatibleObject()));
            } else {
                Assertions.assertThrows(annotation.expected(), () -> map.containsKey(new IncompatibleObject()));
            }
        }
    }
}

