/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionTests;
import com.github.robtimus.junit.support.test.collections.annotation.StoreNullNotSupported;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public interface SetTests<T>
extends CollectionTests<T> {
    @Override
    public Set<T> iterable();

    public static final class EqualsArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            EqualsTests instance = (EqualsTests)context.getRequiredTestInstance();
            ArrayList expected = new ArrayList(instance.expectedElements());
            Object nonContained = instance.nonContainedElements().iterator().next();
            ArrayList<Arguments> arguments = new ArrayList<Arguments>();
            arguments.add(Arguments.arguments((Object[])new Object[]{new HashSet(expected), true}));
            if (!expected.isEmpty()) {
                arguments.add(Arguments.arguments((Object[])new Object[]{new HashSet(expected.subList(0, expected.size() - 1)), false}));
            }
            HashSet withNonContained = new HashSet(expected);
            withNonContained.add(nonContained);
            arguments.add(Arguments.arguments((Object[])new Object[]{withNonContained, false}));
            return arguments.stream();
        }
    }

    public static final class AddAllArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            AddAllTests instance = (AddAllTests)context.getRequiredTestInstance();
            ArrayList expected = new ArrayList(instance.expectedElements());
            Object nonContained = instance.nonContainedElements().iterator().next();
            ArrayList<Arguments> arguments = new ArrayList<Arguments>();
            for (int i = 0; i <= expected.size(); ++i) {
                arguments.add(Arguments.arguments((Object[])new Object[]{new ArrayList(expected.subList(0, i)), false}));
                ArrayList withNonContained = new ArrayList(expected.subList(0, i));
                withNonContained.add(nonContained);
                arguments.add(Arguments.arguments((Object[])new Object[]{withNonContained, true}));
            }
            return arguments.stream();
        }
    }

    public static final class AddArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            AddTests instance = (AddTests)context.getRequiredTestInstance();
            Stream<Arguments> expected = instance.expectedElements().stream().map(e -> Arguments.arguments((Object[])new Object[]{e, false}));
            Stream<Arguments> notExpected = instance.nonContainedElements().stream().map(e -> Arguments.arguments((Object[])new Object[]{e, true}));
            return Stream.of(expected, notExpected).flatMap(Function.identity());
        }
    }

    @DisplayName(value="spliterator()")
    public static interface SpliteratorTests<T>
    extends SetTests<T> {
        @Test
        @DisplayName(value="spliterator() has DISTINCT characteristic")
        default public void testSpliteratorHasDistinctCharacteristic() {
            Collection set = this.iterable();
            Spliterator spliterator = set.spliterator();
            Assertions.assertTrue((boolean)spliterator.hasCharacteristics(1));
        }
    }

    @DisplayName(value="hashCode()")
    public static interface HashCodeTests<T>
    extends SetTests<T> {
        @Test
        @DisplayName(value="hashCode()")
        default public void testHashCode() {
            Collection set = this.iterable();
            int expected = this.expectedElements().stream().mapToInt(Object::hashCode).sum();
            Assertions.assertEquals((int)expected, (int)set.hashCode());
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="equals(Object)")
    public static interface EqualsTests<T>
    extends SetTests<T> {
        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=EqualsArgumentsProvider.class)
        @DisplayName(value="equals(Object)")
        default public void testEquals(Set<?> other, boolean expected) {
            Collection set = this.iterable();
            if (expected) {
                Assertions.assertEquals(other, (Object)set);
            } else {
                Assertions.assertNotEquals(other, (Object)set);
            }
        }

        @Test
        @DisplayName(value="equals(Object) with self")
        default public void testEqualsSelf() {
            Collection set = this.iterable();
            Assertions.assertEquals((Object)set, (Object)set);
        }

        @Test
        @DisplayName(value="equals(Object) with null")
        default public void testEqualsNull() {
            Collection set = this.iterable();
            Assertions.assertNotEquals(null, (Object)set);
        }

        @Test
        @DisplayName(value="equals(Object) with list")
        default public void testEqualsList() {
            Collection set = this.iterable();
            Assertions.assertNotEquals(new ArrayList(set), (Object)set);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="addAll(Collection)")
    public static interface AddAllTests<T>
    extends SetTests<T> {
        default public void addElementsToExpected(List<T> expected, Collection<? extends T> elements) {
            expected.addAll(elements);
        }

        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=AddAllArgumentsProvider.class)
        @DisplayName(value="addAll(Collection)")
        default public void testAddAll(Collection<? extends T> c, boolean expected) {
            Collection set = this.iterable();
            Assertions.assertEquals((Object)expected, (Object)set.addAll(c));
            Collection expectedElements = this.expectedElements();
            if (expected) {
                expectedElements = new ArrayList(expectedElements);
                this.addElementsToExpected((List)expectedElements, c);
                expectedElements = new LinkedHashSet(expectedElements);
            }
            CollectionAssertions.assertHasElements(set, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="addAll(Collection) with a null collection")
        default public void testAddAllWithNullCollection() {
            Collection set = this.iterable();
            Assertions.assertThrows(NullPointerException.class, () -> AddAllTests.lambda$testAddAllWithNullCollection$0((Set)set));
            CollectionAssertions.assertHasElements(set, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="addAll(Collection) with a collection with a null")
        default public void testAddAllWithCollectionWithNull(TestInfo testInfo) {
            Collection set = this.iterable();
            Set<Object> c = Collections.singleton(null);
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            Collection expectedElements = this.expectedElements();
            if (annotation == null) {
                Assertions.assertTrue((boolean)set.addAll(c));
                expectedElements = new ArrayList(expectedElements);
                this.addElementsToExpected((List)expectedElements, c);
                expectedElements = new LinkedHashSet(expectedElements);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> AddAllTests.lambda$testAddAllWithCollectionWithNull$2((Set)set, c));
            }
            CollectionAssertions.assertHasElements(set, expectedElements, this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testAddAllWithCollectionWithNull$2(Set set, Collection c) throws Throwable {
            set.addAll(c);
        }

        private static /* synthetic */ void lambda$testAddAllWithNullCollection$0(Set set) throws Throwable {
            set.addAll(null);
        }
    }

    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="add(Object)")
    public static interface AddTests<T>
    extends SetTests<T> {
        default public void addElementToExpected(List<T> expected, T element) {
            expected.add(element);
        }

        @ParameterizedTest(name="{0}: {1}")
        @ArgumentsSource(value=AddArgumentsProvider.class)
        @DisplayName(value="add(Object)")
        default public void testAdd(T o, boolean expected) {
            Collection set = this.iterable();
            Assertions.assertEquals((Object)expected, (Object)set.add(o));
            Collection expectedElements = this.expectedElements();
            if (expected) {
                expectedElements = new ArrayList(expectedElements);
                this.addElementToExpected((List)expectedElements, o);
            }
            CollectionAssertions.assertHasElements(set, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="add(Object) with null")
        default public void testAddNull(TestInfo testInfo) {
            Collection set = this.iterable();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            Collection expectedElements = this.expectedElements();
            if (annotation == null) {
                Assertions.assertTrue((boolean)set.add(null));
                expectedElements = new ArrayList(expectedElements);
                this.addElementToExpected((List)expectedElements, null);
            } else {
                Assertions.assertThrows(annotation.expected(), () -> AddTests.lambda$testAddNull$1((Set)set));
            }
            CollectionAssertions.assertHasElements(set, expectedElements, this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testAddNull$1(Set set) throws Throwable {
            set.add(null);
        }
    }
}

