/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Spliterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface SpliteratorTests<T> {
    public Iterable<T> iterable();

    public Collection<T> expectedElements();

    public boolean fixedOrder();

    @DisplayName(value="forEachRemaining(Consumer)")
    public static interface ForEachRemainingTests<T>
    extends SpliteratorTests<T> {
        @Test
        @DisplayName(value="forEachRemaining(Consumer)")
        default public void testForEachRemaining() {
            Iterable iterable = this.iterable();
            Spliterator<Object> spliterator = iterable.spliterator();
            ArrayList expectedElements = new ArrayList(this.expectedElements());
            int skip = 2;
            while (skip > 0) {
                if (spliterator.tryAdvance(expectedElements::remove)) continue;
            }
            ArrayList remaining = new ArrayList();
            spliterator.forEachRemaining(remaining::add);
            CollectionAssertions.assertHasElements(remaining, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="forEachRemaining(Consumer) with null consumer")
        default public void testForEachRemainingWithNullConsumer() {
            Iterable iterable = this.iterable();
            Spliterator<Object> spliterator = iterable.spliterator();
            Assertions.assertThrows(NullPointerException.class, () -> spliterator.forEachRemaining(null));
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            for (int i = 0; i < expectedElements.size(); ++i) {
                Assertions.assertTrue((boolean)spliterator.tryAdvance(elements::add));
                Assertions.assertThrows(NullPointerException.class, () -> spliterator.forEachRemaining(null));
            }
            Assertions.assertFalse((boolean)spliterator.tryAdvance(elements::add));
            Assertions.assertThrows(NullPointerException.class, () -> spliterator.forEachRemaining(null));
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }
    }

    @DisplayName(value="tryAdvance(Consumer)")
    public static interface TryAdvanceTests<T>
    extends SpliteratorTests<T> {
        @Test
        @DisplayName(value="tryAdvance(Consumer)")
        default public void testTryAdvance() {
            Iterable iterable = this.iterable();
            Spliterator<Object> spliterator = iterable.spliterator();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            for (int i = 0; i < expectedElements.size(); ++i) {
                Assertions.assertTrue((boolean)spliterator.tryAdvance(elements::add));
            }
            Assertions.assertFalse((boolean)spliterator.tryAdvance(elements::add));
            CollectionAssertions.assertHasElements(elements, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="tryAdvance(Consumer) with null consumer")
        default public void testTryAdvanceWithNullConsumer() {
            Iterable iterable = this.iterable();
            Spliterator spliterator = iterable.spliterator();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements.size());
            for (int i = 0; i < expectedElements.size(); ++i) {
                Assertions.assertThrows(NullPointerException.class, () -> spliterator.tryAdvance(null));
            }
            Assertions.assertThrows(NullPointerException.class, () -> spliterator.tryAdvance(null));
            CollectionAssertions.assertHasElements(elements, Collections.emptyList(), this.fixedOrder());
        }
    }
}

