/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionTests;
import com.github.robtimus.junit.support.test.collections.IncompatibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface UnmodifiableCollectionTests<T>
extends CollectionTests<T> {

    @DisplayName(value="clear()")
    public static interface ClearTests<T>
    extends UnmodifiableCollectionTests<T> {
        @Test
        @DisplayName(value="clear()")
        default public void testClear() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, ((Collection)collection)::clear);
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }
    }

    @DisplayName(value="retainAll(Collection)")
    public static interface RetainAllTests<T>
    extends UnmodifiableCollectionTests<T> {
        @Test
        @DisplayName(value="retainAll(Collection) with contained elements")
        default public void testRetainAllWithContainedElements() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements);
            int i = 0;
            while (i < elements.size()) {
                int to = i++;
                Assertions.assertThrows(UnsupportedOperationException.class, () -> RetainAllTests.lambda$testRetainAllWithContainedElements$0((Collection)collection, elements, to));
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Collection) with non-contained elements")
        default public void testRetainAllWithNonContainedElements() {
            Iterable collection = this.iterable();
            ArrayList elements = new ArrayList(this.nonContainedElements());
            int i = 0;
            while (i <= elements.size()) {
                int to = i++;
                Assertions.assertThrows(UnsupportedOperationException.class, () -> RetainAllTests.lambda$testRetainAllWithNonContainedElements$1((Collection)collection, elements, to));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Collection) with all contained elements")
        default public void testRetainAllWithAllContainedElements() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RetainAllTests.lambda$testRetainAllWithAllContainedElements$2((Collection)collection, expectedElements));
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Object) with null")
        default public void testRetainAllWithNull() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> RetainAllTests.lambda$testRetainAllWithNull$3((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Object) with null element")
        default public void testRetainAllWithNullElement() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> RetainAllTests.lambda$testRetainAllWithNullElement$4((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="retainAll(Object) with an incompatible object")
        default public void testRetainAllWithIncompatibleObject() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> RetainAllTests.lambda$testRetainAllWithIncompatibleObject$5((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRetainAllWithIncompatibleObject$5(Collection collection) throws Throwable {
            collection.retainAll(Collections.singleton(new IncompatibleObject()));
        }

        private static /* synthetic */ void lambda$testRetainAllWithNullElement$4(Collection collection) throws Throwable {
            collection.retainAll(Collections.singleton(null));
        }

        private static /* synthetic */ void lambda$testRetainAllWithNull$3(Collection collection) throws Throwable {
            collection.retainAll(null);
        }

        private static /* synthetic */ void lambda$testRetainAllWithAllContainedElements$2(Collection collection, Collection expectedElements) throws Throwable {
            Assertions.assertFalse((boolean)collection.retainAll(expectedElements));
        }

        private static /* synthetic */ void lambda$testRetainAllWithNonContainedElements$1(Collection collection, List elements, int to) throws Throwable {
            collection.retainAll(elements.subList(0, to));
        }

        private static /* synthetic */ void lambda$testRetainAllWithContainedElements$0(Collection collection, List elements, int to) throws Throwable {
            collection.retainAll(elements.subList(0, to));
        }
    }

    @DisplayName(value="removeIf(Predicate)")
    public static interface RemoveIfTests<T>
    extends UnmodifiableCollectionTests<T> {
        @Test
        @DisplayName(value="removeIf(Predicate) with matching predicate")
        default public void testRemoveIfWithMatchingPredicate() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> RemoveIfTests.lambda$testRemoveIfWithMatchingPredicate$1((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeIf(Predicate) with non-matching predicate")
        default public void testRemoveIfWithNonMatchingPredicate() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveIfTests.lambda$testRemoveIfWithNonMatchingPredicate$3((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeIf(Predicate) with null predicate")
        default public void testRemoveIfWithNullPredicate() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> RemoveIfTests.lambda$testRemoveIfWithNullPredicate$4((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRemoveIfWithNullPredicate$4(Collection collection) throws Throwable {
            collection.removeIf(null);
        }

        private static /* synthetic */ void lambda$testRemoveIfWithNonMatchingPredicate$3(Collection collection) throws Throwable {
            Assertions.assertFalse((boolean)collection.removeIf(e -> false));
        }

        private static /* synthetic */ void lambda$testRemoveIfWithMatchingPredicate$1(Collection collection) throws Throwable {
            collection.removeIf(e -> true);
        }
    }

    @DisplayName(value="removeAll(Collection)")
    public static interface RemoveAllTests<T>
    extends UnmodifiableCollectionTests<T> {
        @Test
        @DisplayName(value="removeAll(Collection) with contained elements")
        default public void testRemoveAllWithContainedElements() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements);
            int i = 1;
            while (i <= elements.size()) {
                int to = i++;
                Assertions.assertThrows(UnsupportedOperationException.class, () -> RemoveAllTests.lambda$testRemoveAllWithContainedElements$0((Collection)collection, elements, to));
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Collection) with non-contained elements")
        default public void testRemoveAllWithNonContainedElements() {
            Iterable collection = this.iterable();
            ArrayList elements = new ArrayList(this.nonContainedElements());
            int i = 1;
            while (i <= elements.size()) {
                int to = i++;
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveAllTests.lambda$testRemoveAllWithNonContainedElements$1((Collection)collection, elements, to));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Collection) with an empty collection")
        default public void testRemoveAllWithEmptyCollection() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveAllTests.lambda$testRemoveAllWithEmptyCollection$2((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Object) with null")
        default public void testRemoveAllWithNull() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> RemoveAllTests.lambda$testRemoveAllWithNull$3((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Object) with null element")
        default public void testRemoveAllWithNullElement() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveAllTests.lambda$testRemoveAllWithNullElement$4((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="removeAll(Object) with an incompatible object")
        default public void testRemoveAllWithIncompatibleObject() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveAllTests.lambda$testRemoveAllWithIncompatibleObject$5((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRemoveAllWithIncompatibleObject$5(Collection collection) throws Throwable {
            Assertions.assertFalse((boolean)collection.removeAll(Collections.singleton(new IncompatibleObject())));
        }

        private static /* synthetic */ void lambda$testRemoveAllWithNullElement$4(Collection collection) throws Throwable {
            Assertions.assertFalse((boolean)collection.removeAll(Collections.singleton(null)));
        }

        private static /* synthetic */ void lambda$testRemoveAllWithNull$3(Collection collection) throws Throwable {
            collection.removeAll(null);
        }

        private static /* synthetic */ void lambda$testRemoveAllWithEmptyCollection$2(Collection collection) throws Throwable {
            Assertions.assertFalse((boolean)collection.removeAll(Collections.emptyList()));
        }

        private static /* synthetic */ void lambda$testRemoveAllWithNonContainedElements$1(Collection collection, List elements, int to) throws Throwable {
            Assertions.assertFalse((boolean)collection.removeAll(elements.subList(0, to)));
        }

        private static /* synthetic */ void lambda$testRemoveAllWithContainedElements$0(Collection collection, List elements, int to) throws Throwable {
            collection.removeAll(elements.subList(0, to));
        }
    }

    @DisplayName(value="addAll(Collection)")
    public static interface AddAllTests<T>
    extends UnmodifiableCollectionTests<T> {
        @Test
        @DisplayName(value="addAll(Collection) with contained elements")
        default public void testAddAllWithContainedElements() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements);
            int i = 1;
            while (i <= elements.size()) {
                int to = i++;
                Assertions.assertThrows(UnsupportedOperationException.class, () -> AddAllTests.lambda$testAddAllWithContainedElements$0((Collection)collection, elements, to));
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="addAll(Collection) with non-contained elements")
        default public void testAddAllWithNonContainedElements() {
            Iterable collection = this.iterable();
            ArrayList elements = new ArrayList(this.nonContainedElements());
            int i = 1;
            while (i <= elements.size()) {
                int to = i++;
                Assertions.assertThrows(UnsupportedOperationException.class, () -> AddAllTests.lambda$testAddAllWithNonContainedElements$1((Collection)collection, elements, to));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="addAll(Collection) with an empty collection")
        default public void testAddAllWithEmptyCollection() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> AddAllTests.lambda$testAddAllWithEmptyCollection$2((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="addAll(Collection) with null")
        default public void testAddAllWithNull() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> AddAllTests.lambda$testAddAllWithNull$3((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="addAll(Collection) with null element")
        default public void testAddAllWithNullElement() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> AddAllTests.lambda$testAddAllWithNullElement$4((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testAddAllWithNullElement$4(Collection collection) throws Throwable {
            collection.addAll(Collections.singleton(null));
        }

        private static /* synthetic */ void lambda$testAddAllWithNull$3(Collection collection) throws Throwable {
            collection.addAll(null);
        }

        private static /* synthetic */ void lambda$testAddAllWithEmptyCollection$2(Collection collection) throws Throwable {
            Assertions.assertFalse((boolean)collection.addAll(Collections.emptyList()));
        }

        private static /* synthetic */ void lambda$testAddAllWithNonContainedElements$1(Collection collection, List elements, int to) throws Throwable {
            collection.addAll(elements.subList(0, to));
        }

        private static /* synthetic */ void lambda$testAddAllWithContainedElements$0(Collection collection, List elements, int to) throws Throwable {
            collection.addAll(elements.subList(0, to));
        }
    }

    @DisplayName(value="remove(Object)")
    public static interface RemoveTests<T>
    extends UnmodifiableCollectionTests<T> {
        @Test
        @DisplayName(value="remove(Object) with contained elements")
        default public void testRemoveContainedElements() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object element : expectedElements) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> RemoveTests.lambda$testRemoveContainedElements$0((Collection)collection, element));
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove(Object) with non-contained elements")
        default public void testRemoveNonContainedElements() {
            Iterable collection = this.iterable();
            for (Object element : this.nonContainedElements()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveTests.lambda$testRemoveNonContainedElements$1((Collection)collection, element));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove(Object) with null")
        default public void testRemoveNull() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveTests.lambda$testRemoveNull$2((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="remove(Object) with an incompatible object")
        default public void testRemoveIncompatibleObject() {
            Iterable collection = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> RemoveTests.lambda$testRemoveIncompatibleObject$3((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testRemoveIncompatibleObject$3(Collection collection) throws Throwable {
            Assertions.assertFalse((boolean)collection.remove(new IncompatibleObject()));
        }

        private static /* synthetic */ void lambda$testRemoveNull$2(Collection collection) throws Throwable {
            Assertions.assertFalse((boolean)collection.remove(null));
        }

        private static /* synthetic */ void lambda$testRemoveNonContainedElements$1(Collection collection, Object element) throws Throwable {
            Assertions.assertFalse((boolean)collection.remove(element));
        }

        private static /* synthetic */ void lambda$testRemoveContainedElements$0(Collection collection, Object element) throws Throwable {
            collection.remove(element);
        }
    }

    @DisplayName(value="add(Object)")
    public static interface AddTests<T>
    extends UnmodifiableCollectionTests<T> {
        @Test
        @DisplayName(value="add(Object) with contained elements")
        default public void testAddContainedElements() {
            Iterable collection = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object element : expectedElements) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> AddTests.lambda$testAddContainedElements$0((Collection)collection, element));
            }
            CollectionAssertions.assertHasElements(collection, expectedElements, this.fixedOrder());
        }

        @Test
        @DisplayName(value="add(Object) with non-contained elements")
        default public void testAddNonContainedElements() {
            Iterable collection = this.iterable();
            for (Object element : this.nonContainedElements()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> AddTests.lambda$testAddNonContainedElements$1((Collection)collection, element));
            }
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        @Test
        @DisplayName(value="add(Object) with null")
        default public void testAddNull() {
            Iterable collection = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> AddTests.lambda$testAddNull$2((Collection)collection));
            CollectionAssertions.assertHasElements(collection, this.expectedElements(), this.fixedOrder());
        }

        private static /* synthetic */ void lambda$testAddNull$2(Collection collection) throws Throwable {
            collection.add(null);
        }

        private static /* synthetic */ void lambda$testAddNonContainedElements$1(Collection collection, Object element) throws Throwable {
            collection.add(element);
        }

        private static /* synthetic */ void lambda$testAddContainedElements$0(Collection collection, Object element) throws Throwable {
            collection.add(element);
        }
    }
}

