/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionUtils;
import com.github.robtimus.junit.support.test.collections.IteratorTests;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface UnmodifiableIteratorTests<T>
extends IteratorTests<T> {

    @DisplayName(value="remove()")
    public static interface RemoveTests<T>
    extends UnmodifiableIteratorTests<T> {
        @Test
        @DisplayName(value="remove() throws UnsupportedOperationException")
        default public void testRemove() {
            Iterable iterable = this.iterable();
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                Assertions.assertThrows(UnsupportedOperationException.class, iterator::remove);
            }
            List remaining = CollectionUtils.toList(iterable);
            CollectionAssertions.assertHasElements(remaining, this.expectedElements(), this.fixedOrder());
        }
    }
}

