/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.collections.ListIteratorTests;
import com.github.robtimus.junit.support.test.collections.annotation.StoreNullNotSupported;
import java.util.Collection;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public interface UnmodifiableListIteratorTests<T>
extends ListIteratorTests<T> {

    @DisplayName(value="add(Object)")
    public static interface AddTests<T>
    extends ListIteratorTests<T> {
        public T newElement();

        @Test
        @DisplayName(value="add(Object) using next()")
        default public void testAddUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            Object newElement = this.newElement();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(newElement));
            while (iterator.hasNext()) {
                iterator.next();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(newElement));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="add(Object) with null using next()")
        default public void testAddNullUsingNext(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(null));
            } else {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, annotation.expected(), () -> iterator.add(null));
            }
            while (iterator.hasNext()) {
                iterator.next();
                if (annotation == null) {
                    Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(null));
                    continue;
                }
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, annotation.expected(), () -> iterator.add(null));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="add(Object) using previous()")
        default public void testAddUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            Object newElement = this.newElement();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(newElement));
            while (iterator.hasPrevious()) {
                iterator.previous();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(newElement));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="add(Object) with null using previous()")
        default public void testAddNullUsingPrevious(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            if (annotation == null) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(null));
            } else {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, annotation.expected(), () -> iterator.add(null));
            }
            while (iterator.hasPrevious()) {
                iterator.previous();
                if (annotation == null) {
                    Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.add(null));
                    continue;
                }
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, annotation.expected(), () -> iterator.add(null));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }
    }

    @DisplayName(value="set(Object)")
    public static interface SetTests<T>
    extends UnmodifiableListIteratorTests<T> {
        public UnaryOperator<T> replaceElementOperator();

        default public T singleElement() {
            Collection expectedElements = this.expectedElements();
            return (T)expectedElements.get(expectedElements.size() / 2);
        }

        @Test
        @DisplayName(value="set(Object) using next() throws UnsupportedOperationException")
        default public void testSetUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            UnaryOperator operator = this.replaceElementOperator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.set(operator.apply(element)));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) with null replacement using next()")
        default public void testSetWithNullReplacementUsingNext(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            while (iterator.hasNext()) {
                iterator.next();
                if (annotation == null) {
                    Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.set(null));
                    continue;
                }
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, annotation.expected(), () -> iterator.set(null));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) before next()")
        default public void testSetBeforeNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            Object element = this.singleElement();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IllegalStateException.class, () -> iterator.set(element));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) using previous() throws UnsupportedOperationException")
        default public void testSetUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            UnaryOperator operator = this.replaceElementOperator();
            while (iterator.hasPrevious()) {
                Object element = iterator.previous();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.set(operator.apply(element)));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) with null replacement using previous()")
        default public void testSetWithNullReplacementUsingPrevious(TestInfo testInfo) {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            StoreNullNotSupported annotation = ((Class)testInfo.getTestClass().orElseThrow(() -> new IllegalStateException("test class should be available"))).getAnnotation(StoreNullNotSupported.class);
            while (iterator.hasPrevious()) {
                iterator.previous();
                if (annotation == null) {
                    Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.set(null));
                    continue;
                }
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, annotation.expected(), () -> iterator.set(null));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="set(Object) before previous()")
        default public void testSetBeforePrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            Object element = this.singleElement();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IllegalStateException.class, () -> iterator.set(element));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }
    }

    @DisplayName(value="remove()")
    public static interface RemoveTests<T>
    extends UnmodifiableListIteratorTests<T> {
        @Test
        @DisplayName(value="remove() using next() throws UnsupportedOperationException")
        default public void testRemoveUsingNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            while (iterator.hasNext()) {
                iterator.next();
                Assertions.assertThrows(UnsupportedOperationException.class, iterator::remove);
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove() before next()")
        default public void testRemoveBeforeNext() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IllegalStateException.class, iterator::remove);
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove() using previous() throws UnsupportedOperationException")
        default public void testRemoveUsingPrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            while (iterator.hasPrevious()) {
                iterator.previous();
                Assertions.assertThrows(UnsupportedOperationException.class, iterator::remove);
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove() before previous()")
        default public void testRemoveBeforePrevious() {
            Iterable list = this.iterable();
            ListIterator iterator = list.listIterator(list.size());
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IllegalStateException.class, iterator::remove);
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }
    }
}

