/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.collections.ListTests;
import com.github.robtimus.junit.support.test.collections.UnmodifiableCollectionTests;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface UnmodifiableListTests<T>
extends ListTests<T>,
UnmodifiableCollectionTests<T> {

    @DisplayName(value="remove(int)")
    public static interface RemoveIndexedTests<T>
    extends ListTests<T> {
        @Test
        @DisplayName(value="remove(int)")
        default public void testRemoveIndexed() {
            Collection list = this.iterable();
            int i = list.size() - 1;
            while (i >= 0) {
                int index = i--;
                Assertions.assertThrows(UnsupportedOperationException.class, () -> RemoveIndexedTests.lambda$testRemoveIndexed$0((List)list, index));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove(int) with negative index")
        default public void testRemoveIndexedWithNegativeIndex() {
            Collection list = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IndexOutOfBoundsException.class, () -> RemoveIndexedTests.lambda$testRemoveIndexedWithNegativeIndex$1((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="remove(int) with index equal to size")
        default public void testRemoveIndexedWithIndexEqualToSize() {
            Collection list = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IndexOutOfBoundsException.class, () -> RemoveIndexedTests.lambda$testRemoveIndexedWithIndexEqualToSize$2((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testRemoveIndexedWithIndexEqualToSize$2(List list) throws Throwable {
            list.remove(list.size());
        }

        private static /* synthetic */ void lambda$testRemoveIndexedWithNegativeIndex$1(List list) throws Throwable {
            list.remove(-1);
        }

        private static /* synthetic */ void lambda$testRemoveIndexed$0(List list, int index) throws Throwable {
            list.remove(index);
        }
    }

    @DisplayName(value="addAll(int, Collection)")
    public static interface AddAllIndexedTests<T>
    extends UnmodifiableListTests<T> {
        @Test
        @DisplayName(value="addAll(int, Collection)")
        default public void testAddAllIndexed() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            ArrayList elements = new ArrayList(expectedElements);
            int i = 1;
            while (i <= elements.size()) {
                int to = i++;
                Assertions.assertThrows(UnsupportedOperationException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexed$0((List)list, elements, to));
            }
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with empty collection")
        default public void testAddAllIndexedWithEmptyCollection() {
            Collection list = this.iterable();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithEmptyCollection$1((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with null")
        default public void testAddAllIndexedWithNull() {
            Collection list = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithNull$2((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with null element")
        default public void testAddAllIndexedWithNullElement() {
            Collection list = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithNullElement$3((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with negative index")
        default public void testAddAllIndexedWithNegativeIndex() {
            Collection list = this.iterable();
            Set c = Collections.singleton(this.nonContainedElements().iterator().next());
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IndexOutOfBoundsException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithNegativeIndex$4((List)list, c));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="addAll(int, Collection) with index larger than size")
        default public void testAddAllIndexedWithIndexLargerThanSize() {
            Collection list = this.iterable();
            Set c = Collections.singleton(this.nonContainedElements().iterator().next());
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IndexOutOfBoundsException.class, () -> AddAllIndexedTests.lambda$testAddAllIndexedWithIndexLargerThanSize$5((List)list, c));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithIndexLargerThanSize$5(List list, Collection c) throws Throwable {
            list.addAll(list.size() + 1, c);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithNegativeIndex$4(List list, Collection c) throws Throwable {
            list.addAll(-1, c);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithNullElement$3(List list) throws Throwable {
            list.addAll(0, Collections.singleton(null));
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithNull$2(List list) throws Throwable {
            list.addAll(0, null);
        }

        private static /* synthetic */ void lambda$testAddAllIndexedWithEmptyCollection$1(List list) throws Throwable {
            Assertions.assertFalse((boolean)list.addAll(0, Collections.emptyList()));
        }

        private static /* synthetic */ void lambda$testAddAllIndexed$0(List list, List elements, int to) throws Throwable {
            list.addAll(0, elements.subList(0, to));
        }
    }

    @DisplayName(value="add(int, Object)")
    public static interface AddIndexedTests<T>
    extends UnmodifiableListTests<T> {
        @Test
        @DisplayName(value="add(int, Object)")
        default public void testAddIndexed() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            for (Object element : expectedElements) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> AddIndexedTests.lambda$testAddIndexed$0((List)list, element));
            }
            for (Object element : this.nonContainedElements()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> AddIndexedTests.lambda$testAddIndexed$1((List)list, element));
            }
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with null")
        default public void testAddIndexedWithNull() {
            Collection list = this.iterable();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> AddIndexedTests.lambda$testAddIndexedWithNull$2((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with negative index")
        default public void testAddIndexedWithNegativeIndex() {
            Collection list = this.iterable();
            Object object = this.nonContainedElements().iterator().next();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IndexOutOfBoundsException.class, () -> AddIndexedTests.lambda$testAddIndexedWithNegativeIndex$3((List)list, object));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="add(int, Object) with index larger than size")
        default public void testAddIndexedWithIndexLargerThanSize() {
            Collection list = this.iterable();
            Object object = this.nonContainedElements().iterator().next();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, IndexOutOfBoundsException.class, () -> AddIndexedTests.lambda$testAddIndexedWithIndexLargerThanSize$4((List)list, object));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testAddIndexedWithIndexLargerThanSize$4(List list, Object object) throws Throwable {
            list.set(list.size() + 1, object);
        }

        private static /* synthetic */ void lambda$testAddIndexedWithNegativeIndex$3(List list, Object object) throws Throwable {
            list.add(-1, object);
        }

        private static /* synthetic */ void lambda$testAddIndexedWithNull$2(List list) throws Throwable {
            list.add(0, null);
        }

        private static /* synthetic */ void lambda$testAddIndexed$1(List list, Object element) throws Throwable {
            list.add(0, element);
        }

        private static /* synthetic */ void lambda$testAddIndexed$0(List list, Object element) throws Throwable {
            list.add(0, element);
        }
    }

    @DisplayName(value="set(int, Object)")
    public static interface SetTests<T>
    extends ListTests<T> {
        public UnaryOperator<T> replaceElementOperator();

        @Test
        @DisplayName(value="set(int, Object)")
        default public void testSet() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            UnaryOperator<T> operator = this.replaceElementOperator();
            ListIterator i = expectedElements.listIterator();
            while (i.hasNext()) {
                int index = i.nextIndex();
                Object element = i.next();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> SetTests.lambda$testSet$0((List)list, index, operator, element));
            }
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }

        @Test
        @DisplayName(value="set(int, Object) with null replacement")
        default public void testSetWithNullReplacement() {
            Collection list = this.iterable();
            Collection expectedElements = this.expectedElements();
            ListIterator i = expectedElements.listIterator();
            while (i.hasNext()) {
                int index = i.nextIndex();
                i.next();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> SetTests.lambda$testSetWithNullReplacement$1((List)list, index));
            }
            Assertions.assertEquals((Object)expectedElements, (Object)list);
        }

        private static /* synthetic */ void lambda$testSetWithNullReplacement$1(List list, int index) throws Throwable {
            list.set(index, null);
        }

        private static /* synthetic */ void lambda$testSet$0(List list, int index, UnaryOperator operator, Object element) throws Throwable {
            list.set(index, operator.apply(element));
        }
    }

    @DisplayName(value="replaceAll(UnaryOperator)")
    public static interface ReplaceAllTests<T>
    extends ListTests<T> {
        public UnaryOperator<T> replaceElementOperator();

        @Test
        @DisplayName(value="replaceAll(UnaryOperator)")
        default public void testReplaceAll() {
            Collection list = this.iterable();
            UnaryOperator<T> operator = this.replaceElementOperator();
            if (list.isEmpty()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> ReplaceAllTests.lambda$testReplaceAll$0((List)list, operator));
            } else {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> ReplaceAllTests.lambda$testReplaceAll$1((List)list, operator));
            }
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        @Test
        @DisplayName(value="replaceAll(UnaryOperator) with null operator")
        default public void testReplaceAllWithNullOperator() {
            Collection list = this.iterable();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> ReplaceAllTests.lambda$testReplaceAllWithNullOperator$2((List)list));
            Assertions.assertEquals((Object)this.expectedElements(), (Object)list);
        }

        private static /* synthetic */ void lambda$testReplaceAllWithNullOperator$2(List list) throws Throwable {
            list.replaceAll(null);
        }

        private static /* synthetic */ void lambda$testReplaceAll$1(List list, UnaryOperator operator) throws Throwable {
            list.replaceAll(operator);
        }

        private static /* synthetic */ void lambda$testReplaceAll$0(List list, UnaryOperator operator) throws Throwable {
            list.replaceAll(operator);
        }
    }
}

